/* $Id: SearchActionListener.java 503 2012-05-23 18:14:19Z shayashi $ */
package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.JDialog;

import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.swingui.SearchDialog;

public class SearchActionListener implements ActionListener {

	private GSEditorFrame frame;
	public SearchActionListener (GSEditorFrame frame) {
		this.frame = frame;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		JDialog dialog;
		Spread spread = this.frame.getSpread();

		if(spread == null) {
			dialog = new SearchDialog(null);
		} else {
			List<Region> regions = spread.getSelectedRegions();
			if(regions.size() == 0){
				dialog = new SearchDialog(null);
			} else {
				Region region = regions.get(0);
				dialog = new SearchDialog(region);
			}
		}

		dialog.setVisible(true);	
		dialog.pack();
	}
}
