package smart_gs.util;

public class Quadruple<Fst,Snd,Thrd,Frth> {

	  private final Fst first;
	  private final Snd second;
	  private final Thrd third;
	  private final Frth fourth;

	  public Quadruple (Fst first1, Snd second1, Thrd third1, Frth fourth1) {
	    this.first = first1;
	    this.second = second1;
	    this.third = third1;
	    this.fourth = fourth1;
	  }

	  public Fst getFirst() { return first; }
	  public Snd getSecond() { return second; }
	  public Thrd getThird() { return third; }
	  public Frth getFourth() { return fourth; }

	  public int hashCode() { return first.hashCode() ^ second.hashCode() ^ third.hashCode() ^ fourth.hashCode(); }

	  public boolean equals(Object o) {
	    if (o == null) return false;
	    if (!(o instanceof Quadruple)) return false;
	    Quadruple quado = (Quadruple) o;
	    return this.first.equals(quado.getFirst()) &&
	           this.second.equals(quado.getSecond()) &&
	           this.third.equals(quado.getThird()) &&
	           this.fourth.equals(quado.getFourth());
	  }

	}