#include "global.h"
#include "struct.h"

#include "list_append.h"
#include "log.h"
#include "same_or_different.h"

#include <stdlib.h>
#include <string.h>

#include <sys/stat.h>
#include <glib.h>

long long total_byte = 0;
int cp_file_count_all = 0;

// 関数プロトタイプ
UNList * add_data(UNList *tmp_list, const char *from, const char *to, const char type);

/*******************************************************************************
連結リストに入れるデータを作成
*******************************************************************************/
UNList * add_data(UNList *tmp_list, const char *from, const char *to, const char type)
{
	// 構造体に、コピー元、コピー先、ファイルの種類、を格納
	struct cp_target *tmp = malloc(sizeof(struct cp_target));
	tmp->from = malloc(strlen(from) + 1);
	tmp->to = malloc(strlen(to) + 1);
	strcpy(tmp->from, from);
	strcpy(tmp->to, to);
	tmp->file_type = type;
	tmp->copy_mode = copy_mode;
	// 連結リストに追加
	tmp_list = list_append(tmp_list, (void *)tmp);
	cp_file_count_all++;

	// ファイルの場合、ファイルサイズを加算しておく
	if(type == REGULAR)
	{
		struct stat stat_buf;
		if(stat(from, &stat_buf) == -1)
		{
			log_errors(__FILE__, __LINE__, errno, from);
		}
		else
		{
			total_byte += stat_buf.st_size;
		}
	}

	return tmp_list;
}
