#define _XOPEN_SOURCE

#include "global.h"
#include "struct.h"
#include "enum.h"

#include "log.h"
#include "snowcp.h"

#include "autostring.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <unistd.h>
#include <alloca.h>
#include <pthread.h>

struct hash_data
{
	FILE *from_pipe;
	FILE *to_pipe;
	char *from_pipe_buf;
	char *to_pipe_buf;
	char *from_command;
	char *to_command;
	int read_size;
};

// 関数プロトタイプ
void hash_function(char *from, char *to, const char copy_mode, const char check_mode);
static void * from_check(void *tmp);
static void * to_check(void *tmp);

/*******************************************************************************
sha1sumかmd5sumを起動する
*******************************************************************************/
void hash_function(char *from, char *to, const char copy_mode, const char check_mode)
{
	struct hash_data tmp;
	char *from_su = malloc(PATH_LEN * 2);
	char *to_su = malloc(PATH_LEN * 2);
	tmp.from_pipe_buf = alloca(PATH_LEN);
	tmp.to_pipe_buf = alloca(PATH_LEN);

	// ゼロクリア。 VC++で最適化を行うと、こういうコードは除去されるらしい。
	// http://www.ipa.go.jp/security/awareness/vendor/programmingv2/contents/c606.html
	memset(tmp.from_pipe_buf, 0, PATH_LEN);
	memset(tmp.to_pipe_buf, 0, PATH_LEN);

	strcpy(from_su, from);
	strcpy(to_su, to);

	// 特殊文字の置換
	from_su = allreplace(&from_su, "(", "\\(");
	from_su = allreplace(&from_su, ")", "\\)");
	from_su = allreplace(&from_su, "[", "\\[");
	from_su = allreplace(&from_su, "]", "\\]");
	from_su = allreplace(&from_su, "{", "\\{");
	from_su = allreplace(&from_su, "}", "\\}");
	from_su = allreplace(&from_su, "<", "\\<");
	from_su = allreplace(&from_su, ">", "\\>");
	from_su = allreplace(&from_su, "\?", "\\\?");
	from_su = allreplace(&from_su, "\'", "\\\'");
	from_su = allreplace(&from_su, "\"", "\\\"");
	from_su = allreplace(&from_su, "`", "\\`"); 
	from_su = allreplace(&from_su, " ", "\\ ");
	from_su = allreplace(&from_su, "	", "\\	");
	from_su = allreplace(&from_su, ";", "\\;");
	from_su = allreplace(&from_su, "&", "\\&");
	from_su = allreplace(&from_su, "|", "\\|");
	from_su = allreplace(&from_su, "^", "\\^");
	from_su = allreplace(&from_su, "*", "\\*");
	from_su = allreplace(&from_su, "$", "\\$");

	to_su = allreplace(&to_su, "(", "\\(");
	to_su = allreplace(&to_su, ")", "\\)");
	to_su = allreplace(&to_su, "[", "\\[");
	to_su = allreplace(&to_su, "]", "\\]");
	to_su = allreplace(&to_su, "{", "\\{");
	to_su = allreplace(&to_su, "}", "\\}");
	to_su = allreplace(&to_su, "<", "\\<");
	to_su = allreplace(&to_su, ">", "\\>");
	to_su = allreplace(&to_su, "\?", "\\\?");
	to_su = allreplace(&to_su, "\'", "\\\'");
	to_su = allreplace(&to_su, "\"", "\\\"");
	to_su = allreplace(&to_su, "`", "\\`");
	to_su = allreplace(&to_su, " ", "\\ ");
	to_su = allreplace(&to_su, "	", "\\	");
	to_su = allreplace(&to_su, ";", "\\;");
	to_su = allreplace(&to_su, "&", "\\&");
	to_su = allreplace(&to_su, "|", "\\|");
	to_su = allreplace(&to_su, "^", "\\^");
	to_su = allreplace(&to_su, "*", "\\*");
	to_su = allreplace(&to_su, "$", "\\$");

	/*
	コマンド + 特殊文字を置換済みの引数がPATH_LEN × 3よりも短いという暗黙の了解。
	*/
	tmp.from_command = alloca(PATH_LEN * 3);
	tmp.to_command = alloca(PATH_LEN * 3);

	// 特殊文字を置換済みの場合、'や"で括ると動作しなくなる
	if(check_mode == SHA1SUM)
	{
		sprintf(tmp.from_command, "%s%s", "sha1sum -- ", from_su);
		sprintf(tmp.to_command, "%s%s", "sha1sum -- ", to_su);
	}
	else if(check_mode == MD5SUM)
	{
		sprintf(tmp.from_command, "%s%s", "md5sum -- ", from_su);
		sprintf(tmp.to_command, "%s%s", "md5sum -- ", to_su);
	}

	errno = 0;
	if(copy_mode == DIFFERENT)
	{
		pthread_t t1;
		pthread_t t2;
		pthread_create(&t1, NULL, from_check, (void *)&tmp);
		pthread_create(&t2, NULL, to_check, (void *)&tmp);
		pthread_join(t1, NULL);
		pthread_join(t2, NULL);
	}
	else
	{
		tmp.from_pipe = popen(tmp.from_command, "r");
		tmp.to_pipe = popen(tmp.to_command, "r");
	}

	if((tmp.from_pipe != NULL) && (tmp.to_pipe != NULL))
	{
		char c[PATH_LEN];

		tmp.read_size = fread(tmp.from_pipe_buf, 1, PATH_LEN, tmp.from_pipe);
		// パイプのバッファを空にするためにグルグル回す
		while(fread(c, 1, PATH_LEN, tmp.from_pipe) > 0) {}

		tmp.read_size = fread(tmp.to_pipe_buf, 1, PATH_LEN, tmp.to_pipe);
		while(fread(c, 1, PATH_LEN, tmp.to_pipe) > 0) {}

		// チェックしとかないと が含まれていない場合SIGSEGVで落ちる
		if(strstr(tmp.from_pipe_buf, " ") && strstr(tmp.to_pipe_buf, " "))
		{
			char *f = strtok(tmp.from_pipe_buf, " ");
			char *t = strtok(tmp.to_pipe_buf, " ");
			if((strcmp(f, t) == 0) && ((strlen(f) == 32) || (strlen(f) == 40)))
			{
				if(V == VERBOS)
					printf("%sのハッシュ値が一致しました\n", to);

				log_compares_write(from, f, to, t, true);
			}
			else
			{
				log_errors(__FILE__, __LINE__, errno, to);
				fprintf(stderr, "ハッシュ値が一致しませんでした\n");
				fprintf(stderr, "%sを削除します。\n", to);
				log_compares_write(from, f, to, t, false);
				unlink(to);
			}
		}
		else
		{
			log_errors(__FILE__, __LINE__, errno, to);
			log_compares_write(from, "NULL", to, "NULL", false);
		}
	}
	else
	{
		log_errors(__FILE__, __LINE__, errno, to);
		log_compares_write(from, "NULL", to, "NULL", false);
	}

	// 念のため、pipe詰まり対策
	for(;;)
	{
		tmp.read_size = 0;
		tmp.read_size += fread(tmp.from_pipe_buf, 1, PATH_LEN, tmp.from_pipe);
		tmp.read_size += fread(tmp.to_pipe_buf, 1, PATH_LEN, tmp.to_pipe);
		if(tmp.read_size <= 0)
			break;
	}

	pclose(tmp.from_pipe);
	pclose(tmp.to_pipe);

	free(from_su);
	free(to_su);
}

/*******************************************************************************
他のアプリケーションを実行する。
仮引数がvoid *なのはpthread用。
*******************************************************************************/
static void * from_check(void *tmp)
{
	struct hash_data *tmp2 = (struct hash_data *)tmp;
	tmp2->from_pipe = popen(tmp2->from_command, "r");

	return NULL;
}

/*******************************************************************************
他のアプリケーションを実行する。
仮引数がvoid *なのはpthread用。
*******************************************************************************/
static void * to_check(void *tmp)
{
	struct hash_data *tmp2 = (struct hash_data *)tmp;
	tmp2->to_pipe = popen(tmp2->to_command, "r");

	return NULL;
}
