#define _XOPEN_SOURCE 600

#include "global.h"
#include "log.h"

#include <stdlib.h>

#include <unistd.h>
#include <utime.h>
#define __USE_ATFILE
#include <fcntl.h>
#undef __USE_MISC
#include <sys/stat.h>
#define __USE_MISC
#undef __USE_ATFILE

// 関数プロトタイプ
void ch_time_mod(const void *tmp, const char *to, const char type);
void ch_time_mod_dir(const char *from, const char *to);

/*******************************************************************************
タイムスタンプのコピー
*******************************************************************************/
void ch_time_mod(const void *tmp, const char *to, const char type)
{
	struct stat *stat_buf = (struct stat *)tmp;
	// utimensat用タイムスタンプ変更用構造体
	struct timespec time_s[2];
	errno = 0;

	if(type == REGULAR)
	{
		if(chmod(to, stat_buf->st_mode) == -1)
		{
			log_errors(__FILE__, __LINE__, errno, to);
		}
		if(chown(to, stat_buf->st_uid, stat_buf->st_gid) == -1)
		{
			log_errors(__FILE__, __LINE__, errno, to);
		}
	}
	else
	{
		if(lchown(to, stat_buf->st_uid, stat_buf->st_gid) == -1)
		{
			log_errors(__FILE__, __LINE__, errno, to);
		}
	}

	time_s[0].tv_sec  = stat_buf->st_atime;
	time_s[0].tv_nsec = stat_buf->st_atimensec;
	time_s[1].tv_sec  = stat_buf->st_mtime;
	time_s[1].tv_nsec = stat_buf->st_mtimensec;
	// 第四引数は0かAT_SYMLINK_NOFOLLOW
	if(utimensat(AT_FDCWD, to, time_s, AT_SYMLINK_NOFOLLOW) == -1)
	{
		log_errors(__FILE__, __LINE__, errno, to);
	}
}

/*******************************************************************************
タイムスタンプのコピー。フォルダ編。
*******************************************************************************/
void ch_time_mod_dir(const char *from, const char *to)
{
	struct stat stat_buf;
	struct utimbuf times;
	errno = 0;

	if(stat(from, &stat_buf) == -1)
	{
		log_errors(__FILE__, __LINE__, errno, from);
		return;
	}

	if(chmod(to, stat_buf.st_mode) == -1)
	{
		log_errors(__FILE__, __LINE__, errno, to);
	}
	if(chown(to, stat_buf.st_uid, stat_buf.st_gid) == -1)
	{
		log_errors(__FILE__, __LINE__, errno, to);
	}

	times.actime  = stat_buf.st_atime;
	times.modtime = stat_buf.st_mtime;
	if(utime(to, &times) == -1)
	{
		log_errors(__FILE__, __LINE__, errno, to);
	}
}
