#define _GNU_SOURCE

#include "struct_CPInfo.h"
#include "struct_OPArg.h"
#include "print_error.h"
#include "replace_string.h"
#include "write_log_compare.h"

#include <unistd.h>
#include <pthread.h>

struct hash_data
{
	FILE *from_pipe;
	FILE *to_pipe;
	char *from_pipe_buf;
	char *to_pipe_buf;
	char *from_command;
	char *to_command;
	int read_size;
};

// 関数プロトタイプ
void compare_hash(const OPArg *oparg, CPInfo *cpinfo, const SDir *sdir, CPDD *cpdd);
static void * from_check(void *tmp);
static void * to_check(void *tmp);

/*******************************************************************************
*******************************************************************************/
void compare_hash(const OPArg *oparg, CPInfo *cpinfo, const SDir *sdir, CPDD *cpdd)
{
	// 置換後の文字列の長さをPATH_MAXの三倍までと仮定
	const int REPLACE_LEN = PATH_MAX * 3;

	char *from_re = alloca(REPLACE_LEN);
	char *to_re = alloca(REPLACE_LEN);

	struct hash_data hd;
	hd.from_pipe = NULL;
	hd.to_pipe = NULL;
	hd.from_pipe_buf = alloca(PATH_MAX);
	hd.to_pipe_buf = alloca(PATH_MAX);
	hd.from_command = alloca(REPLACE_LEN);
	hd.to_command = alloca(REPLACE_LEN);
	hd.read_size = 0;

	memset(hd.from_pipe_buf, 0, PATH_MAX);
	memset(hd.to_pipe_buf, 0, PATH_MAX);

	strcpy(from_re, cpinfo->from);
	strcpy(to_re, cpinfo->to);

	// 特殊文字の置換
	// bashのみ対応、他は未確認。
	// かならず最初に\を置換する。
	replace_string(from_re, "\\", "\\\\", REPLACE_LEN);
	replace_string(from_re, "\"", "\\\"", REPLACE_LEN);
	replace_string(from_re, "`", "\\`", REPLACE_LEN);
	replace_string(from_re, "$", "\\$", REPLACE_LEN);

	replace_string(to_re, "\\", "\\\\", REPLACE_LEN);
	replace_string(to_re, "\"", "\\\"", REPLACE_LEN);
	replace_string(to_re, "`", "\\`", REPLACE_LEN);
	replace_string(to_re, "$", "\\$", REPLACE_LEN);

	// 特殊文字を置換済みの場合、'や"で括ると動作しなくなる
	// 'で括る場合、文字列中に'があると動作しない。
	// なので"でくくる。
	if(oparg->C == ONE)
	{
		sprintf(hd.from_command, "%s%s%s%s", "sha1sum -- ", "\"", from_re, "\"");
		sprintf(hd.to_command, "%s%s%s%s", "sha1sum -- ", "\"", to_re, "\"");
	}
	else if(oparg->C == FIVE)
	{
		sprintf(hd.from_command, "%s%s%s%s", "md5sum -- ", "\"", from_re, "\"");
		sprintf(hd.to_command, "%s%s%s%s", "md5sum -- ", "\"", to_re, "\"");
	}

	errno = 0;
	if(cpinfo->copy_mode == DIFFERENT)
	{
		pthread_t t1;
		pthread_t t2;
		pthread_create(&t1, NULL, from_check, (void *)&hd);
		pthread_create(&t2, NULL, to_check, (void *)&hd);
		pthread_join(t1, NULL);
		pthread_join(t2, NULL);
	}
	else
	{
		hd.from_pipe = popen(hd.from_command, "r");
		hd.to_pipe = popen(hd.to_command, "r");
	}

	if((hd.from_pipe != NULL) && (hd.to_pipe != NULL))
	{
		char ctmp[PATH_MAX];

		hd.read_size = fread(hd.from_pipe_buf, 1, PATH_MAX, hd.from_pipe);
		// パイプのバッファを空にするためにグルグル回す
		while(fread(ctmp, 1, PATH_MAX, hd.from_pipe) > 0) {}

		hd.read_size = fread(hd.to_pipe_buf, 1, PATH_MAX, hd.to_pipe);
		while(fread(ctmp, 1, PATH_MAX, hd.to_pipe) > 0) {}

		// チェックしとかないと (半角スペース)が含まれていない場合、SIGSEGVで落ちる
		if(strstr(hd.from_pipe_buf, " ") && strstr(hd.to_pipe_buf, " "))
		{
			char *ffrom = strtok(hd.from_pipe_buf, " ");
			char *tto = strtok(hd.to_pipe_buf, " ");

			// Ubuntu 10.10で、ファイル名に\が含まれているファイルをsha1sumやmd5sumに渡すと、
			// 何故かハッシュ値の前に\が挿入されるっぽい。バグか？
			// その所為で文字列の長さが33や41になってハッシュ値が不一致と判定されるので、
			// 文字列の先頭が\だった場合、文字列を一つ前にずらす。
			if(ffrom[0] == '\\')
			{
				memmove(ffrom, ffrom + 1, strlen(ffrom));
			}

			if(tto[0] == '\\')
			{
				memmove(tto, tto + 1, strlen(tto));
			}

			// MD5 == 32桁　SHA-1 == 40桁
			if((strcmp(ffrom, tto) == 0) && ((strlen(ffrom) == 32) || (strlen(ffrom) == 40)))
			{
				cpinfo->compare = true;

				if(oparg->V == VERBOS)
				{
					puts("compare success");
					printf("%s : %s\n", ffrom, cpinfo->from);
					printf("%s : %s\n", tto, cpinfo->to);
				}

				if(oparg->L == LOG)
				{
					write_log_compare(cpinfo, ffrom, tto, sdir, cpdd, true);
				}
			}
			else
			{
				print_error("compare_hash", __FILE__, __LINE__, cpdd);
				fprintf(stderr, "ハッシュ値が一致しませんでした、%sを削除します\n", cpinfo->to);
				write_log_compare(cpinfo, ffrom, tto, sdir, cpdd, false);
				unlink(cpinfo->to);
				cpinfo->write = false;
				// falseで初期化しているので要らないはず
				//cpinfo->compare = false;
			}
		}
		else
		{
			print_error("compare_hash", __FILE__, __LINE__, cpdd);
			fprintf(stderr, "コンペアに失敗しました\n");
			fprintf(stderr, "%s\n", cpinfo->from);
			fprintf(stderr, "%s\n", cpinfo->to);
			write_log_compare(cpinfo, "NULL", "NULL", sdir, cpdd, false);
		}
	}
	else
	{
		print_error("compare_hash", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コンペアに失敗しました\n");
		fprintf(stderr, "%s\n", cpinfo->from);
		fprintf(stderr, "%s\n", cpinfo->to);
		write_log_compare(cpinfo, "NULL", "NULL", sdir, cpdd, false);
	}

	// 念のため、pipe詰まり対策
	for(;;)
	{
		hd.read_size = 0;
		hd.read_size += fread(hd.from_pipe_buf, 1, PATH_MAX, hd.from_pipe);
		hd.read_size += fread(hd.to_pipe_buf, 1, PATH_MAX, hd.to_pipe);
		if(hd.read_size <= 0)
		{
			break;
		}
	}

	pclose(hd.from_pipe);
	pclose(hd.to_pipe);
}

/*******************************************************************************
*******************************************************************************/
static void * from_check(void *tmp)
{
	struct hash_data *tmp2 = (struct hash_data *)tmp;
	tmp2->from_pipe = popen(tmp2->from_command, "r");

	return NULL;
}

/*******************************************************************************
*******************************************************************************/
static void * to_check(void *tmp)
{
	struct hash_data *tmp2 = (struct hash_data *)tmp;
	tmp2->to_pipe = popen(tmp2->to_command, "r");

	return NULL;
}
