#define _GNU_SOURCE

#include "struct_CPDD.h"
#include "struct_CPInfo.h"
#include "struct_DPath.h"
#include "struct_OPArg.h"
#include "struct_SData.h"

#include "append_list.h"
#include "print_error.h"
#include "xmalloc.h"
#include "xmalloc0.h"

#include <limits.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <glib.h>
#include <linux/limits.h>
#include <sys/stat.h>

#define CPINFO_MALLOC \
	CPInfo *cpinfo = xmalloc(sizeof(CPInfo));\
	cpinfo->tofs = NULL;\
	cpinfo->skip = false;\
	cpinfo->compare = false;\
	cpinfo->file_test = false;\

#define FILE_COUNT \
{\
	cpinfo->from_type = REGULAR;\
	cpdd->file_count++;\
}

#define LINK_COUNT \
{\
	cpinfo->from_type = SYMBOLICLINK;\
	cpdd->link_count++;\
}

#define DIR_COUNT \
{\
	cpinfo->from_type = DIRECTORY;\
	cpdd->dir_count++;\
}

#define TO_CONVERT_FULL_PATH \
{\
	set_full_path(tmpto, fullto);\
	cpinfo->to = get_to_plus_fromname(fullfrom, fullto);\
}

#define STAT_DO \
{\
	struct stat stat_buf;\
	if(stat(cpinfo->from, &stat_buf) != -1)\
	{\
		cpdd->total_source += stat_buf.st_size;\
	}\
}

#define SINGULAR_PROCESS \
{\
	char *false_dirname = g_path_get_dirname(tmpto);\
	set_full_path(false_dirname, fullto);\
	free(false_dirname);\
	/* ↓注意。ここはfullfromじゃなくてtmptoを渡す。 */\
	cpinfo->to = get_to_plus_fromname(tmpto, fullto);\
}

// 関数プロトタイプ
SData * get_file_list(const OPArg *oparg, const VList *drive_list);
static VList * dir_traverse(VList *file_list, const CPInfo *cpinfo, CPDD *cpdd);
static inline char * get_to_plus_fromname(const char *from, const char *to) __attribute__((always_inline));
static inline void set_same_or_different(const VList *drive_list, const char *from, const char *to, CPInfo *cpinfo) __attribute__((always_inline));
static inline void delete_last_slash(const int len, char tmp[]) __attribute__((always_inline));
static inline void set_full_path(const char *tmp1, char *tmp2) __attribute__((always_inline));

/*******************************************************************************
*******************************************************************************/
SData * get_file_list(const OPArg *oparg, const VList *drive_list)
{
	enum argument_count
	{
		SINGULAR,
		PLURAL,
	} acount;

	VList *file_list = NULL;

	/*
	 * CPDD *cpdd = xmalloc0(sizeof(CPDD));
	 * ↑のコードだと構造体のメンバが0で初期化されるとは限らないらしい。
	 * 大抵の処理系では期待通りに動くらしいけど。
	*/
	CPDD *cpdd = xmalloc(sizeof(CPDD));
	cpdd->file_count = 0;
	cpdd->dir_count = 0;
	cpdd->link_count = 0;
	cpdd->mk_file_count = 0;
	cpdd->mk_dir_count = 0;
	cpdd->mk_link_count = 0;
	cpdd->total_source = 0;
	cpdd->total_read = 0;
	cpdd->total_write = 0;
	cpdd->total_error = 0;

	char fullfrom[PATH_MAX];
	char fullto[PATH_MAX];
	char tmpfrom[PATH_MAX];
	char tmpto[PATH_MAX];
	int loop = oparg->fromindex;
	int loopto = oparg->toindex;
	int lenfrom;
	int lento = strlen(oparg->argv[loopto]);

	memcpy(tmpto, oparg->argv[loopto], lento + 1);
//	strcpy(tmpto, oparg->argv[loopto]);

	// 三項演算子
	((loopto - loop) == 1) ? (acount = SINGULAR) : (acount = PLURAL);

	for(; loop < loopto; loop++)
	{
		CPINFO_MALLOC

		lenfrom = strlen(oparg->argv[loop]);
		memcpy(tmpfrom, oparg->argv[loop], lenfrom + 1);

		delete_last_slash(lenfrom, tmpfrom);
		delete_last_slash(lento, tmpto);

		{
			set_full_path(tmpfrom, fullfrom);
			int amsdfoasio = strlen(fullfrom);
			amsdfoasio++;
			cpinfo->from = xmalloc(amsdfoasio);
			memcpy(cpinfo->from, fullfrom, amsdfoasio);
		}

		/*
		 * メモ
		 * cpコマンドの場合、引数が.だったらそのフォルダにあるファイルをコピーする。
		 * 引数が..だとエラー。
		*/

		/*
		 * フルパス使うようにしたので、以下のコードは用済み。
		if((strcmp(cpinfo->from, ".") == 0) || (strcmp(cpinfo->from, "..") == 0))
		{
			puts(".や..をコピー元に指定することは出来ません");
			continue;
		}
		*/

		if(g_file_test(tmpto, G_FILE_TEST_IS_DIR) == TRUE)
		{
			if(g_file_test(fullfrom, G_FILE_TEST_IS_SYMLINK) == TRUE)
			{
				LINK_COUNT

				TO_CONVERT_FULL_PATH

				file_list = append_list(file_list, (void *)cpinfo);
			}
			else if(g_file_test(fullfrom, G_FILE_TEST_IS_REGULAR) == TRUE)
			{
				FILE_COUNT

				STAT_DO

				TO_CONVERT_FULL_PATH

				set_same_or_different(drive_list, fullfrom, fullto, cpinfo);
				file_list = append_list(file_list, (void *)cpinfo);
			}
			else if(g_file_test(fullfrom, G_FILE_TEST_IS_DIR) == TRUE)
			{
				DIR_COUNT

				TO_CONVERT_FULL_PATH

				set_same_or_different(drive_list, fullfrom, fullto, cpinfo);
				file_list = append_list(file_list, (void *)cpinfo);
				file_list = dir_traverse(file_list, cpinfo, cpdd);
			}
			else
			{
				fprintf(stderr, "%s をスキップします\n", fullfrom);
			}
		}
		else if(g_file_test(tmpto, G_FILE_TEST_EXISTS) == FALSE)
		{
			if(acount == PLURAL)
			{
				if(mkdir(tmpto, 0755) == -1)
				{
					fprintf(stderr, "コピー先フォルダの作成に失敗しました\n");
					exit(EXIT_FAILURE);
				}
			}

			if(g_file_test(fullfrom, G_FILE_TEST_IS_SYMLINK) == TRUE)
			{
				LINK_COUNT

				if(acount == SINGULAR)
				{
					SINGULAR_PROCESS
				}
				else
				{
					TO_CONVERT_FULL_PATH
				}

				file_list = append_list(file_list, (void *)cpinfo);
			}
			else if(g_file_test(fullfrom, G_FILE_TEST_IS_REGULAR) == TRUE)
			{
				FILE_COUNT

				STAT_DO

				if(acount == SINGULAR)
				{
					SINGULAR_PROCESS
				}
				else
				{
					TO_CONVERT_FULL_PATH
				}

				set_same_or_different(drive_list, fullfrom, fullto, cpinfo);
				file_list = append_list(file_list, (void *)cpinfo);
			}
			else if(g_file_test(fullfrom, G_FILE_TEST_IS_DIR) == TRUE)
			{
				DIR_COUNT

				if(acount == SINGULAR)
				{
					SINGULAR_PROCESS
				}
				else
				{
					TO_CONVERT_FULL_PATH
				}

				set_same_or_different(drive_list, fullfrom, fullto, cpinfo);
				file_list = append_list(file_list, (void *)cpinfo);
				file_list = dir_traverse(file_list, cpinfo, cpdd);
			}
			else
			{
				fprintf(stderr, "%s をスキップします\n", fullfrom);
			}
		}
		else if(g_file_test(tmpto, G_FILE_TEST_IS_REGULAR) == TRUE)
		{
			if(acount == SINGULAR)
			{
				if(g_file_test(fullfrom, G_FILE_TEST_IS_SYMLINK) == TRUE)
				{
					cpdd->link_count++;
					free(cpinfo);
					fprintf(stderr, "シンボリックリンク (%s) に対するコピー先が不正 (ファイル) です\n", fullfrom);
				}
				else if(g_file_test(fullfrom, G_FILE_TEST_IS_REGULAR) == TRUE)
				{
					FILE_COUNT

					STAT_DO

					set_full_path(tmpto, fullto);
					set_same_or_different(drive_list, fullfrom, fullto, cpinfo);
					cpinfo->to = fullto;
					file_list = append_list(file_list, (void *)cpinfo);
				}
				else if(g_file_test(fullfrom, G_FILE_TEST_IS_DIR) == TRUE)
				{
					fprintf(stderr, "フォルダ (%s) に対するコピー先が不正 (ファイル) です\n", fullfrom);
					exit(EXIT_FAILURE);
				}
			}
			else
			{
				fprintf(stderr, "複数のコピー元に対するコピー先が不正 (ファイル) です\n");
				exit(EXIT_FAILURE);
			}
		}
		else
		{
			fprintf(stderr, "コピー先が不正です\n");
			exit(EXIT_FAILURE);
		}
	}

	SData *sdata = xmalloc(sizeof(SData));
	sdata->file_list = file_list;
	sdata->cpdd = cpdd;

	return sdata;
}

#include <dirent.h>
/*******************************************************************************
 * フォルダを走査
*******************************************************************************/
static VList * dir_traverse(VList *file_list, const CPInfo *cpinfo_tmp, CPDD *cpdd)
{
	DIR *dp = NULL;
	struct dirent *entry = NULL;
	const char *from_dir = cpinfo_tmp->from;
	const char *to_dir = cpinfo_tmp->to;

	if((dp = opendir(from_dir)) != NULL)
	{
		while((entry = readdir(dp)) != NULL)
		{
			// strcmpは等しければ0を返す（0は偽）
			if(strcmp(entry->d_name, ".") && strcmp(entry->d_name, ".."))
			{
				int fdir = strlen(from_dir);
				int tdir = strlen(to_dir);
				int dname = strlen(entry->d_name);

				CPINFO_MALLOC

				// +2は、 \0 と / の分
				cpinfo->from = xmalloc(fdir + dname + 2);
				cpinfo->to = xmalloc(tdir + dname + 2);
				/*
				 * sprintfは便利だってLeptonさんが言ってた。
				 * printf系の関数は遅い？知るか。
				*/
				sprintf(cpinfo->from, "%s%s%s", from_dir, G_DIR_SEPARATOR_S, entry->d_name);
				sprintf(cpinfo->to, "%s%s%s", to_dir, G_DIR_SEPARATOR_S, entry->d_name);

				if(entry->d_type == DT_LNK)
				{
					LINK_COUNT
					file_list = append_list(file_list, (void *)cpinfo);
				}
				else if(entry->d_type == DT_REG)
				{
					FILE_COUNT

					STAT_DO

					file_list = append_list(file_list, (void *)cpinfo);
				}
				else if(entry->d_type == DT_DIR)
				{
					DIR_COUNT
					file_list = append_list(file_list, (void *)cpinfo);
					// 再帰
					file_list = dir_traverse(file_list, cpinfo, cpdd);
				}
			}
		}
		if(closedir(dp) == -1)
		{
			print_error("closedir", __FILE__, __LINE__, cpdd);
		}
	}
	else
	{
		print_error("opendir", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "%s を読み取れませんでした\n", from_dir);
	}

	return file_list;
}

/*******************************************************************************
 * コピー元ファイル名とコピー先パスを連結する。
 * g_path_get_basename と g_build_path を同時にやる感じ。
*******************************************************************************/
static inline char * get_to_plus_fromname(const char *from, const char *to)
{
	char fname[PATH_MAX];
	char *return_name;
	int flen = strlen(from);
	int tlen = strlen(to);
	_Bool flag = false;

	for(int i = flen - 1; i >= 0; i--)
	{
		/*
		 * 最後のパス区切り文字からコピーするので、
		 * fnameは　/ファイル名\0　となる。
		*/
		if(from[i] == G_DIR_SEPARATOR)
		{
			flag = true;
			int j = 0;

			for(;;)
			{
				fname[j] = from[i];

				if(from[i] == '\0')
				{
					goto BASENAME_END;
				}

				i++;
				j++;
			}
		}
	}

BASENAME_END:

	if(flag == true)
	{
		int nlen = strlen(fname);
		// +1 はヌル文字（\0）の分
		return_name = xmalloc(tlen + nlen + 1);
		memcpy(return_name, to, tlen + 1);
//		strcpy(return_name, to);
		strcat(return_name, fname);
	}
	else
	{
		/*
		 * 2011年3月19日
		 * メモリ破壊のバグぅうわあああ。
		 * append_list内のxmalloc内で、malloc(): memory corruption
		 * とか出てアボートするバグを直せた。
		 * return_name = xmalloc(flen + tlen + 1);
		 * ↑こいつが原因だった。G_DIR_SEPARATOR_Sのことを忘れてた。
		 * 多分これで大丈夫。
		*/
		return_name = xmalloc(flen + tlen + (sizeof(G_DIR_SEPARATOR_S) + 1));
		memcpy(return_name, to, tlen + 1);
//		strcpy(return_name, to);
		strcat(return_name, G_DIR_SEPARATOR_S);
		strcat(return_name, from);
	}

	return return_name;
}

/******************************************************************************
 * ドライブが同一かどうか調べる
*******************************************************************************/
static inline void set_same_or_different(const VList *drive_list, const char *from, const char *to, CPInfo *cpinfo)
{
	/*
	 * キャストしないと警告が出る
	 * warning: initialization discards qualifiers from pointer target type
	*/
	VList *tmplist = (VList *)drive_list;
	char *fromdev = NULL;
	char *todev = NULL;

	for(;;)
	{
		DPath *tmp = (DPath *)tmplist->data;
		int tmplen = strlen(tmp->mount_point);

		if(strncmp(tmp->mount_point, from, tmplen) == 0)
		{
			fromdev = tmp->device;
		}

		if(strncmp(tmp->mount_point, to, tmplen) == 0)
		{
			todev = tmp->device;
			cpinfo->tofs = tmp->fs;
		}

		if(tmplist->next != NULL)
		{
			tmplist = tmplist->next;
		}
		else
		{
			break;
		}
	}

	if((fromdev != NULL) && (todev != NULL))
	{
		if(strcmp(fromdev, todev) == 0)
		{
			cpinfo->copy_mode = SAME;
		}
		else
		{
			cpinfo->copy_mode = DIFFERENT;
		}
	}
	else
	{
		cpinfo->copy_mode = SAME;
	}
}

/*******************************************************************************
 * 文字列の最後がパス区切り文字だった場合\0にする
*******************************************************************************/
static inline void delete_last_slash(const int len, char tmp[])
{
	if(tmp[len - 1] == G_DIR_SEPARATOR)
	{
		tmp[len - 1] = '\0';
	}
}

/******************************************************************************
 * 絶対パスを作成する
*******************************************************************************/
static inline void set_full_path(const char *tmp1, char *tmp2)
{
	if((realpath(tmp1, tmp2) == NULL))
	{
		fprintf(stderr, "絶対パスの作成に失敗しました\n");
		fprintf(stderr, "対象ファイル : %s\n", tmp1);
		exit(EXIT_FAILURE);
	}
}
