#define _XOPEN_SOURCE 500

#include "struct_OPArg.h"
#include "struct_SDir.h"
#include "xmalloc.h"

#include <string.h>

#include <glib.h>
#include <unistd.h>

// 関数プロトタイプ
OPArg * read_conf(const SDir *sdir);

/*******************************************************************************
 * オプションの初期化を行った後、設定ファイルから設定を読み出す
*******************************************************************************/
OPArg * read_conf(const SDir *sdir)
{
	const int INPUT_LEN = 256;
	const off_t DEFAULT_BUFFER = 64 * 1024 * 1024;

	char buf[INPUT_LEN];
	OPArg *oparg = xmalloc(sizeof(OPArg));
	oparg->B = NOT;
	oparg->buffer_size = DEFAULT_BUFFER;
	oparg->C = NOT;
	oparg->D = NOT;
	oparg->I = NOT;
	oparg->L = NOT;
	oparg->M = NOT;
	oparg->V = NOT;

	// -wオプションはデフォルトで有効
	oparg->W = WRITE_MODE;
	oparg->write_mode = 1;

	oparg->EFFECT = NOT;

	// そもそも~/.config/snowcpが存在するかが重要だ
	if(g_file_test(sdir->user_settings_dir, G_FILE_TEST_EXISTS) == TRUE)
	{
		if(chdir(sdir->user_settings_dir) == 0)
		{
			if(g_file_test(SNOWCP_CONF, G_FILE_TEST_EXISTS) == TRUE)
			{
				FILE *config = fopen(SNOWCP_CONF, "r");

				if(config == NULL)
				{
					fprintf(stderr, "設定ファイルのオープンに失敗しました\n");
					fprintf(stderr, "強制終了します\n");
					exit(EXIT_FAILURE);
				}

				while(fgets(buf, INPUT_LEN, config) != NULL)
				{
					switch(buf[0])
					{
					// 設定ファイルのバージョン
					case '!':
						// 改行文字をヌル文字に
						buf[strlen(buf) - 1] = '\0';
						char *ver = strtok(buf, "," );
						ver = strtok(NULL, "," );

						if(ver != NULL)
						{
							if(strcmp(SNOWCP_CONF_VER, ver) != 0)
							{
								fprintf(stderr, "設定ファイルに互換性がありません\n");
								fprintf(stderr, "-o オプションを使用して作成し直してください\n");
								exit(EXIT_FAILURE);
							}
						}
						else
						{
							fprintf(stderr, "設定ファイルが正しくありません\n");
							exit(EXIT_FAILURE);
						}
						break;
					// SHA1SUM
					case '1':
						oparg->C = ONE;

						if(buf[2] == '1')
						{
							oparg->compare_mode = 1;
						}
						else if(buf[2] == '2')
						{
							oparg->compare_mode = 2;
						}
						else
						{
							fprintf(stderr, "設定ファイルが正しくありません\n");
							exit(EXIT_FAILURE);
						}
						break;
					// MD5SUM
					case '5':
						oparg->C = FIVE;

						if(buf[2] == '1')
						{
							oparg->compare_mode = 1;
						}
						else if(buf[2] == '2')
						{
							oparg->compare_mode = 2;
						}
						else
						{
							fprintf(stderr, "設定ファイルが正しくありません\n");
							exit(EXIT_FAILURE);
						}
						break;
					// バッファサイズを指定
					case 'b':
						oparg->B = BUFFER;
						{
							// 改行文字をヌル文字に
							buf[strlen(buf) - 1] = '\0';
							char *cp = strtok(buf, "," );
							cp = strtok(NULL, "," );

							if(cp != NULL)
							{
								char *endptr = NULL;
								oparg->buffer_size = strtoll(cp, &endptr, 10);
								// サイズをメガバイト単位にする
								oparg->buffer_size = 1024 * 1024 * oparg->buffer_size;

								if(oparg->buffer_size <= 0)
								{
									fprintf(stderr, "バッファサイズが0以下です\n");
									exit(EXIT_FAILURE);
								}
							}
							else
							{
								fprintf(stderr, "設定ファイルが正しくありません\n");
								exit(EXIT_FAILURE);
							}
						}
						break;
					// コンペア
					case 'c':
						oparg->C = COMPARE;

						if(buf[2] == '1')
						{
							oparg->compare_mode = 1;
						}
						else if(buf[2] == '2')
						{
							oparg->compare_mode = 2;
						}
						else
						{
							fprintf(stderr, "設定ファイルが正しくありません\n");
							exit(EXIT_FAILURE);
						}
						break;
					// 上書き時に確認する
					case 'i':
						oparg->I = INTERACTIVE;
						oparg->write_mode = 3;
						break;
					// コンペアのログを保存する
					case 'l':
						oparg->L = LOG;
						break;
					// 表示モード
					case 'v':
						oparg->V = VERBOS;
						break;
					// 上書きモード
					case 'w':
						oparg->I = NOT;

						switch(buf[2])
						{
						case '0':
							oparg->write_mode = 0;
							break;
						case '1':
							oparg->write_mode = 1;
							break;
						case '2':
							oparg->write_mode = 2;
							break;
						case '3':
							oparg->write_mode = 3;
							break;
						default:
							fprintf(stderr, "設定ファイルが正しくありません\n");
							exit(EXIT_FAILURE);
							break;
						}
					}
				}

				fclose(config);
			}

			if(fchdir(sdir->current_fd) == -1)
			{
				fprintf(stderr, "カレントディレクトリへのリターンに失敗しました\n");
				exit(EXIT_FAILURE);
			}
		}
		else
		{
			fprintf(stderr, "設定フォルダにアクセスできませんでした\n");
			fprintf(stderr, "強制終了します\n");
			exit(EXIT_FAILURE);
		}
	}

	return oparg;
}
