#define _GNU_SOURCE

#include "print_error.h" // inline
#include "struct_OPArg.h"
#include "write_log_hash_check.h" // inline

#include <fcntl.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <unistd.h>

#define MUNMAP_S \
{\
	if(munmap(buffrom, read_size) == -1)\
	{\
		print_error("munmap", __FILE__, __LINE__, cpdd);\
	}\
	if(munmap(bufto, read_size) == -1)\
	{\
		print_error("munmap", __FILE__, __LINE__, cpdd);\
	}\
}

#define MMAP_IS_FAILED \
{\
	check = false;\
	print_error("mmap", __FILE__, __LINE__, cpdd);\
	fprintf(stderr, "コンペアに失敗しました\n");\
	fprintf(stderr, "%s\n", cpinfo->from);\
	fprintf(stderr, "%s\n", cpinfo->to);\
}

static _Bool check;
static _Bool open_from;
static _Bool open_to;
static int ifrom;
static int ito;
static struct stat froms;
static struct stat tos;
static off_t from_size;
static off_t to_size;
static off_t read_size;
static off_t read_all;
static off_t buffer_size_local;
static char *buffrom;
static char *bufto;
static long psize = 0;

// 関数プロトタイプ
void compare_memcmp(const OPArg *oparg, CPInfo *cpinfo, const SDir *sdir, CPDD *cpdd);

void compare_memcmp(const OPArg *oparg, CPInfo *cpinfo, const SDir *sdir, CPDD *cpdd)
{
	check = false;
	open_from = true;
	open_to = true;

	if((ifrom = open(cpinfo->from, O_RDONLY | O_NOATIME)) == -1)
	{
		open_from = open_to = false;

		print_error("open", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コンペアを開始できません\n");
		fprintf(stderr, "from : %s\n", cpinfo->from);
		fprintf(stderr, "to : %s\n", cpinfo->to);
	}
	else if((ito = open(cpinfo->to, O_RDONLY | O_NOATIME)) == -1)
	{
		open_to = false;

		print_error("open", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コンペアを開始できません\n");
		fprintf(stderr, "from : %s\n", cpinfo->from);
		fprintf(stderr, "to : %s\n", cpinfo->to);
	}
	else if((fstat(ifrom, &froms)) == -1)
	{
		print_error("fstat", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コンペアを開始できません\n");
		fprintf(stderr, "from : %s\n", cpinfo->from);
		fprintf(stderr, "to : %s\n", cpinfo->to);
	}
	else if((fstat(ito, &tos)) == -1)
	{
		print_error("fstat", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コンペアを開始できません\n");
		fprintf(stderr, "from : %s\n", cpinfo->from);
		fprintf(stderr, "to : %s\n", cpinfo->to);
	}
	else if(froms.st_size != tos.st_size)
	{
		print_error(__func__, __FILE__, __LINE__, cpdd);
		fprintf(stderr, "ファイルサイズが一致しませんでした、%sを削除します\n", cpinfo->to);
		write_log_hash_check(cpinfo, "NULL", "NULL", sdir, cpdd, false);
		unlink(cpinfo->to);
		cpinfo->write = false;
		// falseで初期化しているので要らないはず
		//cpinfo->hash_check = false;
	}
	else
	{
		from_size = froms.st_size;
		to_size = tos.st_size;
		read_size = 0;
		read_all = 0;
		buffer_size_local = oparg->buffer_size_thread;

		if(psize == 0)
		{
			psize = sysconf(_SC_PAGESIZE);
		}

		for(;;)
		{
			read_size = from_size - read_all;

			/*
			 * mmapはoffsetがページサイズの倍数でないと動作しないので、
			 * 値を調節しておく。
			*/
			if(read_size >= buffer_size_local)
			{
				read_size = buffer_size_local;
			}
			else
			{
				off_t i = read_size % psize;
				if(i != read_size)
				{
					read_size = read_size - i;
				}
			}

			errno = 0;

			if((buffrom = mmap(NULL, read_size, PROT_READ, MAP_PRIVATE, ifrom, read_all)) != MAP_FAILED)
			{
				if((bufto = mmap(NULL, read_size, PROT_READ, MAP_PRIVATE, ito, read_all)) != MAP_FAILED)
				{
					errno = 0;
					if(madvise(buffrom, read_size, MADV_WILLNEED) == -1)
					{
						print_error("madvise", __FILE__, __LINE__, cpdd);
					}

					errno = 0;
					if(madvise(bufto, read_size, MADV_WILLNEED) == -1)
					{
						print_error("madvise", __FILE__, __LINE__, cpdd);
					}

					errno = 0;
					if(memcmp(buffrom, bufto, read_size) == 0)
					{
						check = true;
						read_all += read_size;

						MUNMAP_S

						if(read_all >= from_size)
						{
							break;
						}
					}
					else
					{
						check = false;

						MUNMAP_S

						print_error(__func__, __FILE__, __LINE__, cpdd);
						fprintf(stderr, "ファイルが一致しませんでした、%sを削除します\n", cpinfo->to);
						write_log_hash_check(cpinfo, "NULL", "NULL", sdir, cpdd, false);
						unlink(cpinfo->to);
						cpinfo->write = false;
					}
				}
				else
				{
					MMAP_IS_FAILED

					errno = 0;
					if(munmap(buffrom, from_size) == -1)
					{
						print_error("munmap", __FILE__, __LINE__, cpdd);
					}

					goto END;
				}
			}
			else
			{
				MMAP_IS_FAILED

				goto END;
			}
		}
	}

END:

	if(open_from == true)
	{
		if(close(ifrom) == -1)
		{
			print_error("close", __FILE__, __LINE__, cpdd);
		}
	}

	if(open_to == true)
	{
		if(close(ito) == -1)
		{
			print_error("close", __FILE__, __LINE__, cpdd);
		}
	}

	if(check == true)
	{
		cpinfo->hash_check = true;

		if(oparg->V == VERBOS)
		{
			puts("compare success");
			printf("from : %s\n", cpinfo->from);
			printf("to   : %s\n", cpinfo->to);
		}
	}
}
