#include "struct_OPArg.h"
#include "struct_SDir.h"

#include <stdio.h>
#include <stdlib.h>

#include <glib.h>
#include <sys/stat.h>
#include <unistd.h>

#define INPUT_CHECK_CLEAN \
{\
	if(fgets(stdin_buf, INPUT_LEN, stdin) == NULL)\
	{\
		fgets_is_null();\
	}\
\
	clean(stdin_buf, INPUT_LEN);\
}

// 関数プロトタイプ
void write_conf(const SDir *sdir);
static void clean(const char stdin_buf[], const int INPUT_LEN);
static void fgets_is_null(void);
static void write_error(const char *mes);

/*******************************************************************************
 * 設定をファイルへ保存する
*******************************************************************************/
void write_conf(const SDir *sdir)
{
	const int INPUT_LEN = 256;

	char stdin_buf[INPUT_LEN];
	char compare = '@';
	char hash_check_mode = '@';
	int b_op = 0;
	char i_op = '@';
	char l_op = '@';
	char m_op = '@';
	char r_op = '@';
	char t_op = '@';
	char thread_mode = '@';
	char v_op = '@';
	char w_op = '@';
	char write_mode = '@';

	puts("設定の変更を行います");

	{
		puts("");
		puts("ファイルコピー後にベリファイを行いますか?");
		printf("(y / n) :");

		INPUT_CHECK_CLEAN

		if(stdin_buf[0] == 'y')
		{
			r_op = stdin_buf[0];

			puts("");
			puts("ベリファイモードを選んでください");
			puts("1 : コピー直後にベリファイ");
			puts("2 : 全コピー終了後に一括ベリファイ");
			printf("(1 / 2) :");

			INPUT_CHECK_CLEAN

			if((stdin_buf[0] == '1') || (stdin_buf[0] == '2'))
			{
				hash_check_mode = stdin_buf[0];

				puts("");
				puts("ベリファイのログを保存しますか?");
				printf("(y / n) :");

				INPUT_CHECK_CLEAN

				if(stdin_buf[0] == 'y')
				{
					l_op = stdin_buf[0];
				}
			}
			else
			{
				r_op = '@';
			}
		}
		else
		{
			puts("");
			puts("ファイルコピー後にコンペアを行いますか?");
			printf("(y / n) :");

			INPUT_CHECK_CLEAN

			if(stdin_buf[0] == 'y')
			{
				puts("");
				puts("コンペアオプションを選んでください");
				puts("1 : SHA-1");
				puts("5 : MD5");
				puts("c : 単純比較");
				printf("(1 / 5 / c) :");

				INPUT_CHECK_CLEAN

				if((stdin_buf[0] == '1') || (stdin_buf[0] == '5') || (stdin_buf[0] == 'c'))
				{
					compare = stdin_buf[0];
					puts("");
					puts("コンペアモードを選んでください");
					puts("1 : コピー直後にコンペア");
					puts("2 : 全コピー終了後に一括コンペア");
					printf("(1 / 2) :");

					INPUT_CHECK_CLEAN

					if((stdin_buf[0] == '1') || (stdin_buf[0] == '2'))
					{
						hash_check_mode = stdin_buf[0];
					}
					else
					{
						compare = '@';
					}
				}

				if((compare == '1') || (compare == '5'))
				{
					puts("");
					puts("コンペアのログを保存しますか?");
					printf("(y / n) :");

					INPUT_CHECK_CLEAN

					if(stdin_buf[0] == 'y')
					{
						l_op = stdin_buf[0];
					}
				}
			}
		}
	}

	{
		puts("");
		puts("バッファのサイズを変更しますか?");
		printf("(y / n) :");

		INPUT_CHECK_CLEAN

		if(stdin_buf[0] == 'y')
		{
			puts("数値を入力してください(初期値は32です)");
			printf(" :");

			INPUT_CHECK_CLEAN

			char *endptr = NULL;
			b_op = (int)strtol(stdin_buf, &endptr, 10);
	
			if(b_op < 0)
			{
				b_op = 2;
			}
		}
	}

	{
		puts("");
		puts("ファイルを上書きする前に確認しますか?");
		printf("(y / n) :");

		INPUT_CHECK_CLEAN

		if(stdin_buf[0] == 'y')
		{
			i_op = stdin_buf[0];
		}
		else
		{
			puts("");
			puts("上書きモードを変更しますか? (初期設定は、サイズ又は日付が異なる場合に上書き)");
			printf("(y / n) :");

			INPUT_CHECK_CLEAN

			if(stdin_buf[0] == 'y')
			{
				w_op = stdin_buf[0];

				puts("");
				puts("上書きモードを選んでください");
				puts("1 : 初期設定");
				puts("2 : 日付が新しい場合に上書き");
				puts("3 : 常に上書き");
				puts("0 : 上書きしない");
				printf("(1 / 2 / 3 / 0) :");

				INPUT_CHECK_CLEAN

				if((stdin_buf[0] == '1') || (stdin_buf[0] == '2') || (stdin_buf[0] == '3') || (stdin_buf[0] == '0'))
				{
					write_mode = stdin_buf[0];
				}
				else
				{
					w_op = '@';
				}
			}
		}
	}

	{
		puts("");
		puts("移動モード (ファイルコピー後、元ファイルを削除) に設定しますか?");
		printf("(y / n) :");

		INPUT_CHECK_CLEAN

		if(stdin_buf[0] == 'y')
		{
			m_op = stdin_buf[0];
		}
	}

	{
		puts("");
		puts("スレッドモードを指定しますか? (初期設定は自動判別)");
		printf("(y / n) :");

		INPUT_CHECK_CLEAN

		if(stdin_buf[0] == 'y')
		{
			t_op = stdin_buf[0];

			puts("");
			puts("モードを選んでください (初期設定は自動判別)");
			puts("1 : 常に同一ドライブモード");
			puts("2 : 常に別ドライブモード");
			puts("0 : 初期設定");
			printf("(1 / 2 / 0) :");

			INPUT_CHECK_CLEAN

			if((stdin_buf[0] == '1') || (stdin_buf[0] == '2') || (stdin_buf[0] == '0'))
			{
				thread_mode = stdin_buf[0];
			}
			else
			{
				t_op = '@';
			}
		}
	}

	{
		puts("");
		puts("コピー中のファイル名を表示しますか?");
		printf("(y / n) :");

		INPUT_CHECK_CLEAN

		if(stdin_buf[0] == 'y')
		{
			v_op = stdin_buf[0];
		}
	}

	// 設定をファイルに保存する
	if(
		(hash_check_mode != '@') ||
		(b_op > 0) ||
		(i_op != '@') ||
		(write_mode != '@') ||
		(m_op != '@') ||
		(r_op != '@') ||
		(thread_mode != '@') ||
		(v_op != '@')
	)
	{
		// フォルダが存在しない場合は作成
		if(g_file_test(sdir->config_dir, G_FILE_TEST_EXISTS) == FALSE)
		{
			mkdir(sdir->config_dir, 0777);
			chmod(sdir->config_dir, 0777);
		}
		if(g_file_test(sdir->user_settings_dir, G_FILE_TEST_EXISTS) == FALSE)
		{
			mkdir(sdir->user_settings_dir, 0777);
			chmod(sdir->user_settings_dir, 0777);
		}

		if(chdir(sdir->user_settings_dir) != 0)
		{
			fprintf(stderr, "設定フォルダにアクセスできませんでした\n");
			fprintf(stderr, "強制終了します\n");
			exit(EXIT_FAILURE);
		}

		// ファイルに設定を書き込めない場合、Segmentation faultで落ちるかも

		FILE *config;
		if((config = fopen(SNOWCP_CONF, "w")) != NULL)
		{
			{
				if(fputs("!,", config) == EOF)
				{
					write_error("fputs");
				}
				else if(fputs(SNOWCP_CONF_VER, config) == EOF)
				{
					write_error("fputs");
				}
				else if(fputs("\n", config) == EOF)
				{
					write_error("fputs");
				}
			}

			puts(" ");

			if(compare != '@')
			{
				{
					if(fputc(compare, config) == EOF)
					{
						write_error("fputc");
					}
					else if(fputs(",", config) == EOF)
					{
						write_error("fputs");
					}
					else if(fputc(hash_check_mode, config) == EOF)
					{
						write_error("fputc");
					}
					else if(fputs("\n", config) == EOF)
					{
						write_error("fputs");
					}
				}

				if(compare == '1')
				{
					puts("コンペアタイプ : SHA-1");
				}
				else if(compare == '5')
				{
					puts("コンペアタイプ : MD5");
				}
				else
				{
					puts("コンペアタイプ : memcmp");
				}

				printf("コンペアモード : %c\n", hash_check_mode);
			}

			if(r_op != '@')
			{
				{
					if(fputc('r', config) == EOF)
					{
						write_error("fputc");
					}
					else if(fputs(",", config) == EOF)
					{
						write_error("fputs");
					}
					else if(fputc(hash_check_mode, config) == EOF)
					{
						write_error("fputc");
					}
					else if(fputs("\n", config) == EOF)
					{
						write_error("fputs");
					}
				}

				printf("ベリファイモード : %c\n", hash_check_mode);
			}

			if(b_op > 0)
			{
				char tmp[INPUT_LEN];
				sprintf(tmp, "%d", b_op);

				if(
					(fputs("b", config) == EOF) ||
					(fputs(",", config) == EOF) ||
					(fputs(tmp, config) == EOF) ||
					(fputs("\n", config) == EOF)
				)
				{
					write_error("fputs");
				}

				printf("バッファサイズ : %d\n", b_op);
			}

			if(i_op != '@')
			{
				if(
					(fputs("i", config) == EOF) ||
					(fputs(",", config) == EOF) ||
					(fputs("NULL", config) == EOF) ||
					(fputs("\n", config) == EOF)
				)
				{
					write_error("fputs");
				}

				puts("上書き確認する");
			}

			if(write_mode != '@')
			{
				{
					if(fputs("w", config) == EOF)
					{
						write_error("fputc");
					}
					else if(fputs(",", config) == EOF)
					{
						write_error("fputs");
					}
					else if(fputc(write_mode, config) == EOF)
					{
						write_error("fputc");
					}
					else if(fputs("\n", config) == EOF)
					{
						write_error("fputs");
					}
				}

				printf("上書きモード   : %c\n", write_mode);
			}

			if(l_op != '@')
			{
				if(
					(fputs("l", config) == EOF) ||
					(fputs(",", config) == EOF) ||
					(fputs("NULL", config) == EOF) ||
					(fputs("\n", config) == EOF)
				)
				{
					write_error("fputs");
				}

				puts("コンペアログを保存する");
			}

			if(m_op != '@')
			{
				if(
					(fputs("m", config) == EOF) ||
					(fputs(",", config) == EOF) ||
					(fputs("NULL", config) == EOF) ||
					(fputs("\n", config) == EOF)
				)
				{
					write_error("fputs");
				}

				puts("移動モード");
			}

			if(thread_mode != '@')
			{
				{
					if(fputs("t", config) == EOF)
					{
						write_error("fputc");
					}
					else if(fputs(",", config) == EOF)
					{
						write_error("fputs");
					}
					else if(fputc(thread_mode, config) == EOF)
					{
						write_error("fputc");
					}
					else if(fputs("\n", config) == EOF)
					{
						write_error("fputs");
					}
				}

				printf("スレッドモード : %c\n", thread_mode);
			}

			if(v_op != '@')
			{
				if(
					(fputs("v", config) == EOF) ||
					(fputs(",", config) == EOF) ||
					(fputs("NULL", config) == EOF) ||
					(fputs("\n", config) == EOF)
				)
				{
					write_error("fputs");
				}

				puts("コピー中のファイル名を表示する");
			}

			fclose(config);
			chmod(SNOWCP_CONF, 0777);
		}
		else
		{
			perror("fopen");
			fprintf(stderr, "設定の保存に失敗しました\n");
			fprintf(stderr, "設定ファイルを削除します\n");
			unlink(SNOWCP_CONF);
		}
	}
	else
	{
		fprintf(stderr, "設定ファイルを削除します\n");
		unlink(SNOWCP_CONF);
	}
}

/*******************************************************************************
 * 入力バッファのクリア
*******************************************************************************/
static void clean(const char stdin_buf[], const int INPUT_LEN)
{
	// バッファチェック
	int a = 0;
	for(int i = 0; i < INPUT_LEN; i++)
	{
		if(stdin_buf[i] == '\n')
		{
			a++;
			break;
		}
	}
	// 入力バッファの掃除
	if(a == 0)
	{
		while(getchar() != '\n');
	}
}

/*******************************************************************************
 * fgetsの戻り値がNULLだった場合
*******************************************************************************/
static void fgets_is_null(void)
{
	fprintf(stderr, "エラーが発生しました\n");
	fprintf(stderr, "fgetsの戻り値がNULLです\n");
	exit(EXIT_FAILURE);
}

/*******************************************************************************
 * 設定ファイルに書き込めなかった場合
*******************************************************************************/
static void write_error(const char *mes)
{
	perror(mes);
	fprintf(stderr, "設定ファイル書き込み時にエラーが発生しました\n");
	fprintf(stderr, "設定ファイルを削除します\n");
	unlink(SNOWCP_CONF);
	exit(EXIT_FAILURE);
}
