#define _GNU_SOURCE

#include "create_symboliclink.h" // inline
#include "struct_CPDD.h"
#include "struct_CPInfo.h"
#include "struct_DPath.h"
#include "struct_OPArg.h"
#include "struct_RData.h"
#include "struct_SDir.h"
#include "append_list.h" // inline
#include "print_error.h" // inline
#include "read_write.h"
#include "xmalloc.h" // inline
#include "xmalloc0.h" // inline

#include <limits.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <glib.h>
#include <linux/limits.h>
#include <sys/stat.h>
#include <utime.h>

/* 関数プロトタイプ */
RData * check_target(OPArg *, VList *, SDir *);
void check_overwrite(const OPArg *, const SDir *, CPInfo *, CPDD *);
struct stat * make_directory(CPInfo *, OPArg *, CPDD *);
static VList * dir_traverse(VList *, CPInfo *, OPArg *, SDir *, CPDD *);
static inline void delete_last_slash(const int, char []);
static inline CPInfo * cpinfo_malloc(void);
static inline char * get_to_plus_fromname(const char *, const char *);
static inline void count_link_plus(CPInfo *, CPDD *);
static inline void count_file_plus(CPInfo *, CPDD *);
static inline void count_dire_plus(CPInfo *, CPDD *);
static inline void ch_time_and_mod_dir(const CPInfo *, const struct stat *, CPDD *);
static inline void clean(const char [], const int);
static inline void fgets_is_null(void);
static inline void set_same_or_different(const VList *, const char *, const char *, CPInfo *, OPArg *);

/*******************************************************************************
*******************************************************************************/
#define LINK_COPY \
{\
	count_link_plus(cpinfo, cpdd);\
	check_overwrite(oparg, sdir, cpinfo, cpdd);\
	file_list = append_list(file_list, (void *)cpinfo);\
}

#define FILE_COPY \
{\
	count_file_plus(cpinfo, cpdd);\
	set_same_or_different(drive_list, tmp_from, tmp_to, cpinfo, oparg); \
	check_overwrite(oparg, sdir, cpinfo, cpdd);\
	file_list = append_list(file_list, (void *)cpinfo);\
}

#define DIR_COPY \
{\
	_Bool cmp_flag = false;\
	if(from_current_flag == true)\
	{\
		char *from = cpinfo->from;\
		char *to = cpinfo->to;\
		int f_len = strlen(from);\
		int t_len = strlen(to);\
\
		if(f_len == t_len)\
		{\
			if(strcmp(from, to) == 0)\
			{\
				cmp_flag = true;\
			}\
		}\
		else if(f_len < t_len)\
		{\
			for(;;)\
			{\
				if(*from == *to)\
				{\
					from++;\
					to++;\
				}\
				else \
				{\
					break;\
				}\
\
				if(*from == '\0')\
				{\
\
					if(*to == G_DIR_SEPARATOR)\
					{\
						cmp_flag = true;\
					}\
					break;\
				}\
			}\
		}\
\
		if(cmp_flag == true)\
		{\
			fprintf(stderr, ".をスキップします\n");\
			continue;\
		}\
	}\
\
	if(cmp_flag == false)\
	{\
		set_same_or_different(drive_list, tmp_from, tmp_to, cpinfo, oparg); \
\
		struct stat *stat_buf;\
\
		if(from_current_flag == false)\
		{\
			count_dire_plus(cpinfo, cpdd);\
			stat_buf = make_directory(cpinfo, oparg, cpdd);\
			file_list = append_list(file_list, (void *)cpinfo);\
		}\
		else \
		{\
			char *current_tmp = g_path_get_dirname(cpinfo->to);\
			free(cpinfo->to);\
			cpinfo->to = current_tmp;\
			/* cpinfoをリストに追加していないので、メモリリークしている。 */\
		}\
\
		file_list = dir_traverse(file_list, cpinfo, oparg, sdir, cpdd);\
\
		if((from_current_flag == false) && (cpinfo->write == true))\
		{\
			ch_time_and_mod_dir(cpinfo, stat_buf, cpdd);\
		}\
	}\
}

/*******************************************************************************
*******************************************************************************/
RData * check_target(OPArg *oparg, VList *drive_list, SDir *sdir)
{
	enum argument_count
	{
		SINGULAR,
		PLURAL,
	} acount;

	VList *file_list = NULL;

	/*
	 * CPDD *cpdd = xmalloc0(sizeof(CPDD));
	 * ↑のコードだと構造体のメンバが0で初期化されるとは限らないらしい。
	 * 大抵の処理系では期待通りに動くらしいけど。
	*/
	CPDD *cpdd = xmalloc(sizeof(CPDD));
	cpdd->file_count = 0;
	cpdd->dir_count = 0;
	cpdd->link_count = 0;
	cpdd->mk_file_count = 0;
	cpdd->mk_dir_count = 0;
	cpdd->mk_link_count = 0;
	cpdd->total_source = 0;
	cpdd->total_read = 0;
	cpdd->total_write = 0;
	cpdd->total_error = 0;
	cpdd->thread_mode_count = 0;

	char tmp_from[PATH_MAX];
	char tmp_to[PATH_MAX];
	int loop = oparg->fromindex;
	int loop_to = oparg->toindex;

	_Bool file_found = false;

	if(g_file_test(oparg->argv[loop_to], G_FILE_TEST_IS_SYMLINK) == TRUE)
	{
		fprintf(stderr, "コピー先がシンボリックリンクです\n");
		exit(EXIT_FAILURE);
	}

	/* 三項演算子 */
	((loop_to - loop) == 1) ? (acount = SINGULAR) : (acount = PLURAL);

	/* コピー元が.でコピー先が存在しないとき用の処理 */
	switch(acount)
	{
	case SINGULAR:
		{
			char *c = oparg->argv[loop];
			if(
				(c[0] == '.') &&
					(
						(c[1] == '\0') ||
						((c[1] == G_DIR_SEPARATOR) && (c[2] == '\0')) ||
						((c[1] == G_DIR_SEPARATOR) && (c[2] == '.') && (c[3] == '\0'))
					)
			)
			{
				errno = 0;

				if(mkdir(oparg->argv[loop_to], 0755) == -1)
				{
					if((errno != EEXIST) && (errno != 0))
					{
						print_error("mkdir", __FILE__, __LINE__, cpdd);
						fprintf(stderr, "コピー先フォルダの作成に失敗しました\n");
						exit(EXIT_FAILURE);
					}
				}
			}
		}
		break;
	}

	errno = 0;
	realpath(oparg->argv[loop_to], tmp_to);

	if(errno == 0)
	{
		file_found = true;
	}
	else if(errno == ENOENT)
	{
		char *c = g_path_get_dirname(oparg->argv[loop_to]);

		errno = 0;
		realpath(c, tmp_to);

		if(errno != 0)
		{
			print_error("realpath", __FILE__, __LINE__, cpdd);
			fprintf(stderr, "コピー先が不定です\n");
			exit(EXIT_FAILURE);
		}

		free(c);
	}
	else
	{
		print_error("realpath", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コピー先が不定です\n");
		exit(EXIT_FAILURE);
	}

	int len_to = strlen(tmp_to);
	delete_last_slash(len_to, tmp_to);

	for(; loop < loop_to; loop++)
	{
		_Bool from_current_flag = false;

		/* strcmpは等しければ0を返す */
		if(strcmp(oparg->argv[loop], "..") == 0)
		{
			fprintf(stderr, "..をスキップします\n");
			continue;
		}
		else if(strcmp(oparg->argv[loop], ".") == 0)
		{
			from_current_flag = true;
		}
		/*
		 * メモ
		 * cpコマンドの場合、引数が.だったらそのフォルダにあるファイルをコピーする。
		 * 引数が..だとエラー。
		*/

		_Bool link_flag = false;

		if(g_file_test(oparg->argv[loop], G_FILE_TEST_IS_SYMLINK) == TRUE)
		{
			link_flag = true;
			strcpy(tmp_from, oparg->argv[loop]);
		}
		else
		{
			errno = 0;
			realpath(oparg->argv[loop], tmp_from);

			if(errno != 0)
			{
				print_error("realpath", __FILE__, __LINE__, cpdd);
				fprintf(stderr, "%s\n", oparg->argv[loop]);
				continue;
			}
		}

		int len_from = strlen(tmp_from);
		delete_last_slash(len_from, tmp_from);

		CPInfo *cpinfo = cpinfo_malloc();

		len_from++;
		cpinfo->from = xmalloc(len_from);
		memcpy(cpinfo->from, tmp_from, len_from);
		len_from--;

		if(file_found == true)
		{
			if(g_file_test(tmp_to, G_FILE_TEST_IS_REGULAR) == TRUE)
			{
				len_to++;
				cpinfo->to = xmalloc(len_to);
				memcpy(cpinfo->to, tmp_to, len_to);
				len_to--;

				switch(acount)
				{
				case SINGULAR:
					if(link_flag == true)
					{
						fprintf(stderr, "リンク (%s) に対するコピー先が不正 (ファイル) です\n", tmp_from);
						exit(EXIT_FAILURE);
					}
					else if(g_file_test(tmp_from, G_FILE_TEST_IS_REGULAR) == TRUE)
					{
						FILE_COPY
					}
					else if(g_file_test(tmp_from, G_FILE_TEST_IS_DIR) == TRUE)
					{
						fprintf(stderr, "フォルダ (%s) に対するコピー先が不正 (ファイル) です\n", tmp_from);
						exit(EXIT_FAILURE);
					}
					else
					{
						fprintf(stderr, "コピー先が不正 (ファイル) です\n");
						exit(EXIT_FAILURE);
					}
					break;

				default:
					fprintf(stderr, "複数のコピー元に対するコピー先が不正 (ファイル) です\n");
					exit(EXIT_FAILURE);
					break;
				}
			}
			else if(g_file_test(tmp_to, G_FILE_TEST_IS_DIR) == TRUE)
			{
				cpinfo->to = get_to_plus_fromname(tmp_from, tmp_to);
				if(link_flag == true)
				{
					LINK_COPY
				}
				else if(g_file_test(tmp_from, G_FILE_TEST_IS_REGULAR) == TRUE)
				{
					FILE_COPY
				}
				else if(g_file_test(tmp_from, G_FILE_TEST_IS_DIR) == TRUE)
				{
					DIR_COPY
				}
				else
				{
					fprintf(stderr, "%s をスキップします\n", tmp_from);
				}
			}
			else
			{
				fprintf(stderr, "コピー先が不正です\n");
				exit(EXIT_FAILURE);
			}
		}
		else
		{
			if(acount == PLURAL)
			{
				char *target;
				errno = 0;

				if(mkdir(oparg->argv[loop_to], 0755) == -1)
				{
					if((errno != EEXIST) && (errno != 0))
					{
						print_error("mkdir", __FILE__, __LINE__, cpdd);
						fprintf(stderr, "コピー先フォルダの作成に失敗しました\n");
						exit(EXIT_FAILURE);
					}
				}
				else
				{
					target = get_to_plus_fromname(oparg->argv[loop_to], tmp_to);
					strcpy(tmp_to, target);
					cpinfo->to = get_to_plus_fromname(tmp_from, target);
					free(target);
					file_found = true;
				}
			}
			else
			{
				cpinfo->to = get_to_plus_fromname(oparg->argv[loop_to], tmp_to);
			}

			if(link_flag == true)
			{
				LINK_COPY
			}
			else if(g_file_test(tmp_from, G_FILE_TEST_IS_REGULAR) == TRUE)
			{
				FILE_COPY
			}
			else if(g_file_test(tmp_from, G_FILE_TEST_IS_DIR) == TRUE)
			{
				DIR_COPY
			}
			else
			{
				fprintf(stderr, "%s をスキップします\n", tmp_from);
			}
		}
	}

	RData *rdata = xmalloc(sizeof(RData));
	rdata->file_list = file_list;
	rdata->cpdd = cpdd;

/*
	THIS_DIR_FREE
*/
	return rdata;
}

/*******************************************************************************
*******************************************************************************/
#define DO_NOT_OVERWRITE_FLAG \
{\
	cpinfo->write = false;\
	cpinfo->skip = true;\
}

#define FILE_WRITE_OR_CREATE_LINK_OVERWRITE \
{\
	if(cpinfo->from_type == REGULAR)\
	{\
		read_write(oparg, sdir, cpinfo, cpdd);\
	}\
	else \
	{\
		create_symboliclink(oparg, cpinfo, cpdd);\
	}\
}

#define MAKE_THIS_DIR \
this_dir = g_path_get_dirname(cpinfo->to);

#define THIS_DIR_CHECK \
{\
	char *tmp = g_path_get_dirname(cpinfo->to);\
	char *tmp2 = this_dir;\
	char *tmp_free = tmp;\
	int tmp_len = strlen(tmp);\
	int this_len = strlen(tmp2);\
	_Bool flag = false;\
\
	if(this_len == tmp_len)\
	{\
		if(strcmp(tmp2, tmp) == 0)\
		{\
			flag = true;\
		}\
	}\
	else if(this_len < tmp_len)\
	{\
		for(;;)\
		{\
			if(*tmp2 == *tmp)\
			{\
				tmp2++;\
				tmp++;\
			}\
			else \
			{\
				break;\
			}\
\
			if(*tmp2 == '\0')\
			{\
\
				if(*tmp == G_DIR_SEPARATOR)\
				{\
					flag = true;\
				}\
				break;\
			}\
		}\
	}\
\
	if(flag == false)\
	{\
		b = false;\
	}\
\
	free(tmp_free);\
}

#define THIS_DIR_FREE \
{\
	if(this_dir != NULL)\
	{\
		free(this_dir);\
		this_dir = NULL;\
	}\
}

enum I_OverWrite_Type
{
	INFO,
	THIS_DIR_YES,
	THIS_DIR_NO,
};

enum I_OverWrite_Type iowt;
static OPFlag I;
static OPFlag WMODE;
static _Bool info_flag;
static char *this_dir;

/*******************************************************************************
*******************************************************************************/
void check_overwrite(const OPArg *oparg, const SDir *sdir, CPInfo *cpinfo, CPDD *cpdd)
{
	if(info_flag == false)
	{
		iowt = INFO;

		/* 変更される可能性があるオプションはローカル変数に入れておく */
		I = oparg->I;
		WMODE = oparg->WRITE_MODE;
		info_flag = true;
	}

	gboolean fcheck  = g_file_test(cpinfo->to, G_FILE_TEST_EXISTS);

	/* TRUE・FALSE　→　glib */
	/* true・false　→　stdbool */
	if(fcheck == FALSE)
	{
		if(cpinfo->from_type == REGULAR)
		{
			read_write(oparg, sdir, cpinfo, cpdd);
		}
		else
		{
			/* create_symboliclinkでも再度、上書きチェックを行っている。 */
			create_symboliclink(oparg, cpinfo, cpdd);
		}
	}
	else
	{
		cpinfo->file_test = true;

		if(I == INTERACTIVE)
		{
			/*
			 * -i（上書き確認）モード
			 * ここの処理はgoto使わずに関数にまとめた方が分かりやすいかもしれない
			*/
INPUT:
			/*
			 * gotoのラベルの直後で変数の宣言をすると、
			 * a label can only be part of a statement and a declaration is not a statement
			 * というエラーが出る。
			 */

			switch(iowt)
			{
			case INFO:
				printf("%sは既に存在します。\n", cpinfo->to);
				puts("上書きしますか? (y: Yes  a: 全てYes  d: このフォルダのみYes  n: No  o: このフォルダのみNo  z: 全てNo)");
				printf(" : ");

				char stdin_buf[NAME_MAX];

				if(fgets(stdin_buf, NAME_MAX, stdin) == NULL)
				{
					fgets_is_null();
				}

				clean(stdin_buf, NAME_MAX);

				if(
					stdin_buf[0] != 'y' &&
					stdin_buf[0] != 'a' &&
					stdin_buf[0] != 'd' &&
					stdin_buf[0] != 'n' &&
					stdin_buf[0] != 'o' &&
					stdin_buf[0] != 'z'
				)
				{
					goto INPUT;
				}

				switch(stdin_buf[0])
				{
				case 'y':	/* 上書き */
					FILE_WRITE_OR_CREATE_LINK_OVERWRITE
					break;

				case 'a':	/* 全て上書き */
					FILE_WRITE_OR_CREATE_LINK_OVERWRITE
					I = NOT;	/* 上書き確認モード無効 */
					/* WMODE = OVERWRITE; */
					/* ↑上書き確認モードでは最初からOVERWRITEになっている */
					break;

				case 'd':	/* このフォルダでのみ上書き */
					FILE_WRITE_OR_CREATE_LINK_OVERWRITE
					iowt = THIS_DIR_YES;
					THIS_DIR_FREE
					MAKE_THIS_DIR
					break;

				case 'n':	/* 上書きしない */
					DO_NOT_OVERWRITE_FLAG
					break;

				case 'o':	/* このフォルダでは上書きしない */
					DO_NOT_OVERWRITE_FLAG
					iowt = THIS_DIR_NO;
					THIS_DIR_FREE
					MAKE_THIS_DIR
					break;

				case 'z':	/* 全て上書きしない */
					DO_NOT_OVERWRITE_FLAG
					I = NOT;	/* 上書き確認モード無効 */
					WMODE = NO_OVERWRITE;	/* 非上書きモード */
					break;
				}
				break;

			case THIS_DIR_YES:
				{
					_Bool b = true;

					THIS_DIR_CHECK

					if(b == true)
					{
						FILE_WRITE_OR_CREATE_LINK_OVERWRITE
					}
					else
					{
						/* 再び上書き確認モードに */
						iowt = INFO;
						THIS_DIR_FREE
						goto INPUT;
					}
				}
				break;

			case THIS_DIR_NO:
				{
					_Bool b = true;

					THIS_DIR_CHECK

					if(b == true)
					{
						DO_NOT_OVERWRITE_FLAG
					}
					else
					{
						/* 再び上書き確認モードに */
						iowt = INFO;
						THIS_DIR_FREE
						goto INPUT;
					}
				}
				break;
			}
		}
		else
		{
			if(WMODE == NO_OVERWRITE)
			{
				DO_NOT_OVERWRITE_FLAG
			}
			else
			{
				FILE_WRITE_OR_CREATE_LINK_OVERWRITE
			}
		}
	}
}

/*******************************************************************************
*******************************************************************************/
struct stat * make_directory(CPInfo *cpinfo, OPArg *oparg, CPDD *cpdd)
{
	errno = 0;
	if(g_file_test(cpinfo->to, G_FILE_TEST_EXISTS) == TRUE)
	{
		/* フォルダの作成は行わない */
		DO_NOT_OVERWRITE_FLAG
	}
	else if(mkdir(cpinfo->to, 0755) == -1)
	{
		cpinfo->write = false;

		if((errno != EEXIST) && (errno != 0))
		{
			print_error("mkdir", __FILE__, __LINE__, cpdd);
			fprintf(stderr, "フォルダの作成に失敗しました (%s) \n", cpinfo->to);
		}
	}
	else
	{
		if(oparg->V == VERBOS)
		{
			printf("%s -> %s\n", cpinfo->from, cpinfo->to);
			fflush(stdout);
		}

		cpinfo->write = true;
		cpdd->mk_dir_count++;
	}

	struct stat *stat_buf = xmalloc(sizeof(struct stat));

	if(stat(cpinfo->from, stat_buf) != 0)
	{
		print_error("stat", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "フォルダ情報取得エラーです (%s) \n", cpinfo->from);
		free(stat_buf);
		stat_buf = NULL;
	}

	return stat_buf;
}

/*******************************************************************************
*******************************************************************************/
#include <dirent.h>

#define TYPE_IS_LINK \
{\
	count_link_plus(cpinfo, cpdd);\
	check_overwrite(oparg, sdir, cpinfo, cpdd);\
	file_list = append_list(file_list, (void *)cpinfo);\
}

#define TYPE_IS_FILE \
{\
	count_file_plus(cpinfo, cpdd);\
	cpinfo->copy_mode = cpinfo_tmp->copy_mode;\
	check_overwrite(oparg, sdir, cpinfo, cpdd);\
	file_list = append_list(file_list, (void *)cpinfo);\
}

#define TYPE_IS_DIR \
{\
	count_dire_plus(cpinfo, cpdd);\
	cpinfo->copy_mode = cpinfo_tmp->copy_mode;\
	struct stat *stat_buf = make_directory(cpinfo, oparg, cpdd);\
	file_list = append_list(file_list, (void *)cpinfo);\
	/* 再帰 */ \
	file_list = dir_traverse(file_list, cpinfo, oparg, sdir, cpdd);\
	if(cpinfo->write == true) {ch_time_and_mod_dir(cpinfo, stat_buf, cpdd); }\
}

/*******************************************************************************
 * フォルダを走査
*******************************************************************************/
static VList * dir_traverse(VList *file_list, CPInfo *cpinfo_tmp, OPArg *oparg, SDir *sdir, CPDD *cpdd)
{
	DIR *dp = NULL;
	struct dirent *entry = NULL;
	const char *d_name;
	const char *from_dir = cpinfo_tmp->from;
	const char *to_dir = cpinfo_tmp->to;

	if((dp = opendir(from_dir)) != NULL)
	{
		while((entry = readdir(dp)) != NULL)
		{
			d_name = entry->d_name;
			/* strcmpは等しければ0を返す（0は偽） */
			if(strcmp(d_name, ".") && strcmp(d_name, ".."))
			{
				int fdir = strlen(from_dir);
				int tdir = strlen(to_dir);
				int d_len = strlen(d_name);

				CPInfo *cpinfo = cpinfo_malloc();

				/* +2は、 \0 と / の分 */
				cpinfo->from = xmalloc(fdir + d_len + 2);
				cpinfo->to = xmalloc(tdir + d_len + 2);
				cpinfo->tofs = cpinfo_tmp->tofs;
				cpinfo->copy_mode = cpinfo_tmp->copy_mode;
				/*
				 * sprintfは便利だってLeptonさんが言ってた。
				 * printf系の関数は遅い？知るか。
				*/
				sprintf(cpinfo->from, "%s%s%s", from_dir, G_DIR_SEPARATOR_S, d_name);
				sprintf(cpinfo->to, "%s%s%s", to_dir, G_DIR_SEPARATOR_S, d_name);

				switch(entry->d_type)
				{
				case DT_LNK:
					TYPE_IS_LINK
					break;

				case DT_REG:
					TYPE_IS_FILE
					break;

				case DT_DIR:
					TYPE_IS_DIR
					break;

				default:
					if(g_file_test(cpinfo->from, G_FILE_TEST_IS_SYMLINK) == TRUE)
					{
						TYPE_IS_LINK
					}
					else if(g_file_test(cpinfo->from, G_FILE_TEST_IS_REGULAR) == TRUE)
					{
						TYPE_IS_FILE
					}
					else if(g_file_test(cpinfo->from, G_FILE_TEST_IS_DIR) == TRUE)
					{
						TYPE_IS_DIR
					}
					else
					{
						fprintf(stderr, "このファイル (%s) をスキップします\n", cpinfo->from);
					}
					break;
				}
			}
		}
		if(closedir(dp) == -1)
		{
			print_error("closedir", __FILE__, __LINE__, cpdd);
		}
	}
	else
	{
		print_error("opendir", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "%s を読み取れませんでした\n", from_dir);
	}

	return file_list;
}

/*******************************************************************************
 * 文字列の最後がパス区切り文字だった場合\0にする
*******************************************************************************/
static inline void delete_last_slash(const int len, char tmp[])
{
	if(tmp[len - 1] == G_DIR_SEPARATOR)
	{
		tmp[len - 1] = '\0';
	}
}

/******************************************************************************
*******************************************************************************/
static inline CPInfo * cpinfo_malloc(void)
{
	CPInfo *cpinfo = xmalloc(sizeof(CPInfo));
	cpinfo->from = NULL;
	cpinfo->to = NULL;
	cpinfo->tofs = NULL;
/*	cpinfo->from_type = */
	cpinfo->copy_mode = SAME;
	cpinfo->write = false;
	cpinfo->skip = false;
	cpinfo->hash_check = false;
	cpinfo->file_test = false;
	cpinfo->verify_md5 = NULL;
	cpinfo->from_size = 0;
	cpinfo->to_size = 0;

	return cpinfo;
}

/*******************************************************************************
 * コピー元ファイル名とコピー先パスを連結する。
 * g_path_get_basename と g_build_path を同時にやる感じ。
*******************************************************************************/
static inline char * get_to_plus_fromname(const char *from, const char *to)
{
	char fname[PATH_MAX];
	char *return_name;
	int from_len = strlen(from);
	int to_len = strlen(to);
	_Bool flag = false;

	for(int i = from_len - 1; i >= 0; i--)
	{
		/*
		 * 最後のパス区切り文字からコピーするので、
		 * fnameは以下となる。
		 * 
		 * /ファイル名\0
		*/
		if(from[i] == G_DIR_SEPARATOR)
		{
			flag = true;
			int j = 0;

			for(;;)
			{
				fname[j] = from[i];

				if(from[i] == '\0')
				{
					goto BASENAME_END;
				}

				i++;
				j++;
			}
		}
	}

BASENAME_END:

	if(flag == true)
	{
		int name_len = strlen(fname);
		/* +1 はヌル文字（\0）の分 */
		return_name = xmalloc(to_len + name_len + 1);
		memcpy(return_name, to, to_len + 1);
		strcat(return_name, fname);
	}
	else
	{
		/*
		 * 2011年3月19日
		 * メモリ破壊のバグぅうわあああ。
		 * append_list内のxmalloc内で、malloc(): memory corruption
		 * とか出てアボートするバグを直せた。
		 * return_name = xmalloc(from_len + to_len + 1);
		 * ↑こいつが原因だった。G_DIR_SEPARATOR_Sのことを忘れてた。
		 * 多分これで大丈夫。
		*/
		return_name = xmalloc(from_len + to_len + (sizeof(G_DIR_SEPARATOR_S) + 1));
		memcpy(return_name, to, to_len + 1);
		strcat(return_name, G_DIR_SEPARATOR_S);
		strcat(return_name, from);
	}

	return return_name;
}

/******************************************************************************
*******************************************************************************/
static inline void count_link_plus(CPInfo *cpinfo, CPDD *cpdd)
{
	cpinfo->from_type = SYMBOLICLINK;
	cpdd->link_count++;
}

/******************************************************************************
*******************************************************************************/
static inline void count_file_plus(CPInfo *cpinfo, CPDD *cpdd)
{
	cpinfo->from_type = REGULAR;
	cpdd->file_count++;
}

/******************************************************************************
*******************************************************************************/
static inline void count_dire_plus(CPInfo *cpinfo, CPDD *cpdd)
{
	cpinfo->from_type = DIRECTORY;
	cpdd->dir_count++;
}

/*******************************************************************************
*******************************************************************************/
static inline void ch_time_and_mod_dir(const CPInfo *cpinfo, const struct stat *stat_buf, CPDD *cpdd)
{
	errno = 0;

	if(chmod(cpinfo->to, stat_buf->st_mode) == -1)
	{
		print_error("chmod", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "フォルダ情報変更エラーです (%s) \n", cpinfo->to);
	}

/*
	if(chown(cpinfo->to, stat_buf->st_uid, stat_buf->st_gid) == -1)
	{
		print_error("chown", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "フォルダ情報変更エラーです (%s) \n", cpinfo->to);
	}
*/

	chown(cpinfo->to, stat_buf->st_uid, stat_buf->st_gid);

	static struct utimbuf times;
	times.actime  = stat_buf->st_atime;
	times.modtime = stat_buf->st_mtime;

	if(utime(cpinfo->to, &times) == -1)
	{
		print_error("utime", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "フォルダ情報変更エラーです (%s) \n", cpinfo->to);
	}
}

/*******************************************************************************
 * 入力バッファのクリア
*******************************************************************************/
static inline void clean(const char stdin_buf[], const int INPUT_LEN)
{
	/* バッファチェック */
	_Bool flag = false;
	for(int i = 0; i < INPUT_LEN; i++)
	{
		if(stdin_buf[i] == '\n')
		{
			flag = true;
			break;
		}
	}
	/* 入力バッファの掃除 */
	if(flag == false)
	{
		while(getchar() != '\n');
	}
}

/*******************************************************************************
 * fgetsの戻り値がNULLだった場合
*******************************************************************************/
static inline void fgets_is_null(void)
{
	fprintf(stderr, "fgetsの戻り値がNULLです\n");
	exit(EXIT_FAILURE);
}

/******************************************************************************
*******************************************************************************/
#define PATH_CHECK \
const char *mp = tmp->mount_point;\
_Bool flag = false;\
\
for(;;)\
{\
	if(*path == *mp)\
	{\
		path++;\
		mp++;\
	}\
	else \
	{\
		break;\
	}\
\
	if(*mp == '\0')\
	{\
		if((*path == G_DIR_SEPARATOR) || (*path == '\0'))\
		{\
			flag = true;\
		}\
		break;\
	}\
}

/******************************************************************************
 * ドライブが同一かどうか調べる
*******************************************************************************/
static inline void set_same_or_different(const VList *drive_list, const char *from, const char *to, CPInfo *cpinfo, OPArg *oparg)
{
	/*
	 * キャストしないと警告が出る
	 * warning: initialization discards qualifiers from pointer target type
	*/
	VList *tmplist = (VList *)drive_list;
	char *fromdev = NULL;
	char *todev = NULL;

	for(;;)
	{
		DPath *tmp = (DPath *)tmplist->data;
/*
printf("%s %s\n", tmp->device, tmp->mount_point);
*/
		if((tmp->mount_point[1] == '\0') && (tmp->mount_point[0] == G_DIR_SEPARATOR))
		{
			if(fromdev == NULL)
			{
				fromdev = tmp->device;
			}

			if(todev == NULL)
			{
				todev = tmp->device;
				cpinfo->tofs = tmp->fs;
			}

			goto DEV_CHECK_SKIP;
		}

		{
			const char *path = from;

			PATH_CHECK

			if(flag == true)
			{
				fromdev = tmp->device;
			}
		}

		{
			const char *path = to;

			PATH_CHECK

			if(flag == true)
			{
				todev = tmp->device;
				cpinfo->tofs = tmp->fs;
			}
		}

DEV_CHECK_SKIP:
;
		if(tmplist->next != NULL)
		{
			tmplist = tmplist->next;
		}
		else
		{
			break;
		}
	}

	if((fromdev != NULL) && (todev != NULL))
	{
		if(strcmp(fromdev, todev) == 0)
		{
			cpinfo->copy_mode = SAME;
		}
		else
		{
			cpinfo->copy_mode = DIFFERENT;
		}
	}
	else
	{
		cpinfo->copy_mode = SAME;
	}

	switch(oparg->THREAD_MODE)
	{
	case DRIVE_SAME:
		cpinfo->copy_mode = SAME;
		break;
	case DRIVE_DIFFERENT:
		cpinfo->copy_mode = DIFFERENT;
		break;
	case DRIVE_AUTO:
		break;
	default:
		cpinfo->copy_mode = SAME;
		break;
	}
}
