#ifndef CH_TIME_AND_MOD_LINK_H
#define CH_TIME_AND_MOD_LINK_H

#define _GNU_SOURCE

#include "print_error.h" // inline
#include "struct_CPInfo.h"

#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>

static struct timespec time_s[2];

/* 関数プロトタイプ */
static inline void ch_time_and_mod_link(const struct stat *stat_buf, const CPInfo *cpinfo, CPDD *cpdd) __attribute__((always_inline));

/*******************************************************************************
*******************************************************************************/
static inline void ch_time_and_mod_link(const struct stat *stat_buf, const CPInfo *cpinfo, CPDD *cpdd)
{
	errno = 0;
/*
	if(lchown(cpinfo->dst, stat_buf->st_uid, stat_buf->st_gid) == -1)
	{
		print_error("lchown", __FILE__, __LINE__, cpdd);
	}
*/

	lchown(cpinfo->dst, stat_buf->st_uid, stat_buf->st_gid);

	time_s[0].tv_sec = stat_buf->st_atime;
	time_s[1].tv_sec = stat_buf->st_mtime;

	time_s[0].tv_nsec = stat_buf->st_atim.tv_nsec;
/* time_s[0].tv_nsec = stat_buf->st_atimensec; */
	time_s[1].tv_nsec = stat_buf->st_mtim.tv_nsec;
/* time_s[1].tv_nsec = stat_buf->st_mtimensec; */

	/* 第四引数は0かAT_SYMLINK_NOFOLLOW */
	if(utimensat(AT_FDCWD, cpinfo->dst, time_s, AT_SYMLINK_NOFOLLOW) == -1)
	{
		print_error("utimensat", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "ファイル情報変更エラーです (%s) \n", cpinfo->dst);
	}
}

#endif
