#ifndef DO_COMPARE_VERIFY_ONE_H
#define DO_COMPARE_VERIFY_ONE_H

#include "gettext.h"
#include "struct_CPDD.h"
#include "struct_CPInfo.h"
#include "struct_OPArg.h"
#include "struct_SDir.h"
#include "verify_hash.h"

static inline void compare_verify_one(const OPArg *, const SDir *, CPInfo *, CPDD *);

/******************************************************************************
*******************************************************************************/
static inline void compare_verify_one(const OPArg *oparg, const SDir *sdir, CPInfo *cpinfo, CPDD *cpdd)
{
	switch(oparg->CHECK)
	{
	case V_FIVE:
		if((cpinfo->src_md5 != NULL) && (cpinfo->dst_para == WRITE))
		{
			verify_hash(oparg, sdir, cpinfo, cpdd);
		}
		break;

	default:
		fprintf(stderr, _("ハッシュチェックオプションが不正です\n"));
		break;
	}
}

#endif
