#include "gettext.h"

#include <stdio.h>

static char version[] = "0.16.12 beta";

/* 関数プロトタイプ */
void help(void);

/*******************************************************************************
 * ヘルプ
*******************************************************************************/
void help()
{
	printf(_("バージョン : %s\n"), version);
	puts(_("使用方法   : snowcp [option] src dst"));
	puts(_("概要       : 単一または複数の src を dst へコピーする。dstが存在しない場合は自動的に作成する。"));
	puts("");
	puts(_("オプション"));
	puts(_(" -b NUMBER  バッファの量を指定する（MB単位、デフォルト値は32）。"));
	puts(_("            (例 : snowcp -b 16 src dst)"));
	puts("");
	puts(_(" -h         ヘルプを表示する。"));
	puts(_("            (例 : snowcp -h)"));
	puts("");
	puts(_(" -i         ファイルを上書きする前に確認する。"));
	puts(_("            (例 : snowcp -i src dst)"));
	puts("");
	puts(_(" -I         -iオプションを無効にする。"));
	puts(_("            (例 : snowcp -I src dst)"));
	puts("");
	puts(_(" -l         ベリファイのログを保存する。"));
	puts(_("            (例 : snowcp -r 2 -l src dst)"));
	puts("");
	puts(_(" -L         -lオプションを無効にする。"));
	puts(_("            (例 : snowcp -L src dst)"));
	puts("");
	puts(_(" -m         コピー終了後、コピー元を削除する。"));
	puts(_("            (例 : snowcp -m src dst)"));
	puts("");
	puts(_(" -M         -mオプションを無効にする。"));
	puts(_("            (例 : snowcp -M src dst)"));
	puts("");
	puts(_(" -o         設定を保存する。"));
	puts(_("            (例 : snowcp -o)"));
	puts("");
	puts(_(" -r MODE    ベリファイ(MD5)を行う。"));
	puts(_("            MODEが1の場合はコピー直後に、"));
	puts(_("            2の場合は全コピー終了後にベリファイを実行する。"));
	puts(_("            一致しなかった場合はdstを削除する。"));
	puts(_("            0の場合はこのオプションを無効にする。"));
	puts(_("            (例 : snowcp -r 1 src dst)"));
	puts("");
	puts(_(" -t MODE    スレッドモードを指定する。"));
	puts(_("            MODEが1の場合は常に同一ドライブモード、"));
	puts(_("            2の場合は常に別ドライブモード、"));
	puts(_("            0の場合は自動判別モードで動作する。"));
	puts(_("            (例 : snowcp -t 1 src dst)"));
	puts("");
	puts(_(" -v         コピー中のファイル名を表示する。"));
	puts(_("            (例 : snowcp -v src dst)"));
	puts("");
	puts(_(" -w MODE    上書きモードを指定する。"));
	puts(_("            MODEが1の場合はサイズか日付が異なる時、"));
	puts(_("            2の場合は日付が新しい時、"));
	puts(_("            3の場合は常に上書きする。"));
	puts(_("            0の場合、上書きしない。"));
	puts(_("            (例 : snowcp -w 3 src dst)"));
	puts("");
	puts(_("オプションを付けずに実行した場合、以下と同じ動作をする。"));
	puts(_("snowcp -b 32 -t 0 -w 1 src dst"));
	puts("");
	puts(_("設定ファイルよりもオプションの方が優先順位は上である。例えば設定ファイルで -r 2 オプションが有効でも、実行時に snowcp -r 0 src dst とすれば -r オプションは無効になる。"));
	puts("");
	puts(_("オプションは後に入力した方が優先される。例えば snowcp -iw とした場合は -w オプションが有効になる。"));
	puts("");
	puts(_("-i オプションを付けた場合、ファイルサイズやタイムスタンプの比較は行われない。"));
	puts("");
	puts(_("スレッドモードは引数として与えたファイル／フォルダを基準とするため、サブフォルダにファイルシステムをマウントしている場合は、正常に動作しない。"));
	puts("");
}
