#ifndef PRINT_ERROR_H
#define PRINT_ERROR_H

#include "gettext.h"
#include "struct_CPDD.h"

#include <stdio.h>
#include <string.h>

#include <errno.h>

static void print_error(const char *func, const char *path, const char *source_code_file_name, const int line, CPDD *cpdd);

/*******************************************************************************
*******************************************************************************/
static void print_error(const char *func, const char *path, const char *source_code_file_name, const int line, CPDD *cpdd)
{
	fprintf(stderr, _("%s : %d行\n"), source_code_file_name, line);

	if(strcmp(func, "NULL") != 0)
	{
		perror(func);
	}

	if(strcmp(path, "NULL") != 0)
	{
		fprintf(stderr, _("error : %s\n"), path);
	}

	cpdd->total_error++;
}

#endif
