<?php
define("DELETED_STRING", "ܡ");

class CommentFormlet {

  function show($num=DEFAULT_COMMENT_NUMBER) {
    global $request;
    $page = $request['name'];
    CommentFormlet::showPage($page, $num);
  }

  function showPage($page, $num) {
    $comments = WikiCommentStorage::getComments($page);
    $i = 0;
    // if $num == 0, show all comments
    if (count($comments) > DEFAULT_COMMENT_NUMBER && $num != 0) {
      $i = count($comments) - $num;
      $comments = array_slice($comments, 0 - $num);
    }
    $formatter = new Formatter();
    foreach ($comments as $c) {
      $i++;
      CommentFormlet::printComment($c, $i, $formatter, $page);
    }

    if (count($comments) > 0) {
      $lastComment = $comments[count($comments)-1];
      $user = WebSession::loginUserName();
      if (WebSession::isLogined()) {
	if ($user == $lastComment->name or $lastComment->name == "Guest") {
	  printf('<p><a href="index.php?mod=CommentEdit&amp;name=%s">Edit last comment</a></p>',
		 htmlspecialchars(urlencode($page)));
	}
      }
    }
    ?>
      <a name="comment"><form method="post" action="index.php"></a>
      <input type="hidden" name="action" value="comment">
      <input type="hidden" name="name" value="<?php echo $page ?>">
      <textarea name="content" cols="60" rows="3"></textarea><br>
      <input type="submit" value=" Post ">
      <?php if(!WebSession::isLogined()): ?>
       User̾=Guest Ƥޤ
      <?php endif; ?>
      </form>
    <?php
  }

  function printComment($comment, $num, $formatter, $pageName) {
    $text = rtrim($comment->getContent());
    $text = htmlspecialchars($text);
    $text = $formatter->format($text);
    $date = $comment->getDate();
    if ($comment->aborn) {
      $name = $comment->getName();
    }
    else {
      $name = Formatter::linkToPageIfUserExists($comment->getName());
    }
    if (WebSession::isLogined() && WebSession::isAdmin()) {
      if ($comment->aborn) {
        $button = CommentFormlet::makeRevertButton($pageName, $num);
      }
      else {
        $button = CommentFormlet::makeAbornButton($pageName, $num);
      }
    }
    else {
      $button = "";
    }
    ?>
    <dl><dt>
      <?php echo $num ?>
      ̾<?php echo $name ?>
      (<?php echo $date ?>)
       <?php echo $button ?>
      </dt>
      <dd><?php echo $text ?></dd>
    </dl>
    <?php
  }

  function makeAbornButton($pageName, $num) {
    return sprintf('[<a href="index.php?mod=AbornComment&amp;name=%s&amp;num=%s">del</a>]',
                   urlencode($pageName), $num);
  }

  function makeRevertButton($pageName, $num) {
    return sprintf('[<a href="index.php?mod=RevertComment&amp;name=%s&amp;num=%s">revert</a>]',
                   urlencode($pageName), $num);
  }

  function action($params) {
    $property = Property::instance();

    $pageName = $params['name'];
    $userName = WebSession::loginUserName();
    $content = $params["content"];

    $date = date("Y-m-d H:i:s");
    $comment = new Comment($date, $userName, $content);
    WikiCommentStorage::appendComment($comment, $pageName);
    $property->set($pageName, 'last_commented_user', WebSession::loginUserName());
    Rss::writeRecentComments();
    $escaped = htmlspecialchars(urlencode($pageName));
    redirect_to("index.php?mod=WikiView&name=$escaped#comment",
		"ȤƤޤ", 0);
  }
}

class Comment {
  var $date, $name, $content, $aborn;

  function Comment($date, $name, $content) {
    $this->date = $date;
    $this->name = $name;
    $this->content = $this->escape($content);
  }

  function getDate() {
    if ($this->aborn) {
      return DELETED_STRING;
    }
    else {
      return $this->date;
    }
  }

  function getName() {
    if ($this->aborn) {
      return DELETED_STRING;
    }
    else {
      return $this->name;
    }
  }

  function getRawContent() {
    return $this->unescape($this->content);
  }

  function getContent() {
    if ($this->aborn) {
      return DELETED_STRING;
    }
    else {
      return $this->unescape($this->content);
    }
  }

  function unescape($text) {
    $match = array("/~~/", "/~%/", "/".chr(255)."/");
    $replace = array(chr(255), "\n", "~");
    return preg_replace($match, $replace, $text);
  }

  function getUnixTime() {
    list($d, $t) = explode(" ", $this->date);
    list($Y, $M, $D) = explode("-", $d);
    list($h, $m, $s) = explode(":", $t);
    return mktime($h, $m, $s, $M, $D, $Y);
  }

  function escape($text) {
    $match = array("/\r\n/", "/\r/", '/~/', '/\\n/');
    $replace = array("\n", "", '~~', '~%');
    return preg_replace($match, $replace, $text);
  }
}

class CommentEditFormlet {
  function show() {
    global $request;
    check_pagename($request["name"]);
    $page = $request['name'];
    $comments = WikiCommentStorage::getComments($page);
    $lastComment = $comments[count($comments)-1];
    $userName = WebSession::loginUserName();
    if ($lastComment->name != $userName && $lastComment->name != "Guest") {
      echo 'error.';
      exit;
    }
    $text = rtrim($lastComment->getRawContent());
    $text = htmlspecialchars($text);
    ?>
      <form method="post" action="index.php"></a>
      <input type="hidden" name="action" value="lastCommentEdit">
      <input type="hidden" name="name" value="<?php echo $page ?>">
      <textarea name="content" cols="60" rows="10"><?php echo $text ?></textarea><br>
      <input type="submit" value=" Post ">
      </form>
    <?php
  }

  function action($params) {
    check_pagename($params['name']);
    $userName = WebSession::loginUserName();
    $pageName = $params['name'];
    $comments = WikiCommentStorage::getComments($pageName);
    $lastComment = $comments[count($comments)-1];
    $returnUrl = CommentEditFormlet::makeUrl($pageName);

    if ($lastComment->name != $userName && $lastComment->name != "Guest") {
      redirect_to($returnUrl, "Խθ¤ޤ");
    }
    $content = $params["content"];
    $property = Property::instance();
    if ($content == "") {
      CommentEditFormlet::deleteComment($pageName, $comments);
    }
    else {
      CommentEditFormlet::rewriteComment($pageName, $comments, $userName, $content);
    }
    Rss::writeRecentComments();
    if ($content == "") {
      redirect_to($returnUrl, "Ȥޤ");
    }
    else {
      redirect_to($returnUrl, "Ȥޤ");
    }
  }

  function deleteComment($pageName, $comments) {
    if (sizeof($comments) == 1) {
      WikiCommentStorage::remove($pageName);
    }
    else {
      array_pop($comments);
      $lastComment = $comments[count($comments)-1];
      $time = $lastComment->getUnixTime();
      WikiCommentStorage::writeComments($pageName, $comments);
      touch(WikiCommentStorage::filePath($pageName), $time);
      $property = Property::instance();
      $property->set($pageName, 'last_commented_user', $lastComment->name);
    }
  }

  function rewriteComment($pageName, $comments, $userName, $content) {
    $date = date("Y-m-d H:i:s");
    $newComment = new Comment($date, $userName, $content);
    $comments[sizeof($comments)-1] = $newComment;
    WikiCommentStorage::writeComments($pageName, $comments);
    $property = Property::instance();
    $property->set($pageName, 'last_commented_user', $userName);
  }

  function makeUrl($pageName) {
    return sprintf("index.php?mod=WikiView&name=%s#comment", urlencode($pageName));
  }
}

class AbornCommentFormlet {
  function show($name, $num) {
    //ѥ᡼å
    if ($num + 0 < 1) {
      echo "<p>error: ѥ᡼Ǥ</p>";
      return;
    }
    if (!WikiCommentStorage::exists($name)) {
      echo "<p>error: Ȥ¸ߤޤ</p>";
      return;
    }
    $comments = WikiCommentStorage::getComments($name);
    if ($num > sizeof($comments)) {
      echo "<p>error: Ȥ¸ߤޤ</p>";
      return;
    }

    $comment = $comments[$num - 1];
    $formatter = new Formatter();
    echo "<h2>ڡ̾:", htmlspecialchars($name), "</h2>\n";
    CommentFormlet::printComment($comment, $num, $formatter, $name);
    ?>
    <form method="post" action="index.php">
       <input type="hidden" name="action" value="aborncomment">
       <input type="hidden" name="name" value="<?php echo htmlspecialchars($name) ?>">
       <input type="hidden" name="num" value="<?php echo htmlspecialchars($num)?>">
       <input type="submit" value=" delete ">
    </form>
    <?php
  }

  function action($param) {
    $name = $param["name"];
    $num = $param["num"];
    $encName = urlencode($name);
    $escName = htmlspecialchars($name);
    //ڡμºߥå
    if (!WikiCommentStorage::exists($name)) {
      redirect_to("index.php?mod=WikiView&name=$encName#comment",
                  "ڡ${escName}ˤϥȤ¸ߤޤ");
      return;
    }
    //Ȥμºߥå
    $comments = WikiCommentStorage::getComments($name);
    if (sizeof($comments) < $num) {
      redirect_to("index.php?mod=WikiView&name=$encName#comment", "륳Ȥ¸ߤޤ");
      return;
    }
    AbornCommentFormlet::aborncomment($name, $num);
    redirect_to("index.php?mod=WikiView&name=$encName#comment", "ޤ");
  }

  function abornComment($name, $index) {
    $comments = WikiCommentStorage::getComments($name);
    $target = $comments[$index - 1];
    $target->aborn = true;
    $comments[$index - 1] = $target;
    WikiCommentStorage::writeComments($name, $comments);
  }
}

class RevertCommentFormlet {
  function show($name, $num) {
    //ѥ᡼å
    if ($num + 0 < 1) {
      echo "<p>error: ѥ᡼Ǥ</p>";
      return;
    }
    if (!WikiCommentStorage::exists($name)) {
      echo "<p>error: Ȥ¸ߤޤ</p>";
      return;
    }
    $comments = WikiCommentStorage::getComments($name);
    if ($num > sizeof($comments)) {
      echo "<p>error: Ȥ¸ߤޤ</p>";
      return;
    }

    $comment = $comments[$num - 1];
    $formatter = new Formatter();
    echo "<h2>ڡ̾:", htmlspecialchars($name), "</h2>\n";
    $comment->aborn = false;
    CommentFormlet::printComment($comment, $num, $formatter, $name);
    ?>
    <form method="post" action="index.php">
       <input type="hidden" name="action" value="revertcomment">
       <input type="hidden" name="name" value="<?php echo htmlspecialchars($name) ?>">
       <input type="hidden" name="num" value="<?php echo htmlspecialchars($num)?>">
       <input type="submit" value=" revert ">
    </form>
    <?php
  }

  function action($param) {
    $name = $param["name"];
    $num = $param["num"];
    $encName = urlencode($name);
    $escName = htmlspecialchars($name);
    //ڡμºߥå
    if (!WikiCommentStorage::exists($name)) {
      redirect_to("index.php?mod=WikiView&name=$encName#comment",
                  "ڡ${escName}ˤϥȤ¸ߤޤ");
      return;
    }
    //Ȥμºߥå
    $comments = WikiCommentStorage::getComments($name);
    if (sizeof($comments) < $num) {
      redirect_to("index.php?mod=WikiView&name=$encName#comment", "륳Ȥ¸ߤޤ");
      return;
    }
    RevertCommentFormlet::revertComment($name, $num);
    redirect_to("index.php?mod=WikiView&name=$encName#comment", "褷ޤ");
  }

  function revertComment($name, $index) {
    $comments = WikiCommentStorage::getComments($name);
    $target = $comments[$index - 1];
    $target->aborn = false;
    $comments[$index - 1] = $target;
    WikiCommentStorage::writeComments($name, $comments);
  }
}

?>
