<?php
class MenuFormlet {
  function show() {
    if (WebSession::isLogined()) {
      if (WebSession::isAdmin()) {
        $items = MenuFormlet::_adminItems();
      }
      else {
        $items = MenuFormlet::_userItems();
      }
    }
    else {
      $items = MenuFormlet::_guestItems();
    }
    echo '<div class="menu"><form method="get" action="index.php">';
    $user = WebSession::loginUserName();
    if (WebSession::isLogined()) {
      printf('<a href="index.php?mod=Home">%s</a>', htmlspecialchars($user));
    }
    else {
      echo '<a href="index.php">Home</a>';
    }
    MenuFormlet::_showItems($items);
    echo "</form></div>";
  }
  function _guestItems() {
    return array('allpages', 'search', 'login', 'register');
  }
  function _userItems() {
    return array('allpages', 'search', 'logout', 'queue');
  }
  function _adminItems() {
    return array('admin', 'allpages', 'search', 'logout', 'queue');
  }
  function _showItems($items) {
    for ($i = 0; $i < count($items); $i++) {
      echo " | ";
      MenuFormlet::_showItem($items[$i]);
    }
  }
  function _showItem($itemName) {

    switch ($itemName) {
    case 'admin':
      MenuFormlet::_showAdmin();
      break;
    case 'login':
      MenuFormlet::_showLogin();
      break;
    case 'logout':
      MenuFormlet::_showLogout();
      break;
    case 'queue':
      MenuFormlet::_showQueueBox();
      break;
    case 'allpages':
      MenuFormlet::_showAllPages();
      break;
    case 'search':
      MenuFormlet::_showSearch();
      break;
    case 'register':
      MenuFormlet::_showRegisger();
      break;
    }
  }
  function _showAdmin() {
    ?>
    <a href="index.php?mod=Admin">admin</a>
    <?php
  }
  function _showLogin() {
    ?>
    <a href="index.php?mod=Login">login</a>
    <?php
  }
  function _showLogout() {
    ?>
    <a href="index.php?action=logout">logout</a>
    <?php
  }
  function _showQueueBox() {
    global $request;
    if (isset($request['name'])) {
      $name = htmlspecialchars($request['name']);
      echo "    <input type=\"hidden\" name=\"name\" value=\"$name\">\n";
    }
    ?>
    <input type="hidden" name="action" value="queue">
    <input type="hidden" name="cmd" value="add">
    <input type="submit" value="Queue in">
    <input type="text" name="item">
    <?php
  }
  function _showAllPages() {
    ?>
    <a href="index.php?mod=AllPages">all pages</a>
    <?php
  }
  function _showSearch() {
    ?>
    <a href="index.php?mod=Search">search</a>
    <?php
  }
  function _showRegisger() {
    ?>
    <a href="index.php?mod=Account">register</a>
    <?php
  }
}

class LoginFormlet {
  function show() {
    ?>
    <form method="post" action="index.php">
      <input type="hidden" name="action" value="login">
      <table>
       <tr><th>User name:<td><input type="text" name="user" value="">
       <tr><th>password:<td><input type="password" name="pass" value="">
       <tr><td colspan="2"><input type="submit" value=" login ">
      </table>
    </form>
    <?php
  }
  function action($params) {
    global $manager;
    $user = $params['user'];
    $pass = $params['pass'];
    if (!check_naming_rule($user)) {
      redirect_to("index.php?mod=Login", "ʥ桼̾Ǥ");
      exit;
    }
    $account = $manager->find($user);
    if ($account and WebSession::login($account, $pass)) {
      redirect_to("index.php", "󤷤ޤ");
    }
    else {
      redirect_to("index.php?mod=Login",
            "桼̾ѥɤ˸꤬ޤ");
    }
  }
}

class CreateAccountFormlet {
  function show() {
    ?>
    <form method="post" action="index.php">
       <input type="hidden" name="action" value="account">
       <table>
       <tr><th>User name:<td><input type="text" name="user" value="">
       <tr><th>password:<td><input type="password" name="pass" value="">
       <tr><th> (again):<td><input type="password" name="again" value="">
       <tr><td colspan="2"><input type="submit" value=" create ">
       </table>
    </form>
    <?php
  }

  function action($params) {
    global $manager;
    $user = $params['user'];
    $pass = $params['pass'];
    $again = $params['again'];
    CreateAccountFormlet::validateInput($user, $pass, $again);
    $result = CreateAccountFormlet::tryCreate($user, $pass);
    if ($result) {
      redirect_to("index.php", "Ͽޤ");
    }
    else {
      redirect_to("index.php?mod=Account", "Υ顼ΤϿǤޤǤ");
    }
  }

  function validateInput($user, $pass, $again) {
    global $manager;
    if ($manager->exists($user)) {
      redirect_to("index.php?mod=Account",
             "ϿΤ桼̾ΤϿǤޤǤ");
    }
    elseif (!check_naming_rule($user)) {
      redirect_to("index.php?mod=Account",
             "桼̾û뤫ޤϻѤǤʤʸޤޤƤ뤿ϿǤޤǤ");
    }
    elseif ($user == 'Guest') {
      redirect_to("index.php?mod=Account",
             "GuestȤ̾ϻѤǤޤ");
    }
    elseif ($pass != $again) {
      redirect_to("index.php?mod=Account",
             "ѥ԰פΤϿǤޤǤ");
    }
  }

  function tryCreate($user, $pass) {
    global $manager;
    $result = $manager->create($user, $pass);
    if ($result) {
      $account = $manager->find($user);
      WebSession::login($account, $pass);
      return true;
    }
    else {
      return false;
    }
  }

}

class CreateAdminFormlet {
  function show() {
    ?>
    <form method="post" action="index.php">
       <input type="hidden" name="action" value="createadmin">
       <table>
       <tr><th>User name:<td><input type="text" name="user" value="">
       <tr><th>password:<td><input type="password" name="pass" value="">
       <tr><th> (again):<td><input type="password" name="again" value="">
       <tr><td colspan="2"><input type="submit" value=" create ">
       </table>
    </form>
    <?php
  }

  function action($params) {
    global $manager;
    if (count($manager->accounts()) > 0) {
      die("CA error 2");
    }
    $user = isset($params['user']) ? $params['user'] : "";
    $pass = isset($params['pass']) ? $params['pass'] : "";
    $again = isset($params['again']) ? $params['again'] : "";
    if ($pass == "" and $again == "") {
      redirect_to("index.php?mod=CreateAdmin",
                  "ѥɤɬϤƲ");
    }
    CreateAccountFormlet::validateInput($user, $pass, $again);
    $result = CreateAccountFormlet::tryCreate($user, $pass);
    if ($result) {
      $account = $manager->find($user);
      $account->setConfig('admin', true);
      $manager->update($account);
      redirect_to("index.php", "Ͽޤ");
    }
    else {
      redirect_to("index.php?mod=CreateAdmin", "Υ顼ΤϿǤޤǤ");
    }
  }
}

class DeleteAccoutFormlet {

  function showUserForm() {
    $name = WebSession::loginUserName();
    $encName = htmlspecialchars($name);
    ?>
    <form method="post" action="index.php">
       <input type="hidden" name="action" value="confirmdeleteaccount">
       <input type="hidden" name="user" value="<?php echo $encName ?>">
       <input type="submit" value=" delete ">
    </form>
    <?php
  }

  function showAdminForm() {
    ?>
    <form method="post" action="index.php">
       <input type="hidden" name="action" value="confirmdeleteaccount">
       <strong>User name:</strong> <input type="text" name="user" value="">
       <input type="submit" value=" delete ">
    </form>
    <?php
  }

  function confirm($param) {
    global $manager;
    $name = $param['user'];
    $deleter = WebSession::loginUserName();

    $account = $manager->find($name);
    if (!$account) {
      redirect_to("index.php?mod=Admin", "${name}Ȥ桼ϿƤޤ");
      return;
    }
    if (WebSession::isAdmin() && $name != $deleter) {
      DeleteAccoutFormlet::confirmAdmin($name);
    }
    else {
      DeleteAccoutFormlet::confirmUser($name);
    }
  }

  function confirmAdmin($name) {
    $encName = htmlspecialchars($name);
    ?>
    <html><head><title>Confirm</title>
    <meta http-equiv="Content-Type" content="text/html; charset=euc-jp">
    </head><body>
    <p>桼̾"<?php echo $encName ?>"κԤޤ˹Ԥޤ</p>
    <form method="post" action="index.php">
       <input type="hidden" name="action" value="deleteAccount">
       <input type="hidden" name="user" value="<?php echo $encName ?>">
       <input type="submit" value=" delete ">
    </form>
    [<a href="index.php?mod=Admin"></a>]
    </body></html>
    <?php
  }

  function confirmUser($name) {
    $encName = htmlspecialchars($name);
    ?>
    <html><head><title>Confirm</title>
    <meta http-equiv="Content-Type" content="text/html; charset=euc-jp">
    </head><body>
    <p>桼̾"<?php echo $name ?>"κԤޤ˹Ԥޤ</p>
    <form method="post" action="index.php">
       <input type="hidden" name="action" value="deleteAccount">
       <input type="hidden" name="user" value="<?php echo $encName ?>">
       <input type="submit" value=" delete ">
    </form>
    [<a href="index.php?mod=UserConf"></a>]
    </body></html>
    <?php
  }

  function action($param) {
    global $manager;
    $name = $param['user'];

    $account = $manager->find($name);
    if (!$account) {
      redirect_to("index.php?mod=Admin", "${name}Ȥ桼ϿƤޤ");
      return;
    }
    if ($account->isAdmin()) {
      if (sizeof($manager->admins()) < 2) {
        redirect_to("index.php?mod=Admin", "ԤͰʾ夤ʤ硢ԤǤޤ");
        return;
      }
    }
    $result = DeleteAccoutFormlet::deleteUserAccountEntry($account);
    if ($result == false) {
      redirect_to("index.php?mod=Admin", "${name}Υ桼ȤǤޤǤ");
      return;
    }
    DeleteAccoutFormlet::deleteUserDataFiles($name);

    //ʬɬȤ
    if ($name == $deleter) {
      WebSession::logout();
      redirect_to("index.php", "Ȥޤ");
      return;
    }
    assert(WebSession::isAdmin());
    redirect_to("index.php?mod=Admin", "Ȥޤ");
  }

  function deleteUserAccountEntry($account) {
    global $manager;
    $result = $manager->delete($account);
    return $result;
  }

  function deleteUserDataFiles($name) {
    //metadataǥ쥯ȥ꤫顢ڡΥ᥿ǡʳΥե򤹤٤ƺ
    $path = WikiPageStorage::metaDataDir($name);
    $d = Dir($path);
    clearstatcache();
    while (false !== ($entry = $d->read())) {
      if (DeleteAccoutFormlet::isNotPageMetaData($entry)) {
        if (is_file("$path/$entry")) {
          unlink("$path/$entry");
        }
      }
    }
    $d->close();
    return;
  }

  function isNotPageMetaData($file) {
    //YYYYMMDD-HHMMSS.txt, history.txt
    if (!preg_match("/\d{8}-\d{6}\.txt/", $file) && "history.txt" != $file) {
      return true;
    }
    else {
      return false;
    }
  }
}

class AccountListFormlet {
  function show() {
    global $manager;
    $accounts = $manager->accounts();
    echo "<ul>\n";
    foreach ($accounts as $each) {
      $link = Formatter::linkToPage($each);
      echo '<li>', $link, "\n";
    }
    echo "</ul>\n";
  }
}

class StylesheetFormlet {
  function show() {
    global $manager;
    if (!WebSession::isLogined()) {
      $theme = DEFAULT_THEME;
    }
    elseif ($account = $manager->find(WebSession::loginUserName())) {
      $theme = $account->getConfig("theme");
      if (!$theme) $theme = DEFAULT_THEME;
    }
    else {
      $theme = DEFAULT_THEME;
    }
    $theme = htmlspecialchars($theme);
    $href = "theme/${theme}/${theme}.css";
    ?>
    <link rel="stylesheet" type="text/css" href="<?php echo $href ?>" />
    <?php
  }
}

class ChangePasswordFormlet {
  function show() {
    ?>
    <form method="post" action="index.php">
       <input type="hidden" name="action" value="changePassword">
       <table>
       <tr><th>old password:<td><input type="password" name="oldPass" value=""><br>
       <tr><th>new password:<td><input type="password" name="newPass" value=""><br>
       <tr><th>(again):<td><input type="password" name="again" value=""><br>
       <tr><td colspan="2"><input type="submit" value=" change ">
       </table>
    </form>
    <?php
  }

  function action($params) {
    if (!WebSession::isLogined()) {
      die("error");
    }
    global $manager;
    $oldPass = $params['oldPass'];
    $newPass = $params['newPass'];
    $again = $params['again'];
    if ($newPass != $again) {
      die("ĤΥѥϤ԰פǤ");
    }
    $account = $manager->find(WebSession::loginUserName());
    if ($account->changePassword($oldPass, $newPass)) {
      $manager->update($account);
      WebSession::login($account, $newPass);
      redirect_to("index.php", "ѥɤѹޤ");
    }
    else {
      redirect_to("index.php?mod=ChangePassword", "ѥɤ԰פΤѹǤޤǤ");
    }
  }
}

?>
