<?php
class MemoFormlet {
  function show() {
    WebSession::isLogined() or die('not logged in');
    $userName = WebSession::loginUserName();
    $path = WikiPageStorage::metaDataDir($userName) . "/memo.txt";
    if (!file_exists($path)) touch($path);
    $text = htmlspecialchars(implode("", file($path)));
    ?>
    <form action="index.php" method="post">
      <input type="hidden" name="action" value="memosave">
       <textarea name="content" cols="60" rows="10"><?php echo $text; ?></textarea><br>
      <input type="submit" value="Save">
      <input type="reset" value="Reset">
    </form>
    <?php
  }

  function action($params) {
    WebSession::isLogined() or die('not logged in');
    $userName = WebSession::loginUserName();
    $path = WikiPageStorage::metaDataDir($userName) . "/memo.txt";
    fwrite_safe($path, Formatter::normalizeLineBreak($params["content"]));
    global $manager;
    $account = $manager->find(WebSession::loginUserName());
    $setting = $account->getConfig("formlet");
    if (is_array($setting) && isset($setting['Memo'])) {
      $url = "index.php?mod=Home#Memo";
    }
    else {
      $url = "index.php?mod=FormletLauncher&formlet=Memo#Memo";
    }
    redirect_to($url, '񤭹ߤޤ', 0);
  }
}
?>
