<?php
class QueueListFormlet {
  function show() {
    $name = WebSession::loginUserName();
    $items = Queue::items($name);
    $logs = Queue::logs($name);
    ?>
    <form method="post" action="index.php">
      <input type="hidden" name="action" value="queue">
      <input type="hidden" name="cmd" value="add">
      <input type="text" id="queueInput" name="item" size="80" value="">
      <input type="submit" name="top" value="  top  ">
      <input type="submit" name="bottom" value="bottom">
    </form>
    <table class="queue">
       <?php QueueListFormlet::printItems($items) ?>
    </table>
       <?php QueueListFormlet::printLogs($name, $logs) ?>
    <?php 
  }

  function printItems($items) {
    $i = 0;
    $formatter = new Formatter();
    foreach ($items as $item) {
      $mes = $formatter->formatSingleLine(rtrim($item));
      $td = '<td>';
      $line = QueueListFormlet::tr($i).
        $td.QueueListFormlet::sage($i).
        $td.$mes.
        $td.QueueListFormlet::age($i).
        $td.QueueListFormlet::ok($i).
        $td.QueueListFormlet::del($i);
      echo $line, "\n";
      $i++;
    }
  }

  function url($pos, $cmd, $symbol) {
    global $request;
    return sprintf('<a href="index.php?action=queue&amp;cmd=%s&amp;pos=%d"'.
		   ' class="button">%s</a>',
                   $cmd, $pos, $symbol);
  }
  function sage($pos) {
    return QueueListFormlet::url($pos, "sage", "v");
  }
  function age($pos) {
    return QueueListFormlet::url($pos, "age", "^");
  }
  function ok($pos) {
    return QueueListFormlet::url($pos, "ok", "OK");
  }
  function del($pos) {
    return QueueListFormlet::url($pos, "del", "DEL");
  }

  function tr($i) {
    if ($i % 2) return '<tr class="even">';
    else return '<tr class="odd">';
  }

  function printLogs($name, $logs) {
    if (!$logs) return;
    rsort($logs);
    $last = "";
    echo "<dl class=\"queuelog\">";
    $formatter = new Formatter();
    foreach ($logs as $log) {
      list($year, $month, $day, $hour, $min, $sec, $mes) = explode("\t", $log);
      $date = sprintf("%04d-%02d-%02d", $year, $month, $day);
      if ($date != $last)
	printf("<dt>%s</dt>", $date);
      $mes = rtrim(htmlspecialchars($mes));
      $mes = $formatter->format($mes);
      printf("<dd>%02d:%02d:%02d&nbsp;%s", $hour, $min, $sec, $mes);
      $last = $date;
    }
    echo "</dl>";
  }

  function action($params) {
    WebSession::isLogined()  or die("user name unmatch");
    $name = WebSession::loginUserName();
    $cmd = $params['cmd'];
    $pos = isset($params['pos']) ? $params['pos'] : null;
    switch ($cmd) {
    case 'add':
      QueueListFormlet::do_add($params);
      break;
    case 'age':
      if ($pos === null) die("param error");
      QueueListFormlet::do_age($name, $pos);
      break;
    case 'sage':
      if ($pos === null) die("param error");
      QueueListFormlet::do_sage($name, $pos);
      break;
    case 'ok':
      if ($pos === null) die("param error");
      QueueListFormlet::do_ok($name, $pos);
      break;
    case 'del':
      if ($pos === null) die("param error");
      QueueListFormlet::do_del($name, $pos);
      break;
    }  
  }

  function do_add($params) {
    $item = $params['item'];
    if (isset($params['name'])) {
      $pageName = $params['name'];
      $item = $item." ($pageName)";
    }
    $name = WebSession::loginUserName();
    if (isset($params['top'])) {
      Queue::pushToList($name, $item);
    }
    else {
      Queue::appendToList($name, $item);
    }
    QueueListFormlet::returnWithMessage("ƥɲäޤ");
  }

  function do_age($name, $pos) {
    $item = Queue::removeFromList($name, $pos);
    Queue::pushToList($name, $item);
    QueueListFormlet::returnWithMessage("ƥưޤ");
  }

  function do_sage($name, $pos) {
    $item = Queue::removeFromList($name, $pos);
    Queue::appendToList($name, $item);
    QueueListFormlet::returnWithMessage("ƥưޤ");
  }

  function do_ok($name, $pos) {
    $item = Queue::removeFromList($name, $pos);
    Queue::writeLog($name, $item);
    QueueListFormlet::returnWithMessage("ƥλˤޤ");
  }

  function do_del($name, $pos) {
    Queue::removeFromList($name, $pos);
    QueueListFormlet::returnWithMessage("ƥޤ");
  }

  function returnWithMessage($msg) {
    global $manager;
    $account = $manager->find(WebSession::loginUserName());
    $setting = $account->getConfig("formlet");
    if (is_array($setting) && isset($setting['QueueList']) && $setting['QueueList']) {
      $url = "index.php?mod=Home#QueueList";
    }
    else {
      $url = "index.php?mod=FormletLauncher&formlet=QueueList#QueueList";
    }
    redirect_to($url, $msg, 0);
  }

}

class QueueLogEditFormlet {
  function show() {
    $name = WebSession::loginUserName();
    $logs = Queue::logs($name);
    $last = "";
    $count = 0;
    ?>
    <h2>Queue log edit</h2>
    <form action="index.php" method="post">
      <input type="hidden" name="action" value="queuelogedit">
      <dl>
    <?php
    $counter = 0;
    foreach ($logs as $log) {
      list($year, $month, $day, $hour, $min, $sec, $mes) = explode("\t", $log);
      $date = sprintf("%04d-%02d-%02d", $year, $month, $day);
      if ($date != $last)
	printf("<dt>%s</dt>", $date);
      $mes = htmlspecialchars($mes);
      printf('<dd><input name="d[%d]" type="checkbox">'.
	     "%02d:%02d:%02d&nbsp;%s", $counter, $hour, $min, $sec, $mes);
      $last = $date;
      $counter++;
    }
    echo "</dl>";
    ?>
      </dl>
      <input type="submit" value=" Delete ">
    </form>
    <?php
  }

  function action($params) {
    if (!is_array($params["d"])) {
      redirect_to("index.php?mod=QueueLogEdit", "򤵤Ƥޤ", 1);
      exit;
    }
    $name = WebSession::loginUserName();
    $dels = array_keys($params["d"]);
    Queue::removeFromLog($name, $dels);
    redirect_to("index.php", "ޤ", 0);
  }


}
