<?php
class SearchFormlet {
  function show() {
    SearchFormlet::showInputForm("");
  }

  function showInputForm($str) {
    $escaped = htmlspecialchars($str);
    ?>
    <form action="index.php" method="post">
    <input type="hidden" name="action" value="search">
    <input type="text" size="50" name="key" value="<?php echo $escaped ?>">
    <input type="submit" value="Search">
    <input type="reset" value="Reset">
    </form>
    <?php
  }

  function action($params) {
    $key = $params["key"];
    $pages = WikiPageStorage::search($key);
    $comments = WikiCommentStorage::search($key);
    $hits = count($pages) + count($comments);
    $escaped = htmlspecialchars($key);
    global $session, $manager, $request;
    $module = 'module/SearchResult.mod.php';
    $title = "Search Result";
    include 'resources/skin.html.php';
  }
}
?>
