<?php

class FormletShowFormlet {
  function show() {
    global $manager;
    $account = $manager->find(WebSession::loginUserName());
    $setting = $account->getConfig("formlet");
    if (!is_array($setting)) {
	  $setting = FormletShowFormlet::defaultFormlets();
	  $account->setConfig("formlet", $setting);
	  $manager->update($account);
	}
    foreach (array_keys($setting) as $formlet) {
      if (isset($setting[$formlet]) &&
          file_exists("template/".$formlet.".tmpl.php"))
        include "template/".$formlet.".tmpl.php";
    }
  }

  function defaultFormlets() {
	$keys = split(",", DEFAULT_FORMLETS);
	$result = array();
    foreach ($keys as $k) {
	  $result[$k] = "on";
	}
	return $result;
  }
}

class ToolbarFormlet {
  function show() {
    global $manager;
    $account = $manager->find(WebSession::loginUserName());
    $setting = $account->getConfig("formlet");
    if (!is_array($setting))
      $selected = array();
    else
      $selected = array_keys($setting);
    $formlets = FormletEditFormlet::formletList();
    $rest = array_diff($formlets, $selected);
    echo '<p class="toolbar">';
    echo "<a href=\"index.php?mod=UserConf\">Config</a>";
    foreach ($rest as $formlet) {
      $escaped = htmlspecialchars($formlet);
      $encoded = htmlspecialchars(urlencode($formlet));
      echo " | <a href=\"index.php?mod=FormletLauncher&amp;formlet=$encoded\">", $escaped, "</a>";
    }
    echo " | <a href=\"index.php?mod=NewPage\">NewPage</a>";
    echo "</p>\n";
  }
}

class FormletLauncherFormlet {
  function show() {
    global $request;
    if (!isset($request['formlet'])) {
      echo "formlet is not specified.";
      return;
    }
    $formlet = $request['formlet'];
    WikiPageStorage::checkSlash($formlet);
    if (file_exists("template/".$request['formlet'].".tmpl.php")) {
      include "template/".$formlet.".tmpl.php";
    }
  }
}

class FormletEditFormlet {
  function show() {
    global $manager;
    $formlets = FormletEditFormlet::formletList();
    $account = $manager->find(WebSession::loginUserName());
    $setting = $account->getConfig("formlet");
      ?>
      <form action="index.php" method="post">
        <input type="hidden" name="action" value="formletedit">
        <?php foreach ($formlets as $formlet) {
          $checked = isset($setting[$formlet]) ? 'checked="checked"': '';
          $checkbox = sprintf('<input type="checkbox" name="formlet[%s]" %s>%s<br>',
                              htmlspecialchars($formlet), $checked, htmlspecialchars($formlet));
          echo $checkbox;
        } ?>
        <input type="submit" value=" Save ">
      </form>
      <?php
  }

  function action($params) {
    global $manager;
    if (!WebSession::isLogined()) {
      redirect_to("index.php", "you are not logined", 3);
    }
    $account = $manager->find(WebSession::loginUserName());
    $setting = isset($params["formlet"]) ? $params["formlet"] : array();
    $account->setConfig("formlet", $setting);
    $manager->update($account);
    redirect_to("index.php?mod=UserConf", "Config saved", 0);
  }

  function formletList() {
    return array("Calendar", "QueueList", "Memo", "WatchList", "WatchedList", "RecentList", "MyPage", "MyPageComment", "AccountList");
  }

}

class ThemeChooseFormlet {
  function show() {
    global $manager;
    $account = $manager->find(WebSession::loginUserName());
    if ($account) {
      $myTheme = $account->getConfig("theme");
      if (!$myTheme) $myTheme = DEFAULT_THEME;
    }
    else {
      $myTheme = DEFAULT_THEME;
    }
    echo '<form method="post" action="index.php">'."\n";
    echo '<input type="hidden" name="action" value="themechoose">'."\n";
    foreach (ThemeChooseFormlet::themes() as $theme) {
      $checked = ($theme == $myTheme) ? 'checked="checked"' : '';
      printf('<input type="radio" name="theme" value="%s" %s>%s<br>'."\n",
             $theme, $checked, $theme);
    }
    echo '<input type="submit" value=" Save ">'."\n";
    echo "</form>\n";
  }

  function action($params) {
    global $manager;
    $account = WebSession::loginUser();
    if (!$account) die("invalid login name");

    foreach (ThemeChooseFormlet::themes() as $theme) {
      if (isset($params['theme'])) {
        $selected = $params['theme'];
        break;
      }
    }
    $account->setConfig("theme", $selected);
    $manager->update($account);
    redirect_to("index.php?mod=UserConf", "Config saved", 0);
  }

  function themes() {
    return array("city", "flower", "light", "marble", "mono");
  }
}

?>
