<?php

class WikiEditFormlet {
  function show() {
    global $request;
    $pageName = $request['name'];
    if (!WebSession::isEditable($pageName)) {
      WikiEditFormlet::permissionError();
    }

    $text = htmlspecialchars(Formatter::normalizeLineBreak(WikiPageStorage::get($pageName)));
    $name = htmlspecialchars($pageName);
    ?>
    <form method="post" action="index.php">
      <h1>edit: <?php echo $name ?></h1>
      <input type="hidden" name="action" value="wikiedit">
      <input type="hidden" name="name" value="<?php echo $name ?>">
      <textarea name="content" cols="80" rows="25"><?php echo $text ?></textarea><br>
      edit memo: <input type="text" name="memo" size="74" value=""><br>
      ॹפ򹹿ʤ: <input type="checkbox" name="sage"><br><br>
      <input type="submit" value=" Save ">
      <input type="reset" value=" Reset ">
    </form>
    <?php
  }
  function permissionError() {
    echo "permission error";
    exit;
  }

  function action($params) {
    $pageName = $params["name"];
    if (!WebSession::isEditable($pageName)) {
      WikiEditFormlet::permissionError();
    }
    $content = $params["content"];
    $memo = $params["memo"];
    $isSage = isset($params["sage"]);
    WikiPageStorage::put($pageName, $content, $memo, $isSage);
    $url = sprintf("index.php?mod=WikiView&name=%s", htmlspecialchars(urlencode($pageName)));
    redirect_to($url, "񤭹ߤޤ", 0);
  }

}

class WikiViewFormlet {
  function show() {
    global $request;
    WikiViewFormlet::showPage($request["name"]);
  }

  function showPage($name) {
    $formatter = new Formatter();
    if (WikiPageStorage::pageExists($name)) {
      $property = Property::instance();

      $text = WikiPageStorage::get($name);
      $text = $formatter->formatWikiPage($text, $name);
      $memo = $property->get($name, 'edit_memo');
      $memo = $formatter->formatSingleLine($memo);
      $muser = $property->get($name, 'last_modified_user');
      $mtime = date("Y-m-d H:i:s",WikiPageStorage::pageMtime($name));
      $cuser = $property->get($name, 'creator');
    }
    else {
      $text = "no data";
      $memo = "";
      $muser = "";
      $mtime = "(not yet)";
      $cuser = "";
    }
    $escName = htmlspecialchars($name);
    $encName = htmlspecialchars(urlencode($name));
    ?>
    <h1><?php echo $escName ?>
    <?php if (WebSession::isUserName($name))
      echo '<span style="font-size:small;color:brown;font-weight: normal;">(^-^) user page</span>' ?>
     </h1>
     <p><?php echo $text ?></p>
     <hr>
     <div align="right">
     <p>
     <?php if ($cuser): ?>
       Created by <?php echo Formatter::linkToPage($cuser) ?><br>
     <?php endif; ?>
     <?php if (WebSession::isEditable($name)): ?>
       [ <a href="index.php?mod=WikiEdit&amp;name=<?php echo $encName ?>">Edit this page</a> ] 
     <?php endif; ?>
     [ <a href="index.php?mod=WikiHistory&amp;name=<?php echo $encName ?>">Show edit history</a> ]
     Last modified by <?php $muser ? print(Formatter::linkToPageIfUserExists($muser)) : print("unknown") ?>
       at <?php echo $mtime ?><br>
     <?php if ($memo): ?>
       Edit memo: &quot;<?php echo $memo ?>&quot;
    <?php endif; ?>
    </p>
    </div>
    <?php
  }

  function showMyPage($name) {
    if (WikiPageStorage::pageExists($name)) {
      $formatter = new Formatter();
      $property = Property::instance();

      $text = WikiPageStorage::get($name);
      $text = $formatter->formatWikiPage($text, $name);
      $memo = $property->get($name, 'edit_memo');
      $memo = $formatter->formatSingleLine($memo);
      $cuser = $property->get($name, 'creator');
    }
    else {
      $text = "no data";
      $memo = "";
      $cuser = "";
    }
    $escName = htmlspecialchars($name);
    $encName = htmlspecialchars(urlencode($name));
    ?>
      <p><?php echo $text ?></p>
      <div align="right">
      <p>
      <?php if ($cuser): ?>
        <?php endif; ?>
        <?php if ($memo): ?>
          <!-- TODO: format pagename as hyperlink -->
          Edit memo: &quot;<?php echo $memo ?>&quot;
      <?php endif; ?>
      </p>
      </div>
    <?php
  }
}

class NewPageFormlet {
  function show() {
    ?>
    <form method="post" action="index.php">
      <input type="hidden" name="action" value="wikiedit">
      ڡ̾: <input type="text" name="name" size="30" value=""><br>
      <textarea name="content" cols="80" rows="25"></textarea><br>
      edit memo: <input type="text" name="memo" size="74" value=""><br>
      <input type="submit" value=" Save ">
      <input type="reset" value=" Reset ">
    </form>
    <?php
  }
}

class RecentChangesFormlet {
  function show() {
    $last = "";
    echo "<dl>";
    foreach (WikiPageStorage::recentChanges(DEFAULT_RECENT_LIST_NUMBER) as $item) {
      list($datetime, $wikiname, $user) = $item;
      list($date, $time) = explode(" ", $datetime);
      $link = Formatter::linkToPage($wikiname);
      if ($user) {
	$user = "(by ".Formatter::linkToPageIfUserExists($user).")";
      }
      if ($date != $last) {
        printf("<dt>%s</dt>", htmlspecialchars($date));
      }
      if (WebSession::isUserName($wikiname)) {
	printf("<dd>%s - <span class=\"user\">%s</span> %s</dd>\n", $time, $link, $user);
      }
      else {
	printf("<dd>%s - %s %s</dd>\n", $time, $link, $user);
      }
      $last = $date;
    }
    echo "</dl>";
  }
}

class RecentCommentsFormlet {
  function show() {
    $last = "";
    echo "<dl>";
    foreach (WikiCommentStorage::recentComments(DEFAULT_RECENT_LIST_NUMBER) as $item) {
      list($datetime, $wikiname, $user) = $item;
      list($date, $time) = explode(" ", $datetime);
      $link = Formatter::linkToPageComment($wikiname);
      if ($user) {
	$user = "(by ".Formatter::linkToPageIfUserExists($user).")";
      }
      if ($date != $last) {
        printf("<dt>%s</dt>", htmlspecialchars($date));
      }
      if (WebSession::isUserName($wikiname)) {
	printf("<dd>%s - <span class=\"user\">%s</span> %s</dd>\n", $time, $link, $user);
      }
      else {
	printf("<dd>%s - %s %s</dd>\n", $time, $link, $user);
      }
      $last = $date;
    }
    echo "</dl>";
  }
}

class AllPagesFormlet {
  function show() {
    global $manager;
    $pages = WikiPageStorage::existsPages();
    $users = $manager->accounts();
    $all = array_unique(array_merge($pages, $users));
    sort($all);
    echo "<ol>\n";
    foreach ($all as $item) {
      if (WebSession::isUserName($item)) {
        echo "<li><span class=\"user\">", Formatter::linkToPage($item), "</span></li>\n";
      }
      else {
        echo "<li>", Formatter::linkToPage($item), "</li>\n";
      }
    }
    echo "</ol>\n";
  }
}

class WikiHistoryFormlet {
  function show() {
    global $request;
    $name = htmlspecialchars($request["name"]);
      ?>
      <h2>Edit history - <?php echo Formatter::linkToPage($name) ?></h2>
      <table class="history">
        <tr><th>date/time<th>user<th>memo<th>operation</tr>
	 <?php
	 foreach (WikiPageStorage::editHistory($name) as $each) {
	   list($date, $user, $memo, $timestamp) = $each;
	   $path = WikiPageStorage::backupFilePath($name, $timestamp);
	   if (file_exists($path)) {
	     printf("<tr><td>%s<td>%s<td>%s<td>".
		    "<a href=\"index.php?mod=WikiVersion&amp;name=%s&amp;date=%s\">".
		    "view this version</a></tr>",
		    $date, Formatter::linkToPageIfUserExists($user),
		    htmlspecialchars($memo), htmlspecialchars(urlencode($name)), $timestamp);
	   }
	 }
         ?>
      </table>
      <?php
  }
}

class WikiVersionFormlet {
  function show() {
    global $request;
    $name = strip_tags($request['name']);
    $timestamp = strip_tags($request['date']);
    WikiVersionFormlet::checkParam($name, $timestamp);
    $text = WikiPageStorage::getBackup($name, $timestamp);
    WikiVersionFormlet::showVersionPage($name, htmlspecialchars($text), $timestamp);
  }

  function checkParam($name, $timestamp) {
    check_naming_rule($name) or die("param error");
    preg_match("/\d{14}/", $timestamp) or die("param error");
    WikiPageStorage::pageExists($name) or die("param error");
  }

  function showVersionPage($name, $text, $timestamp) {
    $date = WikiVersionFormlet::formatDate($timestamp);
    $formatter = new Formatter();
    ?>
    <h2>Content of page &quot;<?php echo Formatter::linkToPage($name) ?>&quot; at <?php echo $date ?></h2>
    <?php
    echo $formatter->format($text);
  }

  function formatDate($timestamp) {
    return preg_replace("/^(....)(..)(..)(..)(..)(..)$/",
			'\1-\2-\3 \4:\5:\6',
			$timestamp);
  }

}

?>
