<?php
/*
  Copyright (C) 2004-2007 SHIMADA Keiki
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

error_reporting(E_ALL);
require_once 'resources/config.php';
require_once 'formlet/core.frm.php';
require_once 'formlet/wiki.frm.php';
require_once 'formlet/comment.frm.php';
require_once 'formlet/queue.frm.php';
require_once 'formlet/watch.frm.php';
require_once 'formlet/userconf.frm.php';
require_once 'formlet/calendar.frm.php';
require_once 'formlet/memo.frm.php';
require_once 'formlet/search.frm.php';
require_once 'formlet/admin.frm.php';
require_once 'lib/session.php';
require_once 'lib/storage.php';
require_once 'lib/account.php';
require_once 'lib/formatter.php';
require_once 'lib/rss.php';

define("VERSION", "0.6.3");
define("COPYRIGHT", "Copyright &copy; 2004-2007 SHIMADA Keiki");

$db = new HashDB("metadata/accounts.hash");
$manager = new AccountManager($db);

$pdb = new HashDB("metadata/property.hash");
$pdbReadOnly = new ReadOnlyHashDB("metadata/property.hash");

WebSession::start();
set_request();
check_no_users();

if ($method == 'GET' && isset($request['mod'])) {
  switch ($request['mod']) {
  case 'Home':
    apply_template('Home', 'Home');
    break;
  case 'Login':
    apply_template('Login', 'Login page');
    break;
  case 'Account':
    apply_template('Account', 'Account registration');
    break;
  case 'WikiEdit':
    must_be_logined();
    check_pagename($request["name"]);
    apply_template('WikiEdit', 'Edit: '.$request["name"]);
    break;
  case 'WikiView':
    if (!isset($request["name"])) show_top();
    check_pagename($request["name"]);
    apply_template('WikiView', $request["name"]);
    break;
  case 'NewPage':
    must_be_logined();
    apply_template('NewPage', "Create New Page");
    break;
  case 'WikiHistory':
    check_pagename($request["name"]);
    apply_template('WikiHistory', $request["name"]);
    break;
  case 'WikiVersion':
    check_pagename($request["name"]);
    apply_template('WikiVersion', "old version of ".$request["name"]);
    break;
  case 'QueueLogEdit':
    must_be_logined();
    apply_template('QueueLogEdit', "QueueList log edit");
    break;
  case 'AllComment':
    check_pagename($request["name"]);
    apply_template('AllComment', "All Comment of ".$request["name"]);
    break;
  case 'WatchListEdit':
    must_be_logined();
    apply_template('WatchListEdit', "Watch List Edit");
    break;
  case 'WatchList':
    must_be_logined();
    apply_template('WatchList', "Watch List");
    break;
  case 'AllPages':
    apply_template('AllPages', "All pages");
    break;
  case 'UserConf':
    must_be_logined();
    apply_template('UserConf', "User configuration");
    break;
  case 'FormletLauncher':
    must_be_logined();
    apply_template('FormletLauncher', "Formlet Launcher: ".$request['formlet']);
    break;
  case 'Calendar':
    must_be_logined();
    apply_template('Calendar', "Calendar");
    break;
  case 'ChangePassword':
    must_be_logined();
    apply_template('ChangePassword', "Calendar");
    break;
  case 'CommentEdit':
    must_be_logined();
    check_pagename($request["name"]);
    apply_template('CommentEdit', "Edit Last Comment");
    break;
  case 'Search':
    apply_template('Search', "Search");
    break;
  case 'PlanEdit':
    must_be_logined();
    apply_template('PlanEdit', "Plan Edit");
    break;
  case 'Admin':
    must_be_logined();
    must_be_admin();
    apply_template('Admin', "Admin");
    break;
  case 'AbornComment':
    must_be_logined();
    must_be_admin();
    check_pagename($request["name"]);
    apply_template('AbornComment', "Aborn Comment");
    break;
  case 'RevertComment':
    must_be_logined();
    must_be_admin();
    check_pagename($request["name"]);
    apply_template('RevertComment', "Revert Comment");
    break;
  default:
    redirect_to("index.php", "Τ褦ʥڡ¸ߤޤ");
    break;
  }
}
elseif (isset($request['action'])) {
  switch ($request['action']) {
  case 'search':
    SearchFormlet::action($request);
    break;
  case 'login':
    method_must_be_post();
    LoginFormlet::action($request);
    break;
  case 'logout':
    must_be_logined();
    WebSession::logout();
    redirect_to("index.php", "Ȥޤ");
    break;
  case 'account':
	method_must_be_post();
    CreateAccountFormlet::action($request);
    break;
  case 'wikiedit':
    must_be_logined();
    check_pagename($request["name"]);
    WikiEditFormlet::action($request);
    break;
  case 'comment':
    method_must_be_post();
    check_pagename($request["name"]);
    CommentFormlet::action($request);
    break;
  case 'queue':
    must_be_logined();
    QueueListFormlet::action($request);
    break;
  case 'queuelogedit':
    method_must_be_post();
    must_be_logined();
    QueueLogEditFormlet::action($request);
    break;
  case 'watchlistedit':
    method_must_be_post();
    must_be_logined();
    WatchListEditFormlet::action($request);
    break;
  case 'formletedit':
    method_must_be_post();
    must_be_logined();
    FormletEditFormlet::action($request);
    break;
  case 'addtowatchlist':
    method_must_be_post();
    must_be_logined();
    WatchListAddFormlet::action($request);
    break;
  case 'themechoose':
    method_must_be_post();
    must_be_logined();
    ThemechooseFormlet::action($request);
    break;
  case 'changePassword':
    method_must_be_post();
    must_be_logined();
    ChangePasswordFormlet::action($request);
    break;
  case 'lastCommentEdit':
    method_must_be_post();
    must_be_logined();
    method_must_be_post();
    CommentEditFormlet::action($request);
    break;
  case 'memosave':
    method_must_be_post();
    must_be_logined();
    MemoFormlet::action($request);
    break;
  case 'plansave':
    method_must_be_post();
    must_be_logined();
    PlanEditFormlet::action($request);
    break;
  case 'search':
    SearchFormlet::action($request);
    break;
  case 'createadmin':
    method_must_be_post();
    if (count($manager->accounts()) > 0) die("CA error 1.");
    break;
  case 'initpass':
    method_must_be_post();
    must_be_logined();
    must_be_admin();
    InitializePasswordFormlet::action($request);
    break;
  case 'confirmdeleteaccount':
    method_must_be_post();
    must_be_logined();
    DeleteAccoutFormlet::confirm($request);
    break;
  case 'deleteAccount':
    method_must_be_post();
    must_be_logined();
    DeleteAccoutFormlet::action($request);
    break;
  case 'confirmdeletepage':
    method_must_be_post();
    must_be_logined();
    must_be_admin();
    DeletePageFormlet::confirm($request);
    break;
  case 'deletepage':
    method_must_be_post();
    must_be_logined();
    must_be_admin();
    DeletePageFormlet::action($request);
    break;
  case 'aborncomment':
    method_must_be_post();
    must_be_logined();
    must_be_admin();
    AbornCommentformlet::action($request);
    break;
  case 'revertcomment':
    method_must_be_post();
    must_be_logined();
    must_be_admin();
    RevertCommentformlet::action($request);
    break;
  default:
    redirect_to("index.php", "action error");
    break;
  }
}
else {
  show_top();
}
// end of main
exit;

function apply_template($mod, $title) {
  global $session, $manager, $request;
  $module = 'module/'.$mod.'.mod.php';
  include 'resources/skin.html.php';
}


function redirect_to($url, $mes, $int = 2) {
  $encUrl = htmlspecialchars($url);
  $encMes = htmlspecialchars($mes);
  ?>
 <html>
    <head><title>SocieWiki</title>
    <meta http-equiv="Content-Type" content="text/html; charset=euc-jp">
    <meta http-equiv="Refresh" content="<?php echo $int ?>;URL=<?php echo $encUrl ?>">
    </head><body>
    <p><?php echo $encMes ?><br><a href="<?php echo $encUrl ?>">Back</a></p>
    </body></html>
    <?php
    }

function check_naming_rule($str) {
  return preg_match(NAME_PAT, $str) == 1;
}

function check_pagename($name) {
  check_naming_rule($name) or die("page name error");
}

function must_be_logined() {
  WebSession::isLogined() or die("you are not logined");
}

function must_be_admin() {
  WebSession::isAdmin() or die("you are not administrator");
}

function set_request() {
  global $request, $method;

  $method = $_SERVER['REQUEST_METHOD'];
  if ($method == 'GET') {
    $request = $_GET;
  }
  elseif ($method == 'POST') {
    $request = $_POST;
  }
  if (get_magic_quotes_gpc()) {
    $request = array_stripslashes_recursive($request);
  }
  if (!isset($request['mod']) and !isset($request['action'])) {
    show_top();
  }
}

function show_top() {
  check_no_users();
  apply_template('Home', 'Site top');
  exit;
}

function method_must_be_post() {
  global $method;

  if ($method != "POST") {
    die("method must be post.");
  }
}

function check_no_users() {
  global $manager, $request, $method;

  // proccess when attenpt to create admin user.
  if ($method == 'POST' && isset($request['action']) && $request['action'] == 'createadmin') {
    CreateAdminFormlet::action($request);
    exit;
  }
  // there is no user. admin account is required.
  elseif ((count($manager->accounts()) == 0)) {
    apply_template('CreateAdmin', 'Create Admin User');
    exit;
  }
  // normal case.
  return;
}

function array_stripslashes_recursive($var) {
  if (is_array($var))
    return array_map('array_stripslashes_recursive', $var);
  else
    return stripslashes($var);
}

?>
