<?php
class Account {
  var $name, $password, $config;

  function Account($name, $password) {
    $this->name = $name;
    $this->password = md5($password);
    $this->config = array();
  }

  function authenticate($password) {
    return $this->password == md5($password);
  }

  function changePassword($oldPassword, $newPassword) {
    if ($this->authenticate($oldPassword)) {
      $this->setPassword($newPassword);
      return true;
    }
    else {
      return false;
    }
  }
  function setPassword($password) {
    $this->password = md5($password);
  }

  function setConfig($key, $value) {
    $this->config[$key] = $value;
  }

  function getConfig($key) {
    $result = isset($this->config[$key]) ? $this->config[$key] : null;
    return $result;
  }

  function configKeys() {
    return keys($this->config);
  }

  function isAdmin() {
    return $this->getConfig("admin") == true;
  }

  function setAdmin() {
    $this->setConfig("admin", true);
  }
}

class AccountManager {
  var $db;

  function AccountManager($db) {
    $this->db = $db;
  }

  function find($name) {
    if ($this->db->exists($name)) {
      $result = $this->db->fetch($name);
    }
    else {
      $result = null;
    }
    return $result;
  }

  function exists($name) {
    $ret = $this->db->exists($name);
    return $ret;
  }

  function create($name, $password) {
    $account = new Account($name, $password);
    $result = $this->db->insert($account->name, $account);
    return $result;
  }

  function delete($account) {
    if($this->db->exists($account->name)) {
      $result = $this->db->delete($account->name);
      return $result;
    }
    return false;
  }

  function update($account) {
    $this->db->update($account->name, $account);
  }

  function accounts() {
    return $this->db->keys();
  }

  function admins() {
    $result = array();
    foreach ($this->accounts() as $member) {
      $memberAccount = $this->find($member);
      if($memberAccount->isAdmin()) {
        $result[] = $member;
      }
    }
    return $result;
  }
}


?>
