/*
 * if -- pattern match
 */

match(3 > 2){
  true:  println "foo";
  false: println "bar";
};

match("hello"){
  x: println x;    # a symbol matchs any object.
  other: println "Hummm..";
};

match("hello"){
  "test": println "not hello";
  "hello": println "match 'hello'";
  other: println "Hummm..";
};

match((2,3,4)){
  1: 1;
  "hello": 2;
  (i,j): [
    print "i: " i ", j: ";
    println j;
  ];
  (5,n,m): 3;
  (x,y,z): [
    print "tuple: " x "," y ",";
    println z;
    print "n: " n ", m: ";
    println m;
  ];
};

match([3,4,5]){
  1: println 1;
  "hello": println "hello";
  [i,j]: println 2;
  [m,8,n]: println "not match list";
  [x,y,z]: [
    print "list: " x "," y ",";
    println z;
    print "n: " n ", m: ";
    println m;
  ];
};

match([5,6,7]){
  1: println 1;
  "test": println 2;
  [m,n]: println 3;
  x::xs: [
    print "x::xs => " x "::";
    println xs;
    print "n: " n ", m: ";
    println m;
  ];
  other: println "fail";
};

match([2..6]){
  1: println 1;
  "test": println 2;
  [m,n]: println 3;
  [m,n] @ [i,j]: println 4;
  [x,y] @ [i,j,k]: [
    print "list@list: " x "," y "," i "," j ",";
    println k;
    print "n: " n ", m: ";
    println m;
  ];
  other: println "fail";
};


fun f(x:int){
  do: match(x > 10){
        true:  [print x; println " is large"];
        false: [print x; println " is small"];
      };
};

f 2;
f 12;
