<?php
function smarty_function_radio($params, &$smarty) {
	global $G_tpl_params;
	$view = $G_tpl_params['view'];
	
	$name = $params['name'];
	$label = $params['label'];
	$style = $params['style'];
	if (empty($label)) {
		$label = '&nbsp;';
	}
	
	switch($view) {
		case 'spec':
		$params['type'] = 'radio';
		$G_tpl_params['spec'][] = $params;
		return;
		
		case 'blank':
		return $style === 'circle' ? $label : "□ $label";
		
		case 'print':
		$value = $_POST[$name];
		if ($value === $params['value']) {
			return $style === 'circle'
				? "<span style='display: inline-block;'><div style='font-weight: bold; height: 0; text-align: center;'>○</div>$label</span>"
				: "<span style='margin-right: -.75em;'>□</span>&#x2713; $label";
		}
		return $style === 'circle' ? $label : "□ $label";
		
		case 'web':
		if ($_POST['view'] === 'print') {
			$value = $_POST[$name];
			$checked = ($value === $params['value']);
		}
		else {
			$checked = isset($params['checked']) ? $params['checked'] : FALSE;
		}
		if ($checked) {
			$checked = 'checked="checked" ';
		}
		else {
			$checked = '';
		}
		$value = $params['value'];
		$item = '<label><input type="radio"
			name="'.htmlspecialchars($name).'"
			'.$checked.'value="'.htmlspecialchars($value).'">'.$label.'</label>';
		$invalids = $G_tpl_params['invalids'];
		if (isset($invalids[$name])) {
			$item = '<span class="invalid">'.$item.'</span>';
		}
		return $item;
	}
}
?>
