<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}

if (!defined('_SB_DIRNAME')) {
    define('_SB_DIRNAME', basename(dirname(dirname(__FILE__))));
}
require_once XOOPS_MODULE_PATH . "/" . _SB_DIRNAME . '/inc/inc.php';
require_once _SB_MODULE_PATH . 'inc/util.php';
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * ǿ̰֥å饹
 *
 */
class scorebook_ViewLastGameBlock extends Legacy_BlockProcedure {
    var $options = array();

    /**
     * 󥹥ȥ饯
     *
     * @param object $block
     * @return scorebook_ViewLastGameBlock
     */
    function scorebook_ViewLastGameBlock(&$block) {

        parent::Legacy_BlockProcedure($block);
        $this->options = explode('|', $this->_mBlock->get('options'));

        if (empty($this->options[0])) {
            $this->options[0] = '3';
        }
    }

    /**
     * ֥åɽ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $root->mLanguageManager->loadBlockMessageCatalog($this->_mBlock->get('dirname'));
        
        $game =& new Game();
        $game->setLimit($this->options[0]);
        $gameResultList = $game->getLastGame();
        foreach ($gameResultList as $key => $gameResult) {
            setGameScore($gameResult);
            $list[] = $gameResult;
        }

        $render =& $this->getRenderTarget();
        $render->setTemplateName($this->_mBlock->get('template'));
        $render->setAttribute('mid', $this->_mBlock->get('mid'));
        $render->setAttribute('bid', $this->_mBlock->get('bid'));
        $render->setAttribute('gameList', $list);
        $render->setAttribute('_TEXT_GAME_NAME', _MB_SB_TEXT_GAME_NAME);
        $render->setAttribute('_TEXT_GAME_DATE', _MB_SB_TEXT_GAME_DATE);
        $render->setAttribute('sb_url', _SB_MODULE_URL);
        $render->setAttribute('newest', "<IMG SRC='"._SB_MODULE_URL."images/newest.gif'>");
        $render->setAttribute('new', "<IMG SRC='"._SB_MODULE_URL."images/new.gif'>");
        $renderSystem =& $root->getRenderSystem($this->getRenderSystemName());
        $renderSystem->renderBlock($render);
    }

    /**
     * ֥åԽ᥽å
     *
     * @return unknown
     */
    function getOptionForm() {
        $options = explode('|', $this->_mBlock->get('options'));
        $options[0] = (int) $options[0];
        $mydirname = $this->_mBlock->get('dirname');

        if (preg_match('/[^0-9a-zA-Z_-]/', $mydirname)) {
            die('Invalid dirname');
        }
        $root =& XCube_Root::getSingleton();
        $root->mLanguageManager->loadBlockMessageCatalog($mydirname);

        $form = '<table>';
        $form .= sprintf(
            '<tr><td>%s:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
            _MB_SB_TEXT_LAST_GAME_LIMIT, intval($options[0]));
        $form .= '</table>';
        return $form;
    }

}
?>