<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * 饹
 *
 * @since 0.0.4
 * @author saitoh-y
 */
class deleteTeamAction extends ActionAbstract {

    /**
     * ॳ
     *
     * @access private
     * @var Integer
     */
    private $teamCd = 0;

    /**
     * μ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $acl =& new Acl();
        $team =& new Team();

        /* ͼ */
        $teamCd = $root->mContext->mRequest->getRequest('team_cd');
        $this->teamCd = $root->mContext->mRequest->getRequest('team_cd');

        /* 桼å */
        $acl->setTeamCd($teamCd);
        if (!$acl->isEditTeam()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NOACCSESS;
            return;
        }

        /* ͥå */
        $team->setTeamCd($teamCd);
        $detailTeam = $team->getTeam();
        $validate =& new validateDeleteTeamFormAction();
        $validate->prepare();
        $validate->fetch();
        $validate->validate();
        if ($validate->hasError() || empty($detailTeam)) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_BADDATA;
            return;
        }

        /* 򥻥å */
        $team->setDataList($teamCd, 'team_cd', _SB_MODULE_DB_SET_INTEGER, true);

        /*  */
        if (!$team->delete()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_FAILE_DELETE;
        }
        else {
            /* ¾ơ֥Υ쥳ɤ */
            $player =& new Player();
            $game =& new Game();
            $teamResult =& new TeamResult();
            $playerResultHitter =& new PlayerResultHitter();
            $playerResultPitcher =& new PlayerResultPitcher();
            $access =& new Access();

            /* Խ¤κ */
            $access->setDataList($teamCd, 'team_cd', _SB_MODULE_DB_SET_INTEGER, true);
            $access->delete();
            $access->destroyDataList();

            /* κ */
            $game->setTeamCd($teamCd);
            $gameCount = $game->getGameCount();
            if (!empty($gameCount)) {
                $game->setDataList($teamCd, 'top_team_cd', _SB_MODULE_DB_SET_INTEGER, true);
                $game->delete();
                $game->destroyDataList();
                $game->setDataList($teamCd, 'bottom_team_cd', _SB_MODULE_DB_SET_INTEGER, true);
                $game->delete();
                $game->destroyDataList();
            }

            /* ̥ޥåפκ */
            $teamResult->setTeamCd($teamCd);
            $detailTeamResult = $teamResult->getTeamResult();
            if (!empty($detailTeamResult)) {
                $teamResult->setDataList($teamCd, 'team_cd', _SB_MODULE_DB_SET_INTEGER, true);
                $teamResult->delete();
                $teamResult->destroyDataList();
            }

            /* μ */
            $player->setTeamCd($teamCd);
            $playerList = $player->getPlayerList();

            foreach ($playerList as $playerItem) {
                /* κ */
                $player->setDataList($playerItem['player_cd'], 'player_cd',
                    _SB_MODULE_DB_SET_INTEGER, true);
                $player->delete();
                $player->destroyDataList();

                /* (Ǽ)κ */
                $playerResultHitter->setDataList($playerItem['player_cd'], 'player_cd',
                    _SB_MODULE_DB_SET_INTEGER, true);
                $playerResultHitter->delete();
                $playerResultHitter->destroyDataList();

                /* ()κ */
                $playerResultPitcher->setDataList($playerItem['player_cd'], 'player_cd',
                    _SB_MODULE_DB_SET_INTEGER, true);
                $playerResultPitcher->delete();
                $playerResultPitcher->destroyDataList();
            }
        }
    }

    /**
     * ȥåץڡ̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $root->mController->executeRedirect(_SB_MODULE_URL . "admin/index.php",
            _SB_MODULE_REDIRECT_TIME, _MD_SB_SUCCESS_DELETE);
    }
}
?>