<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * ɽ饹
 *
 * @since 0.0.4
 * @author saitoh-y
 */
class detailTeamAction extends ActionAbstract {

    /**
     * 
     *
     * @access private
     * @var Array
     */
    private $detailTeam = array();

    /**
     * (Ǽ)ꥹ
     *
     * @access private
     * @var Array
     */
    private $detailHitter = array();

    /**
     * ()ꥹ
     *
     * @access private
     * @var Array
     */
    private $detailPitcher = array();

    /**
     * ꥹ
     *
     * @access private
     * @var Array
     */
    private $playerList = array();

    /**
     * ǯȤλ̥ꥹ
     *
     * @access private
     * @var
     */
    private $teamResultYearList = array();

    /**
     * (Ǽ)¸ߥե饰
     *
     * @access private
     * @var boolean
     */
    private $hitterFg = true;

    /**
     * ()¸ߥե饰
     *
     * @access private
     * @var boolean
     */
    private $pitcherFg = true;

    /**
     * ÿɽե饰
     *
     * @access private
     * @var Integer
     */
    private $showHelpFg = 0;

    /**
     * OBɽե饰
     *
     * @access private
     * @var Integer
     */
    private $showObFg = 0;

    /**
     * ɽμ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();

        /* ͼ */
        $teamCd = $root->mContext->mRequest->getRequest('team_cd');

        /* 󥹥󥹤 */
        $team =& new Team();
        $player =& new Player();
        $game =& new Game();
        $teamResult =& new TeamResult();
        $playerResultHitter =& new PlayerResultHitter();
        $playerResultPitcher =& new PlayerResultPitcher();

        /* μ */
        $team->setTeamCd($teamCd);
        $this->detailTeam = $team->getTeam();

        /* ¸ߥå */
        if (empty($this->detailTeam)) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NODATA;
            return;
        }

        /* ̥ꥹȤ */
        $teamResultYearList = array();
        $teamResult->setTeamCd($teamCd);
        $teamResultYearList = $teamResult->getTeamResultYearList();
        if (!empty($teamResultYearList)) {
            /* ऴȤ˥ꥹȤʬ */
            $listByTeam = array_set($teamResultYearList, 'team_cd');
            foreach ($listByTeam as $key => $teamResultList) {
                /* ǯ٤Ȥ˥ꥹȤʬ */
                foreach ($teamResultList as $teamResult) {
                    /* ׻ */
                    setGameScore($teamResult);
                    /* CSS */
                    setDesign($teamResult);
                    $list[$key][substr($teamResult['game_date'], 0, 4)][] = $teamResult;
                }
            }
            $this->teamResultYearList = $list;
        }

        /* μ */
        $player->setTeamCd($teamCd);
        $this->playerList = $player->getPlayerList();

        /* ǼӤμ */
        $playerResultHitter->setTeamCd($teamCd);
        $detailHitter = $playerResultHitter->getPlayerResultHitterTeamList();
        $detailHitterTotal = $playerResultHitter->getPlayerResultHitterTeamList(true);
        if (!empty($detailHitter)) {
            $this->detailHitter = array_merge($detailHitter, $detailHitterTotal);
        }
        else {
            $this->hitterFg = false;
        }

        /* Ӥμ */
        $playerResultPitcher->setTeamCd($teamCd);
        $detailPitcher = $playerResultPitcher->getPlayerResultPitcherTeamList();
        if (!empty($detailPitcher)) {
            /* ǯñ̤Ӥ򥻥å */
            $this->setResultYearPitcher($detailPitcher);
            /* ̻Ӥ򥻥å */
            $this->setResultYearPitcher($detailPitcher, true);
        }
        else {
            $this->pitcherFg = false;
        }

        /* μ */
        $this->detailHitter = array_set_key($this->detailHitter, 'year');
        $game->setTeamCd($teamCd);
        if (!empty($this->detailHitter)) {
            $yearList = array_keys($this->detailHitter);
            foreach ($yearList as $year) {
                if ($year != _MD_SB_TEXT_TOTAL) {
                    if (!empty($this->detailPitcher[$year])) {
                        $gameCount = $game->getGameCount($year);
                        $this->detailHitter[$year]['game_count'] = $gameCount;
                        $this->detailPitcher[$year]['game_count'] = $gameCount;
                    }
                }
                else {
                    $gameCount = $game->getGameCount();
                    $this->detailHitter[$year]['game_count'] = $gameCount;
                    $this->detailPitcher[$year]['game_count'] = $gameCount;
                }
            }
        }

    }

    /**
     * ܺٲ̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $render =& $root->mContext->mModule->getRenderTarget();
        $acl =& new Acl();

        $render->setTemplateName('sb_detail_team.html');
        $render->setAttribute('detailTeam', $this->detailTeam);
        $render->setAttribute('detailHitter', $this->detailHitter);
        $render->setAttribute('detailPitcher', $this->detailPitcher);
        $render->setAttribute('playerList', $this->playerList);
        $render->setAttribute('list', $this->teamResultYearList);
        $render->setAttribute('hitterFg', $this->hitterFg);
        $render->setAttribute('pitcherFg', $this->pitcherFg);
        $render->setAttribute('title', _MD_SB_TITLE_DETAIL_TEAM);
        $acl->setTeamCd($this->detailTeam['team_cd']);
        $render->setAttribute('editTeam', $acl->isEditTeam());
        $render->setAttribute('editPlayer', $acl->isEditPlayer());
    }

    /**
     * ǯñ̤Ӥ򥻥åȤ
     *
     * @param Array $detailPitcher ӥꥹ
     * @param boolean $totalFg ̻Ӥ뤫Υե饰
     */
    function setResultYearPitcher($detailPitcher, $totalFg = false) {
        foreach ($detailPitcher as $result) {
            if ($totalFg) {
                $year = _MD_SB_TEXT_TOTAL;
            }
            else {
                $year = $result['year'];
            }
            if ($result['result_cd'] == 1) {
                @$this->detailPitcher[$year]['win'] = @$this->detailPitcher[$year]['win'] + 1;
            }
            elseif ($result['result_cd'] == 2) {
                @$this->detailPitcher[$year]['lose'] = @$this->detailPitcher[$year]['lose'] + 1;
            }
            elseif ($result['result_cd'] == 3) {
                @$this->detailPitcher[$year]['SV'] = @$this->detailPitcher[$year]['SV'] + 1;
            }
            elseif ($result['result_cd'] == 4) {
                @$this->detailPitcher[$year]['HLD'] = @$this->detailPitcher[$year]['HLD'] + 1;
            }
            @$this->detailPitcher[$year]['IP'] = @$this->detailPitcher[$year]['IP'] + $result['IP'];
            @$this->detailPitcher[$year]['NP'] = @$this->detailPitcher[$year]['NP'] + $result['NP'];
            @$this->detailPitcher[$year]['BF'] = @$this->detailPitcher[$year]['BF'] + $result['BF'];
            @$this->detailPitcher[$year]['OBA'] = @$this->detailPitcher[$year]['OBA'] + $result[
                'OBA'];
            @$this->detailPitcher[$year]['HR'] = @$this->detailPitcher[$year]['HR'] + $result['HR'];
            @$this->detailPitcher[$year]['K'] = @$this->detailPitcher[$year]['K'] + $result['K'];
            @$this->detailPitcher[$year]['BB'] = @$this->detailPitcher[$year]['BB'] + $result['BB'];
            @$this->detailPitcher[$year]['HBP'] = @$this->detailPitcher[$year]['HBP'] + $result[
                'HBP'];
            @$this->detailPitcher[$year]['WP'] = @$this->detailPitcher[$year]['WP'] + $result['WP'];
            @$this->detailPitcher[$year]['R'] = @$this->detailPitcher[$year]['R'] + $result['R'];
            @$this->detailPitcher[$year]['ER'] = @$this->detailPitcher[$year]['ER'] + $result['ER'];
        }
        foreach ($this->detailPitcher as $year => $result) {
            if ($totalFg) {
                if ($year == _MD_SB_TEXT_TOTAL) {
                    $IPList = setOut2Ining($result);
                    $this->detailPitcher[$year]['IP'] = $IPList['IP'];
                    $this->detailPitcher[$year]['IP_out'] = $IPList['IP_out'];
                    $this->detailPitcher[$year]['WAVG'] = calcWAVG($result);
                    $this->detailPitcher[$year]['ERA'] = calcERA($this->detailPitcher[$year]);
                    break;
                }
            }
            else {
                $IPList = setOut2Ining($result);
                $this->detailPitcher[$year]['IP'] = $IPList['IP'];
                $this->detailPitcher[$year]['IP_out'] = $IPList['IP_out'];
                $this->detailPitcher[$year]['WAVG'] = calcWAVG($result);
                $this->detailPitcher[$year]['ERA'] = calcERA($this->detailPitcher[$year]);
            }
        }
    }
}
?>