<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * (Ǽ)Խɽ饹
 *
 * @since 0.0.4
 * @author saitoh-y
 */
class editPlayerResultHitterAction extends ActionAbstract {

    /**
     * (Ǽ)ꥹ
     *
     * @access private
     * @var Array
     */
    private $playerResultHitterList = array();

    /**
     * ꥹ
     *
     * @access private
     * @var Array
     */
    private $playerList = array();

    /**
     * 
     *
     * @access private
     * @var Array
     */
    private $detailTeam = array();

    /**
     * 
     *
     * @access private
     * @var Array
     */
    private $detailGame = array();

    /**
     * 蹶ե饰
     *
     * @access private
     * @var boolean
     */
    private $topFg = false;

    /**
     * 9·äƤʤե饰
     *
     * @access private
     * @var boolean
     */
    private $notNineFg = false;

    /**
     * (Ǽ)Խɽμ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $acl =& new Acl();

        /* ͼ */
        $gameCd = $root->mContext->mRequest->getRequest('game_cd');
        $teamCd = $root->mContext->mRequest->getRequest('team_cd');
        $topFg = $root->mContext->mRequest->getRequest('top_fg');

        /* 桼å */
        $acl->setTeamCd($teamCd);
        if (!$acl->isEditTeam() && !$acl->isEditGame()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NOACCSESS;
            return;
        }

        /* 祳&ॳɥå */
        if (empty($gameCd) || empty($teamCd)) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_BADDATA;
            return;
        }

        /* 󥹥 */
        $playerResultHitter =& new PlayerResultHitter();
        $team =& new Team();
        $game =& new Game();
        $player =& new Player();

        /* (Ǽ)ꥹȼ */
        $playerResultHitter->setGameCd($gameCd);
        $playerResultHitter->setTopFg($topFg);
        $this->playerResultHitterList = $playerResultHitter->getPlayerResultHitterList();
        /* 9ͤʤ϶ɲ */
        if (count($this->playerResultHitterList) < 9) {
            $this->notNineFg = true;
            setPlayerResultHitterList($this->playerResultHitterList);
        }
        $this->topFg = $topFg;

        /*  */
        $team->setTeamCd($teamCd);
        $this->detailTeam = $team->getTeam();

        /*  */
        $player->setTeamCd($teamCd);
        $this->playerList = $player->getPlayerList();

        /*  */
        $game->setGameCd($gameCd);
        $gameResult = $game->getGame();
        setGameScore($gameResult);
        $this->detailGame = $gameResult;
        for ($i = 1; $i <= _SB_MODULE_MAXINING; $i++) {
            $this->detailGame['topList'][$i] = @$gameResult['top_' . $i];
            $this->detailGame['bottomList'][$i] = @$gameResult['bottom_' . $i];
        }
    }

    /**
     * (Ǽ)Խ̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $render =& $root->mContext->mModule->getRenderTarget();
        $actionForm =& new validateRegiPlayerResultHitterFormAction();

        $render->setTemplateName('sb_edit_player_result_hitter.html');
        $render->setAttribute('action', 'regiPlayerResultHitter');
        $render->setAttribute('playerResultHitterList', $this->playerResultHitterList);
        $render->setAttribute('playerList', $this->playerList);
        $render->setAttribute('detailTeam', $this->detailTeam);
        $render->setAttribute('detailGame', $this->detailGame);
        $render->setAttribute('topFg', $this->topFg);
        $render->setAttribute('notNineFg', $this->notNineFg);
        $render->setAttribute('unbrokenFg', 0);
        $render->setAttribute('actionForm', $actionForm);
        $render->setAttribute('title', _MD_SB_TITLE_EDIT_PLAYER_RESULT_HITTER);
    }
}
?>