<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * 󹹿饹
 *
 * @since 0.0.4
 * @author saitoh-y
 */
class insertGameAction extends ActionAbstract {

    /**
     * 祳
     *
     * @access private
     * @var Integer
     */
    private $gameCd = 0;

    /**
     * 
     *
     * @access private
     * @var Array
     */
    private $detailGame = array();

    /**
     * ꥹ
     *
     * @access private
     * @var Array
     */
    private $teamList = array();

    /**
     * ƥꥹ
     *
     * @access private
     * @var Array
     */
    private $categoryList = array();

    /**
     * ɲäμ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $acl =& new Acl();

        /* ͼ */
        $gameName = $root->mContext->mRequest->getRequest('game_name');
        $gameDate = $root->mContext->mRequest->getRequest('game_date');
        $gameSite = $root->mContext->mRequest->getRequest('game_site');
        $topTeamCd = $root->mContext->mRequest->getRequest('top_team_cd');
        $bottomTeamCd = $root->mContext->mRequest->getRequest('bottom_team_cd');
        $topTeamName = $root->mContext->mRequest->getRequest('top_team_name');
        $bottomTeamName = $root->mContext->mRequest->getRequest('bottom_team_name');
        $topTeamCheck = $root->mContext->mRequest->getRequest('top_team_select_check');
        $bottomTeamCheck = $root->mContext->mRequest->getRequest('bottom_team_select_check');
        $gameContent = $root->mContext->mRequest->getRequest('game_content');
        $categoryCd = $root->mContext->mRequest->getRequest('category_cd');

        /* 桼å */
        if (!$acl->isAddGame()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NOACCSESS;
            return;
        }

        /* 蹶并̾϶ˤʤ礬ΤǺ */
        $team =& new Team();
        $this->teamList = $team->getAllList();
        $teamList = array_set_key($this->teamList, 'team_cd');
        if (!empty($topTeamCd)) {
            $topTeamName = (empty($topTeamName)) ? $teamList[$topTeamCd]['team_name'] : $topTeamName;
        }
        if (!empty($bottomTeamCd)) {
            $bottomTeamName = (empty($bottomTeamName)) ? $teamList[$bottomTeamCd]['team_name'] :
                $bottomTeamName;
        }

        /* ˥󥰤ĹΤǥ롼 */
        $topResultList = array();
        $bottomResultList = array();
        for ($ining = 1; $ining <= _SB_MODULE_MAXINING; $ining++) {
            $topResultList[$ining] = $root->mContext->mRequest->getRequest('top_' . $ining);
            $bottomResultList[$ining] = $root->mContext->mRequest->getRequest('bottom_' . $ining);
        }

        /* ͥå */
        $validate =& new validateInsertGameFormAction();
        $validate->prepare();
        $validate->fetch();
        $validate->validate();
        if ($validate->hasError()) {
            /* ͺ */
            $this->detailGame['game_name'] = $gameName;
            $this->detailGame['game_date'] = $gameDate;
            $this->detailGame['game_site'] = $gameSite;
            $this->detailGame['top_team_cd'] = $topTeamCd;
            $this->detailGame['bottom_team_cd'] = $bottomTeamCd;
            $this->detailGame['top_team_name'] = $topTeamName;
            $this->detailGame['bottom_team_name'] = $bottomTeamName;
            $this->detailGame['top_team_select_check'] = $topTeamCheck;
            $this->detailGame['bottom_team_select_check'] = $bottomTeamCheck;
            $this->detailGame['game_content'] = $gameContent;
            $topScore = 0;
            $bottomScore = 0;
            for ($ining = 1; $ining <= _SB_MODULE_MAXINING; $ining++) {
                $this->detailGame['top_' . $ining] = $topResultList[$ining];
                $topScore = $topResultList[$ining] + $topScore;
                $this->detailGame['bottom_' . $ining] = $bottomResultList[$ining];
                $bottomScore = $bottomResultList[$ining] + $bottomScore;
                $this->detailGame['topList'][$ining] = $topResultList[$ining];
                $this->detailGame['bottomList'][$ining] = $bottomResultList[$ining];
            }

            $this->detailGame['top_score'] = $topScore;
            $this->detailGame['bottom_score'] = $bottomScore;
            $this->detailGame['category_cd'] = $categoryCd;
            $category =& new Category();
            $this->categoryList = $category->getListWithoutDelfg();

            $this->actionForm = $validate;
            $this->errFg = true;
            return;
        }

        /* 󥹥󥹤 */
        $game =& new Game();

        /* 򥻥å */
        $game->setDataList($gameName, 'game_name', _SB_MODULE_DB_SET_STRING);
        $game->setDataList($gameDate, 'game_date', _SB_MODULE_DB_SET_DATE);
        $game->setDataList($gameSite, 'game_site', _SB_MODULE_DB_SET_STRING);
        $game->setDataList($topTeamCd, 'top_team_cd', _SB_MODULE_DB_SET_INTEGER);
        $game->setDataList($bottomTeamCd, 'bottom_team_cd', _SB_MODULE_DB_SET_INTEGER);
        $game->setDataList($topTeamName, 'top_team_name', _SB_MODULE_DB_SET_STRING);
        $game->setDataList($bottomTeamName, 'bottom_team_name', _SB_MODULE_DB_SET_STRING);
        $game->setDataList($gameContent, 'game_content', _SB_MODULE_DB_SET_STRING);
        for ($ining = 1; $ining <= _SB_MODULE_MAXINING; $ining++) {
            $game->setDataList($topResultList[$ining], 'top_' . $ining, _SB_MODULE_DB_SET_STRING);
            $game->setDataList($bottomResultList[$ining], 'bottom_' . $ining,
                _SB_MODULE_DB_SET_STRING);
        }
        $game->setDataList($categoryCd, 'category_cd', _SB_MODULE_DB_SET_INTEGER);

        /* 󹹿 */
        if (!$game->insert()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_FAILE_INSERT;
        }
        else {
            /* ӥޥåɲ */
            if (!empty($topTeamCd) || !empty($bottomTeamCd)) {
                $teamResult =& new TeamResult();
                $teamResult->destroyDataList();
                $game_cd = $game->getMaxValue('game_cd');
                $teamResult->setDataList($game_cd, 'game_cd', _SB_MODULE_DB_SET_INTEGER);
                if (!empty($topTeamCd)) {
                    $teamResult->setDataList($topTeamCd, 'team_cd', _SB_MODULE_DB_SET_INTEGER);
                    $teamResult->insert();
                }
                if (!empty($bottomTeamCd) && $bottomTeamCd != $topTeamCd) {
                    $teamResult->setDataList($bottomTeamCd, 'team_cd', _SB_MODULE_DB_SET_INTEGER);
                    $teamResult->insert();
                }
            }

            $this->gameCd = $game->getMaxValue('game_cd');
        }
    }

    /**
     * ܺٲ̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $root->mController->executeRedirect(_SB_MODULE_URL . "index.php?action=detailGame&game_cd="
            . $this->gameCd, _SB_MODULE_REDIRECT_TIME, _MD_SB_SUCCESS_INSERT);
    }

    /**
     * ͥ顼ɽ
     *
     */
    function errorView() {
        $root =& XCube_Root::getSingleton();
        $render =& $root->mContext->mModule->getRenderTarget();

        $render->setTemplateName('sb_edit_game.html');
        $render->setAttribute('action', 'insertGame');
        $render->setAttribute('detailGame', $this->detailGame);
        $render->setAttribute('teamList', $this->teamList);
        $render->setAttribute('categoryList', $this->categoryList);
        $render->setAttribute('title', _MD_SB_TITLE_MAKE_TEAM);
        $render->setAttribute('actionForm', $this->actionForm);
        define('XOOPS_FOOTER_INCLUDED', 1);
    }
}
?>