<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * (Ǽ)(Ͽ/)饹
 *
 * @since 0.0.4
 * @author saitoh-y
 */
class regiPlayerResultHitterAction extends ActionAbstract  {

    /**
     * 祳
     *
     * @access private
     * @var Integer
     */
    private $gameCd = 0;

    /**
     * 蹶ե饰
     *
     * @access private
     * @var Array
     */
    private $topFg = false;

    /**
     * ǯ
     *
     * @access private
     * @var Integer
     */
    private $year = 0;

    /**
     * (Ǽ)ꥹ
     *
     * @access private
     * @var Array
     */
    private $playerResultHitterList = array();

    /**
     * ॳ
     *
     * @access
     * @var Integer
     */
    private $teamCd = 0;

    /**
     * ꥹ
     *
     * @access private
     * @var Array
     */
    private $playerList = array();

    /**
     * 
     *
     * @access private
     * @var Array
     */
    private $detailTeam = array();

    /**
     * 
     *
     * @access private
     * @var Array
     */
    private $detailGame = array();

    /**
     * Хǡȥե饰
     *
     * @access private
     * @var boolean
     */
    private $validateFg = false;

    /**
     * Ϣ³Ͽե饰
     *
     * @access private
     * @var boolean
     */
    private $unbrokenFg = false;

    /**
     * ӹμ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $acl =& new Acl();

        /* ͼ */
        $this->gameCd = $root->mContext->mRequest->getRequest('game_cd');
        $this->teamCd = $root->mContext->mRequest->getRequest('team_cd');
        $this->topFg = $root->mContext->mRequest->getRequest('top_fg');
        $playerCdList = explode(",", $root->mContext->mRequest->getRequest('player_cd'));
        $battingOrderList = $root->mContext->mRequest->getRequest('batting_order');
        $gamePositionList = $root->mContext->mRequest->getRequest('game_position');
        $atbatsList = $root->mContext->mRequest->getRequest('atbats');
        $atbatList = $root->mContext->mRequest->getRequest('atbat');
        $hitsList = $root->mContext->mRequest->getRequest('hits');
        $twoBaseList = $root->mContext->mRequest->getRequest('two_base');
        $threeBaseList = $root->mContext->mRequest->getRequest('three_base');
        $HRList = $root->mContext->mRequest->getRequest('HR');
        $BBList = $root->mContext->mRequest->getRequest('BB');
        $HBPList = $root->mContext->mRequest->getRequest('HBP');
        $EList = $root->mContext->mRequest->getRequest('E');
        $sacrificeList = $root->mContext->mRequest->getRequest('sacrifice');
        $RBIList = $root->mContext->mRequest->getRequest('RBI');
        $RList = $root->mContext->mRequest->getRequest('R');
        $SBList = $root->mContext->mRequest->getRequest('SB');
        $KList = $root->mContext->mRequest->getRequest('K');
        $selfEList = $root->mContext->mRequest->getRequest('self_E');
        $this->unbrokenFg = $root->mContext->mRequest->getRequest('unbrokenFg');

        /* 桼å */
        $acl->setTeamCd($this->teamCd);
        if (!$acl->isEditTeam()&&!$acl->isEditGame()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NOACCSESS;
            return;
        }

        for ($i = 0; $i <= count($playerCdList); $i++) {
            if (!empty($battingOrderList[$i])) {
                $this->playerResultHitterList[$i]['player_cd'] = $playerCdList[$i];
                $this->playerResultHitterList[$i]['batting_order'] = $battingOrderList[$i];
                $this->playerResultHitterList[$i]['game_position'] = $gamePositionList[$i];
                $this->playerResultHitterList[$i]['atbats'] = $atbatsList[$i];
                $this->playerResultHitterList[$i]['atbat'] = $atbatList[$i];
                $this->playerResultHitterList[$i]['hits'] = $hitsList[$i];
                $this->playerResultHitterList[$i]['two_base'] = $twoBaseList[$i];
                $this->playerResultHitterList[$i]['three_base'] = $threeBaseList[$i];
                $this->playerResultHitterList[$i]['HR'] = $HRList[$i];
                $this->playerResultHitterList[$i]['BB'] = $BBList[$i];
                $this->playerResultHitterList[$i]['HBP'] = $HBPList[$i];
                $this->playerResultHitterList[$i]['E'] = $EList[$i];
                $this->playerResultHitterList[$i]['sacrifice'] = $sacrificeList[$i];
                $this->playerResultHitterList[$i]['RBI'] = $RBIList[$i];
                $this->playerResultHitterList[$i]['R'] = $RList[$i];
                $this->playerResultHitterList[$i]['SB'] = $SBList[$i];
                $this->playerResultHitterList[$i]['K'] = $KList[$i];
                $this->playerResultHitterList[$i]['self_E'] = $selfEList[$i];
            }
        }

        /* ͥå */
        $validate =& new validateRegiPlayerResultHitterFormAction();
        $validate->prepare();
        $validate->fetch();
        $validate->validate();
        if ($validate->hasError()) {
            /* ͺ */
            /* 9ͤʤ϶ɲ */
            if (count($this->playerResultHitterList) < 9) {
                $this->notNineFg = true;
                setPlayerResultHitterList($this->playerResultHitterList);
            }
            $this->actionForm = $validate;
            $this->validateFg = true;

            /* 󥹥 */
            $team =& new Team();
            $game =& new Game();
            $player =& new Player();

            /*  */
            $team->setTeamCd($this->teamCd);
            $this->detailTeam = $team->getTeam();

            /*  */
            $player->setTeamCd($this->teamCd);
            $this->playerList = $player->getPlayerList();

            /*  */
            $game->setGameCd($this->gameCd);
            $gameResult = $game->getGame();
            setGameScore($gameResult);
            $this->detailGame = $gameResult;
            for ($i = 1; $i <= _SB_MODULE_MAXINING; $i++) {
                $this->detailGame['topList'][$i] = $gameResult['top_' . $i];
                $this->detailGame['bottomList'][$i] = $gameResult['bottom_' . $i];
            }

            $this->errFg = true;
            return;
        }

        /* 󥹥󥹤 */
        $playerResult =& new PlayerResultHitter();

        /* (Ǽ) */
        $playerResult->setDataList($this->topFg, 'top_fg', _SB_MODULE_DB_SET_INTEGER, true);
        $playerResult->setDataList($this->gameCd, 'game_cd', _SB_MODULE_DB_SET_INTEGER, true);
        if ($playerResult->delete()) {
            foreach ($this->playerResultHitterList as $playerResultHitter) {
                if (!empty($playerResultHitter['batting_order'])) {
                    $playerResult->setDataList($playerResultHitter['player_cd'], 'player_cd',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['batting_order'], 'batting_order',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['game_position'], 'game_position',
                        _SB_MODULE_DB_SET_STRING);
                    $playerResult->setDataList($playerResultHitter['atbat'], 'atbat',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['atbats'], 'atbats',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['hits'], 'hits',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['two_base'], 'two_base',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['three_base'], 'three_base',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['HR'], 'HR',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['BB'], 'BB',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['HBP'], 'HBP',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['E'], 'E',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['sacrifice'], 'sacrifice',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['RBI'], 'RBI',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['R'], 'R',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['SB'], 'SB',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['K'], 'K',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultHitter['self_E'], 'self_E',
                        _SB_MODULE_DB_SET_INTEGER);

                    /* (Ǽ)ɲ */
                    if (!$playerResult->insert()) {
                        $this->errFg = true;
                        $this->errMsg = _MD_SB_FAILE_REGIST;
                    }
                }
            }
        }
        else {
            $this->errFg = true;
            $this->errMsg = _MD_SB_FAILE_REGIST;
        }
    }

    /**
     * ̡̲⤷(Ǽ)Խ̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        /* (Ǽ)Խ */
        if ($this->unbrokenFg) {
            $root->mController->executeRedirect(_SB_MODULE_URL .
                "index.php?action=editPlayerResultHitter&team_cd=" . $this->teamCd . "&game_cd=" .
                $this->gameCd . "&top_fg=" . $this->topFg, _SB_MODULE_REDIRECT_TIME,
                _MD_SB_SUCCESS_REGIST);
        }
        /* ̲ */
        else {
            $root->mController->executeRedirect(_SB_MODULE_URL .
                "index.php?action=detailGame&game_cd=&game_cd=" . $this->gameCd,
                _SB_MODULE_REDIRECT_TIME, _MD_SB_SUCCESS_REGIST);
        }
    }

    /**
     * ͥ顼ɽ
     *
     */
    function errorView() {
        $root =& XCube_Root::getSingleton();
        $render =& $root->mContext->mModule->getRenderTarget();

        $render->setTemplateName('sb_edit_player_result_hitter.html');
        $render->setAttribute('action', 'regiPlayerResultHitter');
        $render->setAttribute('playerResultHitterList', $this->playerResultHitterList);
        $render->setAttribute('playerList', $this->playerList);
        $render->setAttribute('detailTeam', $this->detailTeam);
        $render->setAttribute('detailGame', $this->detailGame);
        $render->setAttribute('topFg', $this->topFg);
        $render->setAttribute('validateFg', $this->validateFg);
        $render->setAttribute('unbrokenFg', $this->unbrokenFg);
        $render->setAttribute('actionForm', $this->actionForm);
        $render->setAttribute('title', _MD_SB_TITLE_EDIT_PLAYER_RESULT_HITTER);
        define('XOOPS_FOOTER_INCLUDED', 1);
    }
}
?>