<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * 󹹿饹
 *
 * @since 0.0.4
 * @author saitoh-y
 */
class updatePlayerAction extends ActionAbstract  {

    /**
     * ꥳ
     *
     * @access private
     * @var Integer
     */
    private $playerCd = 0;

    /**
     * 
     *
     * @access private
     * @var Array
     */
    private $detailPlayer = array();

    /**
     * 󹹿μ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $acl =& new Acl();
        $player =& new Player();

        /* ͼ */
        $playerCd = $root->mContext->mRequest->getRequest('player_cd');
        $teamCd = $root->mContext->mRequest->getRequest('team_cd');
        $teamName = $root->mContext->mRequest->getRequest('team_name');
        $playerName = $root->mContext->mRequest->getRequest('player_name');
        $backnum = $root->mContext->mRequest->getRequest('backnum');
        $position = $root->mContext->mRequest->getRequest('position');
        $bossFg = $root->mContext->mRequest->getRequest('boss_fg');
        $capFg = $root->mContext->mRequest->getRequest('cap_fg');
        $throwingCd = $root->mContext->mRequest->getRequest('throwing_cd');
        $battingCd = $root->mContext->mRequest->getRequest('batting_cd');
        $birthday = $root->mContext->mRequest->getRequest('birthday');
        $showBirthdayFg = $root->mContext->mRequest->getRequest('show_birthday_fg');
        $comment = $root->mContext->mRequest->getRequest('comment');
        $helpFg = $root->mContext->mRequest->getRequest('help_fg');
        $obFg = $root->mContext->mRequest->getRequest('ob_fg');

        /* 桼å */
        $acl->setTeamCd($teamCd);
        if (!$acl->isEditPlayer()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NOACCSESS;
            return;
        }

        /* 桼 */
        $player->setTeamCd($teamCd);
        $this->playerList = $player->getPlayerList();
        $player->setPlayerCd($playerCd);
        $detailPlayer = $player->getPlayer();

        /* ͥå */
        $validate =& new validateUpdatePlayerFormAction();
        $validate->prepare();
        $validate->fetch();
        $validate->validate();
        if ($validate->hasError()) {
            $this->detailPlayer['player_cd'] = $playerCd;
            $this->detailPlayer['team_cd'] = $teamCd;
            $this->detailPlayer['team_name'] = $teamName;
            $this->detailPlayer['player_name'] = $playerName;
            $this->detailPlayer['backnum'] = $backnum;
            $this->detailPlayer['position'] = $position;
            $this->detailPlayer['boss_fg'] = $bossFg;
            $this->detailPlayer['cap_fg'] = $capFg;
            $this->detailPlayer['throwing_cd'] = $throwingCd;
            $this->detailPlayer['batting_cd'] = $battingCd;
            $this->detailPlayer['show_birthday_fg'] = $showBirthdayFg;
            $this->detailPlayer['birthday'] = $birthday;
            $this->detailPlayer['comment'] = $comment;
            $this->detailPlayer['help_fg'] = $helpFg;
            $this->detailPlayer['ob_fg'] = $obFg;
            $this->detailPlayer['image_path'] = $detailPlayer['image_path'];
            $this->actionForm = $validate;
            $this->errFg = true;
            return;
        }

        /* μ */
        $player->setDataList($playerCd, 'player_cd', _SB_MODULE_DB_SET_INTEGER, true);
        $player->setDataList($teamCd, 'team_cd', _SB_MODULE_DB_SET_INTEGER);
        $player->setDataList($playerName, 'player_name', _SB_MODULE_DB_SET_STRING);
        $player->setDataList($backnum, 'backnum', _SB_MODULE_DB_SET_STRING);
        $player->setDataList($position, 'position', _SB_MODULE_DB_SET_STRING);
        $player->setDataList($bossFg, 'boss_fg', _SB_MODULE_DB_SET_INTEGER);
        $player->setDataList($capFg, 'cap_fg', _SB_MODULE_DB_SET_INTEGER);
        $player->setDataList($throwingCd, 'throwing_cd', _SB_MODULE_DB_SET_INTEGER);
        $player->setDataList($battingCd, 'batting_cd', _SB_MODULE_DB_SET_INTEGER);
        $player->setDataList($showBirthdayFg, 'show_birthday_fg', _SB_MODULE_DB_SET_INTEGER);
        if (!empty($birthday)) {
            $player->setDataList($birthday, 'birthday', _SB_MODULE_DB_SET_DATE);
        }
        else {
            $player->setDataList(NULL, 'birthday');
        }
        $player->setDataList($comment, 'comment', _SB_MODULE_DB_SET_STRING);
        $player->setDataList($helpFg, 'help_fg', _SB_MODULE_DB_SET_INTEGER);
        $player->setDataList($obFg, 'ob_fg', _SB_MODULE_DB_SET_INTEGER);
        /* ե뤬Τɲý򤹤 */
        $uploadImageFg = false;
        if (is_uploaded_file($_FILES['image_path']['tmp_name'])) {
            $imageName = getRandamInteger() . strrchr($_FILES['image_path']['name'], '.');
            $imagePath = _SB_MODULE_UPLOAD_IMAGE_PATH . $imageName;
            $imageUrl = _SB_MODULE_UPLOAD_IMAGE_URL . $imageName;
            $player->setDataList($imageUrl, 'image_path', _SB_MODULE_DB_SET_STRING);
            if (move_uploaded_file($_FILES['image_path']['tmp_name'], $imagePath)) {
                $uploadImageFg = true;
            }
        }

        /* 󹹿 */
        if (!$player->update()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_FAILE_UPDATE;
        }
        else {
            if (!empty($detailPlayer['image_path']) && $uploadImageFg) {
                /* β */
                $unlink = _SB_MODULE_UPLOAD_IMAGE_PATH . basename($detailPlayer['image_path']);
                unlink($unlink);
            }
            $this->playerCd = $playerCd;
        }
    }

    /**
     * ܺٲ̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $root->mController->executeRedirect(_SB_MODULE_URL .
            "index.php?action=detailPlayer&player_cd=" . $this->playerCd, _SB_MODULE_REDIRECT_TIME,
            _MD_SB_SUCCESS_UPDATE);
    }

    /**
     * ͥ顼ɽ
     *
     */
    function errorView() {
        $root =& XCube_Root::getSingleton();
        $render =& $root->mContext->mModule->getRenderTarget();
        $render->setTemplateName('sb_edit_player.html');
        $render->setAttribute('action', 'updatePlayer');
        $render->setAttribute('detailPlayer', $this->detailPlayer);
        $render->setAttribute('playerList', $this->playerList);
        $render->setAttribute('title', _MD_SB_TITLE_EDIT_TEAM);
        $render->setAttribute('actionForm', $this->actionForm);
        define('XOOPS_FOOTER_INCLUDED', 1);
    }
}
?>