<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once XOOPS_MODULE_PATH . '/legacy/kernel/Legacy_ActionForm.class.php';
require_once XOOPS_MODULE_PATH . '/legacy/class/Legacy_Validator.class.php';

/**
 * ̹ͥå饹
 *
 * @since 0.0.1
 * @author saitoh-y
 */
class validateUpdateGameFormAction extends Legacy_ActionForm {
    /**
     * 󥹥ȥ饯
     *
     * @return object validateUpdateGameFormAction
     */
    function validateUpdateGameFormAction() {
        parent::Legacy_ActionForm();
    }

    /**
     * ȡ̾
     *
     * @return String
     */
    function getTokenName() {
        return 'modules.' . _SB_DIRNAME . '.updateGameForm.TOKEN';
    }

    /**
     * ͥå¹ԥ᥽å
     *
     */
    function prepare() {
        /* ǡϥåϿ */
        $this->mFormProperties['game_name'] =& new XCube_StringProperty('game_name');
        $this->mFormProperties['game_date'] =& new XCube_StringProperty('game_date');
        $this->mFormProperties['game_site'] =& new XCube_StringProperty('game_site');
        $this->mFormProperties['top_team_cd'] =& new XCube_StringProperty('top_team_cd');
        $this->mFormProperties['top_team_name'] =& new XCube_StringProperty('top_team_name');
        $this->mFormProperties['bottom_team_cd'] =& new XCube_StringProperty('bottom_team_cd');
        $this->mFormProperties['bottom_team_name'] =& new XCube_StringProperty('bottom_team_name');
        for ($ining = 1; $ining <= _SB_MODULE_MAXINING; $ining++) {
            $this->mFormProperties['top_' . $ining] =& new XCube_StringProperty('top_' . $ining);
            $this->mFormProperties['bottom_' . $ining] =& new XCube_StringProperty('bottom_'
                . $ining);
        }

        /* ̾ */
        $this->mFieldProperties['game_name'] =& new XCube_FieldProperty($this);
        $this->mFieldProperties['game_name']->setDependsByArray(array('required', 'maxlength'));
        $this->mFieldProperties['game_name']->addVar('maxlength', _SB_MODULE_VALI_MAXLENGTH_VARCHAR);
        $this->mFieldProperties['game_name']->addMessage('required', _MD_SB_COLUMN_GAME_NAME
            . _MD_SB_CHECK_NULL);
        $this->mFieldProperties['game_name']->addMessage('maxlength', _MD_SB_CHECK_MAXLENGTH,
            _MD_SB_COLUMN_GAME_NAME, _SB_MODULE_VALI_MAXLENGTH_VARCHAR);

        /*  */
        $this->mFieldProperties['game_date'] =& new XCube_FieldProperty($this);
        $this->mFieldProperties['game_date']->setDependsByArray(array('required'));
        $this->mFieldProperties['game_date']->addMessage('required', _MD_SB_COLUMN_GAME_DATE
            . _MD_SB_CHECK_NULL);

        /*  */
        $this->mFieldProperties['game_site'] =& new XCube_FieldProperty($this);
        $this->mFieldProperties['game_site']->setDependsByArray(array('maxlength'));
        $this->mFieldProperties['game_site']->addVar('maxlength', _SB_MODULE_VALI_MAXLENGTH_VARCHAR);
        $this->mFieldProperties['game_site']->addMessage('maxlength', _MD_SB_CHECK_MAXLENGTH,
            _MD_SB_COLUMN_GAME_SITE, _SB_MODULE_VALI_MAXLENGTH_VARCHAR);

        /* 蹶̾ */
        $this->mFieldProperties['top_team_name'] =& new XCube_FieldProperty($this);
        $this->mFieldProperties['top_team_name']->setDependsByArray(array('maxlength'));
        $this->mFieldProperties['top_team_name']->addVar('maxlength',
            _SB_MODULE_VALI_MAXLENGTH_VARCHAR);
        $this->mFieldProperties['top_team_name']->addMessage('maxlength', _MD_SB_CHECK_MAXLENGTH,
            _MD_SB_COLUMN_GAME_TOP_TEAM_NAME, _SB_MODULE_VALI_MAXLENGTH_VARCHAR);

        /* 并̾ */
        $this->mFieldProperties['bottom_team_name'] =& new XCube_FieldProperty($this);
        $this->mFieldProperties['bottom_team_name']->setDependsByArray(array('maxlength'));
        $this->mFieldProperties['bottom_team_name']->addVar('maxlength',
            _SB_MODULE_VALI_MAXLENGTH_VARCHAR);
        $this->mFieldProperties['bottom_team_name']->addMessage('maxlength', _MD_SB_CHECK_MAXLENGTH,
            _MD_SB_COLUMN_GAME_BOTTOM_TEAM_NAME, _SB_MODULE_VALI_MAXLENGTH_VARCHAR);

        /* ƥ˥ */
        for ($ining = 1; $ining <= _SB_MODULE_MAXINING; $ining++) {
            $this->mFieldProperties['top_' . $ining] =& new XCube_FieldProperty($this);
            $this->mFieldProperties['top_' . $ining]->setDependsByArray(array('maxlength'));
            $this->mFieldProperties['top_' . $ining]->addVar('maxlength',
                _SB_MODULE_VALI_MAXLENGTH_INING);
            $this->mFieldProperties['top_' . $ining]->addMessage('maxlength', _MD_SB_CHECK_MAXLENGTH,
                _MD_SB_COLUMN_GAME_INING, _SB_MODULE_VALI_MAXLENGTH_INING);
            $this->mFieldProperties['bottom_' . $ining] =& new XCube_FieldProperty($this);
            $this->mFieldProperties['bottom_' . $ining]->setDependsByArray(array('maxlength'));
            $this->mFieldProperties['bottom_' . $ining]->addVar('maxlength',
                _SB_MODULE_VALI_MAXLENGTH_INING);
            $this->mFieldProperties['bottom_' . $ining]->addMessage('maxlength',
                _MD_SB_CHECK_MAXLENGTH, _MD_SB_COLUMN_GAME_INING, _SB_MODULE_VALI_MAXLENGTH_INING);
        }
    }

    /**
     * 蹶̾NULLå
     *
     */
    function validateTop_team_name() {
        $teamCd = $this->get('top_team_cd');
        $teamName = $this->get('top_team_name');
        if (empty($teamCd) && empty($teamName)) {
            $this->addErrorMessage(_MD_SB_COLUMN_GAME_TOP_TEAM_NAME
                . _MD_SB_CHECK_NULL);
        }

    }

    /**
     * 并̾NULLå
     *
     */
    function validateBottom_team_name() {
        $teamCd = $this->get('bottom_team_cd');
        $teamName = $this->get('bottom_team_name');
        if (empty($teamCd) && empty($teamName)) {
            $this->addErrorMessage(_MD_SB_COLUMN_GAME_BOTTOM_TEAM_NAME
                . _MD_SB_CHECK_NULL);
        }

    }
}
?>