<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * Ŀ()󥭥󥰰饹
 *
 * @version 0.0.2
 * @author saitoh-y
 */
class viewPlayerResultPitcherRankAction extends ActionAbstract {

    /**
     * 󥯥ꥹ
     *
     * @access private
     * @var Array
     */
    private $rankList = array();

    /**
     * 
     *
     * @access private
     * @var Integer
     */
    private $baseIP = 0;
    
    /**
     * ƥꥳ
     *
     * @access private
     * @var Integer
     */
    private $categoryCd = 0;

    /**
     * ǯ
     *
     * @access private
     * @var Integer
     */
    private $year = 0;

    /**
     * ǯꥹ
     *
     * @access private
     * @var Array
     */
    private $yearList = array();

    /**
     * ̾
     *
     * @access private
     * @var String
     */
    private $column;

    /**
     * Ⱦ
     *
     * @access private
     * @var String
     */
    private $sort;
    
    /**
     * ƥꥹ
     *
     * @access private
     * @var Array
     */
    private $categoryList = array();

    /**
     * Ŀ()󥭥󥰰ɽμ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();

        /* ͼ */
        $year = $root->mContext->mRequest->getRequest('year');
        $this->categoryCd = $root->mContext->mRequest->getRequest('category_cd');
        $this->column = $root->mContext->mRequest->getRequest('column');
        $this->sort = $root->mContext->mRequest->getRequest('sort');
        if (empty($this->column)) {
            $this->column = _SB_MODULE_DEFAULT_PITCHER_RANK_COLUMN;
        }
        if (empty($this->sort)) {
            $this->sort = _SB_MODULE_DEFAULT_PITCHER_RANK_SORT;
        }

        /* 󥹥󥹤 */
        $playerResultPitcher =& new PlayerResultPitcher();
        $team =& new Team();
        $game =& new Game();
        $category =& new Category();
        
        /* ƥꥹȤμ */
        $this->categoryList = $category->getListWithoutDelfg();

        /* ǯꥹȤ */
        $oldYear = $game->getOldestYear();
        $lastYear = $game->getLastestYear();
        if (!is_null($oldYear) && !is_null($lastYear)) {
            $cnt = 0;
            for ($i = $oldYear; $i <= $lastYear; $i++) {
                $this->yearList[$cnt]['value'] = $i;
                $this->yearList[$cnt]['name'] = $i . _MD_SB_TEXT_YEAR;
                $cnt++;
            }
            rsort($this->yearList);
        }
        $this->yearList[$cnt]['value'] = _MD_SB_TEXT_TOTAL;
        $this->yearList[$cnt]['name'] = _MD_SB_TEXT_TOTAL;

        /* ǯ */
        if (!empty($year)) {
            $this->year = $year;
        }
        else {
            $this->year = $lastYear;
        }

        /* ꥹȤμ */
        $teamList = $team->getAllList();
        /* (Ǥ⥲¿Υ)ȤƼ */
        $maxGameCount = 0;
        $game->setCategoryCd($this->categoryCd);
        foreach ($teamList as $teamItem) {
            $game->setTeamCd($teamItem['team_cd']);
            $gameCount = $game->getGameCount($this->year);
            if ($gameCount > $maxGameCount) {
                $maxGameCount = $gameCount;
            }
        }
        $this->baseIP = $maxGameCount * _SB_MODULE_BASE_IP_NUM;

        /* 󥭥󥰥ꥹȤμ */
        $playerResultPitcher->setYear($this->year);
        $playerResultPitcher->setBaseIP($this->baseIP);
        $playerResultPitcher->setCategoryCd($this->categoryCd);
        $playerResultPitcher->setRankSortCond($this->column, $this->sort);

        /* 󥭥󥰤μ */
        $playerResultPitcher->setResultCd(1);
        $winList = $playerResultPitcher->getResultCdList();
        /* ̿󥭥󥰤μ */
        $playerResultPitcher->setResultCd(2);
        $loseList = $playerResultPitcher->getResultCdList();
        /* SAVE󥭥󥰤μ */
        $playerResultPitcher->setResultCd(3);
        $SVList = $playerResultPitcher->getResultCdList();
        /* HOLD󥭥󥰤μ */
        $playerResultPitcher->setResultCd(4);
        $HLDList = $playerResultPitcher->getResultCdList();
        /* ¾ܥ󥭥󥰤μ */
        $rankList = array_set_key($playerResultPitcher->getRankList(), 'player_cd');

        /* ̤ޡ */
        for ($i = 0; $i < count($rankList); $i++) {
            if (!empty($winList[$i]) && !empty($rankList[$winList[$i]['player_cd']])) {
                $rankList[$winList[$i]['player_cd']]['win'] = $winList[$i]['win'];
            }
            if (!empty($loseList[$i]) && !empty($rankList[$loseList[$i]['player_cd']])) {
                $rankList[$loseList[$i]['player_cd']]['lose'] = $loseList[$i]['lose'];
            }
            if (!empty($SVList[$i]) && !empty($rankList[$SVList[$i]['player_cd']])) {
                $rankList[$SVList[$i]['player_cd']]['SV'] = $SVList[$i]['SV'];
            }
            if (!empty($HLDList[$i]) && !empty($rankList[$HLDList[$i]['player_cd']])) {
                $rankList[$HLDList[$i]['player_cd']]['HLD'] = $HLDList[$i]['HLD'];
            }
        }

        /* 󥯥ꥹȤΥ */
        if ($this->sort == 'ASC') {
            $sort = SORT_ASC;
        }
        else {
            $sort = SORT_DESC;
        }

        if (!empty($rankList)) {
            foreach ($rankList as $key => $rank) {
                /* Τ󥽡ȤͿ */
                if ($this->column == 'IP') {
                    @$IPOutList[$key] = $rank['IP_put'];
                }
                $firstKeyList[$key] = $rank[$this->column];
                $secondKeyList[$key] = $rank['win'];
            }
            if ($this->column != 'IP') {
                array_multisort($firstKeyList, $sort, SORT_NUMERIC, $secondKeyList, SORT_DESC, SORT_NUMERIC, $rankList);
            }
            else {
                array_multisort($firstKeyList, $sort, SORT_NUMERIC, $IPOutList, $sort, SORT_NUMERIC, $secondKeyList, SORT_DESC, SORT_NUMERIC, $rankList);
            }

            $this->rankList = $rankList;
        }
        else {
            $this->rankList = array();
        }

    }

    /**
     * ǯ̰ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $render =& $root->mContext->mModule->getRenderTarget();
        $render->setTemplateName('sb_view_player_result_pitcher.html');
        $render->setAttribute('rankList', $this->rankList);
        $render->setAttribute('categoryList', $this->categoryList);
        $render->setAttribute('baseIP', $this->baseIP);
        $render->setAttribute('yearList', $this->yearList);
        $render->setAttribute('year', $this->year);
        $render->setAttribute('category_cd', $this->categoryCd);
        $render->setAttribute('column', $this->column);
        $render->setAttribute('sort', $this->sort);
        $render->setAttribute('title', _MD_SB_TITLE_VIEW_PLAYER_RESULT_PITCHER);
    }
}
?>