CREATE TABLE IF NOT EXISTS `{prefix}_{dirname}_sb_game` (
  `game_cd` int(11) NOT NULL auto_increment,
  `game_name` varchar(100) default NULL,
  `game_date` date default NULL,
  `game_site` varchar(100) NOT NULL,
  `top_team_cd` int(11) NOT NULL,
  `bottom_team_cd` int(11) NOT NULL,
  `top_team_name` varchar(100) NOT NULL,
  `bottom_team_name` varchar(100) NOT NULL,
  `top_1` varchar(3) default NULL,
  `bottom_1` varchar(3) default NULL,
  `top_2` varchar(3) default NULL,
  `bottom_2` varchar(3) default NULL,
  `top_3` varchar(3) default NULL,
  `bottom_3` varchar(3) default NULL,
  `top_4` varchar(3) default NULL,
  `bottom_4` varchar(3) default NULL,
  `top_5` varchar(3) default NULL,
  `bottom_5` varchar(3) default NULL,
  `top_6` varchar(3) default NULL,
  `bottom_6` varchar(3) default NULL,
  `top_7` varchar(3) default NULL,
  `bottom_7` varchar(3) default NULL,
  `top_8` varchar(3) default NULL,
  `bottom_8` varchar(3) default NULL,
  `top_9` varchar(3) default NULL,
  `bottom_9` varchar(3) default NULL,
  `top_10` varchar(3) default NULL,
  `bottom_10` varchar(3) default NULL,
  `top_11` varchar(3) default NULL,
  `bottom_11` varchar(3) default NULL,
  `top_12` varchar(3) default NULL,
  `bottom_12` varchar(3) default NULL,
  `game_content` text default NULL,
`category_cd` int(11) NOT NULL,
  PRIMARY KEY  (`game_cd`),
  KEY `bottom_team_cd` (`bottom_team_cd`),
  KEY `top_team_cd` (`top_team_cd`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `{prefix}_{dirname}_sb_player` (
  `player_cd` int(11) NOT NULL auto_increment,
  `player_name` varchar(100) default NULL,
  `backnum` varchar(3) default NULL,
  `position` varchar(200) default NULL,
  `boss_fg` int(1) default 0,
  `cap_fg` int(1) default 0,
  `throwing_cd` int(1) default 0,
  `batting_cd` int(1) default 0,
  `image_path` varchar(200) default NULL,
  `comment` text default NULL,
  `birthday` date default NULL,
  `show_birthday_fg` int(1) default 0,
  `team_cd` int(11) NOT NULL,
  PRIMARY KEY  (`player_cd`),
  KEY `team_cd` (`team_cd`)
) ENGINE=MyISAM ;

CREATE TABLE IF NOT EXISTS `{prefix}_{dirname}_sb_player_result_hitter` (
  `player_result_cd` int(11) NOT NULL auto_increment,
  `player_cd` int(11) NOT NULL,
  `top_fg` int(1) NOT NULL,
  `year` int(4) default NULL COMMENT '',
  `game_cd` int(11) NOT NULL,
  `batting_order` int(3) default 0,
  `game_position` varchar(200) default NULL,
  `atbat` int(11) default 0,
  `atbats` int(11) default 0,
  `hits` int(11) default 0,
  `two_base` int(11) default 0,
  `three_base` int(11) default 0,
  `HR` int(11) default 0,
  `BB` int(11) default 0,
  `HBP` int(11) default 0,
  `E` int(11) default 0,
  `sacrifice` int(11) default 0,
  `RBI` int(11) default 0,
  `R` int(11) default 0,
  `SB` int(11) default 0,
  `K` int(11) default 0,
  `BA` int(11) default 0,
  `OPB` int(11) default 0,
  `SLG` int(11) default 0,
  `OPS` int(11) default 0,
  `self_E` int(11) default 0,
  PRIMARY KEY  (`player_result_cd`),
  KEY `game_cd` (`game_cd`),
  KEY `player_cd` (`player_cd`)
) ENGINE=MyISAM ;

CREATE TABLE IF NOT EXISTS `{prefix}_{dirname}_sb_player_result_pitcher` (
  `player_result_cd` int(11) NOT NULL auto_increment,
  `player_cd` int(11) NOT NULL,
  `top_fg` int(1) NOT NULL,
  `year` int(4) default NULL COMMENT '',
  `game_cd` int(11) NOT NULL,
  `result_cd` int(1) default 0,
  `pitcher_order` int(3) default 0,
  `IP` int(11) default 0,
  `NP` int(11) default 0,
  `BF` int(11) default 0,
  `OBA` int(11) default 0,
  `HR` double default 0,
  `K` int(11) default 0,
  `BB` int(11) default 0,
  `HBP` int(11) default 0,
  `WP` int(11) default 0,
  `ERA` int(11) default 0,
  `R` int(11) default 0,
  `ER` int(11) default 0,
  PRIMARY KEY  (`player_result_cd`),
  KEY `game_cd` (`game_cd`),
  KEY `player_cd` (`player_cd`)
) ENGINE=MyISAM ;


CREATE TABLE IF NOT EXISTS `{prefix}_{dirname}_sb_team` (
  `team_cd` int(11) NOT NULL auto_increment,
  `team_name` varchar(100) default NULL,
  `home` varchar(100) default NULL,
  `etc` text default NULL,
  `image_path` varchar(200) default NULL,
  `sort_num` int(3) NOT NULL default '0',
  PRIMARY KEY  (`team_cd`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `{prefix}_{dirname}_sb_team_result_map` (
  `team_result_cd` int(11) NOT NULL auto_increment,
  `team_cd` int(11) NOT NULL,
  `game_cd` int(11) NOT NULL,
  PRIMARY KEY  (`team_result_cd`),
  KEY `team_cd` (`team_cd`),
  KEY `game_cd` (`game_cd`)
) ENGINE=MyISAM ;


CREATE TABLE IF NOT EXISTS `{prefix}_{dirname}_sb_access` (
  `access_cd` int(11) NOT NULL auto_increment,
  `groupid` int(11) NOT NULL,
  `action_cd` int(11) NOT NULL,
  `team_cd` int(11) default 0,
  PRIMARY KEY  (`access_cd`)
) ENGINE=MyISAM ;


CREATE TABLE IF NOT EXISTS `{prefix}_{dirname}_sb_category` (
  `category_cd` int(11) NOT NULL auto_increment,
  `category_name` varchar(100) default NULL,
  `sort_num` int(3) NOT NULL default '0',
  `category_content` text NOT NULL,
  `act_fg` int(1) NOT NULL default '1',
  PRIMARY KEY  (`category_cd`)
) ENGINE=MyISAM ;