/*
 * Decompiled with CFR 0.152.
 */
package org.spirytus.tools.jboss.plugin;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.spirytus.tools.jboss.plugin.Util;

public class VMRunner {
    public static final String JAVAC_JAR = "%JAVA_HOME%\\lib\\tools.jar";
    public static String fileSeparator = File.separator;
    private MessageConsole console = null;
    private MessageConsoleStream stream = null;
    IStreamListener streamListener = new IStreamListener(){

        public void streamAppended(String text, IStreamMonitor monitor) {
            MessageConsoleStream streamOut = VMRunner.this.stream;
            if (streamOut != null) {
                streamOut.print(text);
            }
        }
    };
    private static VMRunner instance = null;

    public static VMRunner getInstance() {
        if (instance == null) {
            instance = new VMRunner();
        }
        return instance;
    }

    private VMRunner() {
        this.initConsole();
    }

    private void initConsole() {
        this.console = new MessageConsole("", null);
        this.stream = this.console.newMessageStream();
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.addConsoles(new IConsole[]{this.console});
        manager.showConsoleView((IConsole)this.console);
    }

    public void runVM(String label, String[] classpath, String mainClass, String[] vmArgs, String[] programArgs) throws CoreException {
        VMRunnerConfiguration vmConfig = new VMRunnerConfiguration(mainClass, classpath);
        if (vmArgs != null) {
            vmConfig.setVMArguments(vmArgs);
        }
        if (programArgs != null) {
            vmConfig.setProgramArguments(programArgs);
        }
        String mode = "run";
        ILaunchConfigurationType launchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.jdt.launching.localJavaApplication");
        Launch launch = new Launch((ILaunchConfiguration)launchType.newInstance(null, label), mode, null);
        IVMRunner vmRunner = JavaRuntime.getDefaultVMInstall().getVMRunner(mode);
        vmRunner.run(vmConfig, (ILaunch)launch, null);
        launch.getProcesses()[0].getStreamsProxy().getOutputStreamMonitor().addListener(this.streamListener);
        launch.getProcesses()[0].getStreamsProxy().getErrorStreamMonitor().addListener(this.streamListener);
    }

    public void runVM(String mainClass, String jarName) throws CoreException {
        String[] classpath = VMRunner.getClassPath(jarName);
        VMRunnerConfiguration vmConfig = new VMRunnerConfiguration(mainClass, classpath);
        vmConfig.setVMArguments(new String[]{"-Xms128m", "-Xmx512m"});
        vmConfig.setProgramArguments(VMRunner.getProgramArgs());
        String mode = "run";
        ILaunchConfigurationType launchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.jdt.launching.localJavaApplication");
        Launch launch = new Launch((ILaunchConfiguration)launchType.newInstance(null, "JBoss launch"), mode, null);
        IVMRunner vmRunner = JavaRuntime.getDefaultVMInstall().getVMRunner(mode);
        vmRunner.run(vmConfig, (ILaunch)launch, null);
        launch.getProcesses()[0].getStreamsProxy().getOutputStreamMonitor().addListener(this.streamListener);
        launch.getProcesses()[0].getStreamsProxy().getErrorStreamMonitor().addListener(this.streamListener);
    }

    private static String[] getClassPath(String jarName) {
        String jar = String.valueOf(Util.getValue("PreferenceRootPage.ClassTypeString")) + fileSeparator + "bin" + fileSeparator + jarName;
        String[] classPath = new String[]{JAVAC_JAR, jar};
        int i = 0;
        while (i < classPath.length) {
            System.out.println(classPath[i]);
            ++i;
        }
        return classPath;
    }

    private static String[] getProgramArgs() {
        String endorsedDirs = "-Djava.endorsed.dirs=" + Util.getValue("PreferenceRootPage.ClassTypeString") + fileSeparator + "lib" + fileSeparator + "endorsed";
        String[] args = new String[]{endorsedDirs, "-Dsun.rmi.dgc.client.gcInterval=3600000", "-Dsun.rmi.dgc.server.gcInterval=3600000"};
        return args;
    }
}

