/*
 * Decompiled with CFR 0.152.
 */
package org.spirytus.tools.jboss.plugin.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.spirytus.tools.jboss.plugin.Util;
import org.spirytus.tools.jboss.plugin.VMRunner;

public class JBossStartAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void run(IAction action) {
        try {
            this.start();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessageDialog.openError((Shell)this.window.getShell(), (String)"JBoss", (String)"JBoss Home\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    private void start() throws CoreException {
        String[] classpath = this.getClasspath();
        String[] vmArgs = new String[]{"-Xms128m", "-Xmx512m"};
        String[] programArgs = this.getProgramArgs();
        VMRunner.getInstance().runVM("JBoss", classpath, "org.jboss.Main", vmArgs, programArgs);
    }

    private String[] getClasspath() {
        String jar = String.valueOf(Util.getJBossHomeDir()) + VMRunner.fileSeparator + "bin" + VMRunner.fileSeparator + "run.jar";
        String[] classPath = new String[]{"%JAVA_HOME%\\lib\\tools.jar", jar};
        return classPath;
    }

    private String[] getProgramArgs() {
        String endorsedDirs = "-Djava.endorsed.dirs=" + Util.getJBossHomeDir() + VMRunner.fileSeparator + "lib" + VMRunner.fileSeparator + "endorsed";
        String[] args = new String[]{endorsedDirs, "-Dsun.rmi.dgc.client.gcInterval=3600000", "-Dsun.rmi.dgc.server.gcInterval=3600000"};
        return args;
    }
}

