/*
 * Decompiled with CFR 0.152.
 */
package org.spirytus.tools.jboss.plugin.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.spirytus.tools.jboss.plugin.Util;
import org.spirytus.tools.jboss.plugin.VMRunner;

public class JBossStopAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void run(IAction action) {
        try {
            this.stop();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessageDialog.openError((Shell)this.window.getShell(), (String)"JBoss", (String)"JBoss Home\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    private void stop() throws CoreException {
        String[] classpath = this.getClasspath();
        String[] vmArgs = null;
        String[] programArgs = this.getProgramArgs();
        VMRunner.getInstance().runVM("JBoss", classpath, "org.jboss.Shutdown", vmArgs, programArgs);
    }

    private String[] getClasspath() {
        String jbossHomeDir = Util.getJBossHomeDir();
        String mainJar = String.valueOf(jbossHomeDir) + VMRunner.fileSeparator + "bin" + VMRunner.fileSeparator + "shutdown.jar";
        String clientJar = String.valueOf(jbossHomeDir) + VMRunner.fileSeparator + "client" + VMRunner.fileSeparator + "jbossall-client.jar";
        String[] classPath = new String[]{"%JAVA_HOME%\\lib\\tools.jar", mainJar, clientJar};
        int i = 0;
        while (i < classPath.length) {
            System.out.println(classPath[i]);
            ++i;
        }
        return classPath;
    }

    private String[] getProgramArgs() {
        String[] args = new String[]{"-Djboss.boot.loader.name=eclipse.exe"};
        return args;
    }
}

