/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.springframework.mail;

import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.util.StringUtils;

public class PlainMailMessage
extends SimpleMailMessage {
    protected String[] toName;
    protected String fromName;

    public PlainMailMessage() {
    }

    public PlainMailMessage(PlainMailMessage original) {
        this.setFrom(original.getFrom());
        if (original.getFromName() != null) {
            this.fromName = original.getFromName();
        }
        this.setTo(original.getTo());
        if (original.getToName() != null) {
            this.toName = original.getToName();
        }
        if (original.getCc() != null) {
            String[] cc = new String[original.getCc().length];
            System.arraycopy(original.getCc(), 0, cc, 0, original.getCc().length);
            this.setCc(cc);
        }
        if (original.getBcc() != null) {
            String[] bcc = new String[original.getBcc().length];
            System.arraycopy(original.getBcc(), 0, bcc, 0, original.getBcc().length);
            this.setBcc(bcc);
        }
        this.setSubject(original.getSubject());
        this.setText(original.getText());
    }

    public void setTo(String email, String name) {
        this.setTo(email);
        this.toName = new String[]{name};
    }

    public void addTo(String email, String name) {
        if (this.getTo() == null || this.getToName() == null) {
            this.setTo(email, name);
            return;
        }
        ArrayList<String> toList = new ArrayList<String>(Arrays.asList(this.getTo()));
        ArrayList<String> toNameList = new ArrayList<String>(Arrays.asList(this.toName));
        toList.add(email);
        toNameList.add(name);
        this.setTo(toList.toArray(new String[toList.size()]));
        this.toName = toNameList.toArray(new String[toNameList.size()]);
    }

    public String[] getToName() {
        return this.toName;
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFrom(String email, String name) {
        this.setFrom(email);
        this.setFromName(name);
    }

    public void setFromName(String name) {
        this.fromName = name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PlainMailMessage [");
        sb.append("from: " + this.getFrom());
        if (this.fromName != null) {
            sb.append(" <" + this.getFromName() + ">");
        }
        sb.append("; ");
        int i = 0;
        int num = this.getTo().length;
        while (i < num) {
            if (num > 1) {
                sb.append("[" + (i + 1) + "] ");
            }
            sb.append("to: " + this.getTo()[i]);
            if (this.toName != null) {
                sb.append(" <" + this.getToName()[i] + ">");
            }
            if (i + 1 != num) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("; ");
        sb.append("cc: " + StringUtils.arrayToCommaDelimitedString((Object[])this.getCc()) + "; ");
        sb.append("subject: " + this.getSubject() + "; ");
        sb.append("text: " + this.getText() + "]");
        return sb.toString();
    }
}

