package com.ozacc.mail.spring;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

import com.ozacc.mail.Mail;
import com.ozacc.mail.mock.MockSendMail;

/**
 * XMLMailFactoryBeanTestCase
 * 
 * @author Tomohiro Otsuka
 * @version $Id: XMLMailFactoryBeanTest.java,v 1.1 2004/09/05 22:14:43 otsuka Exp $
 */
public class XMLMailFactoryBeanTest extends TestCase {

	public void testMailFactoryBeanFail() throws Exception {
		Mail mail = new Mail();
		mail.setSubject("XMLMailBuilderΥƥȥ");
		mail.setText("Ԥޤ\nԤޤ\nƥȤ");
		mail.setFrom("from@example.com", "п");
		mail.setReturnPath("return@example.com");
		mail.setReplyTo("reply@example.com");
		mail.addTo("to1@example.com", "1");
		mail.addTo("to2@example.com");
		mail.addCc("cc1@example.com", "CC1");
		mail.addCc("cc2@example.com");
		//mail.addBcc("bcc@example.com");

		ApplicationContext context = new FileSystemXmlApplicationContext(
				"src/test/com/ozacc/mail/spring/testContext.xml");
		Mail result = (Mail)context.getBean("mail");

		try {
			MockSendMail.checkEquality(mail, result, 1);
			fail("This should never be called.");
		} catch (AssertionFailedError expected) {
			//success
		}
	}

	public void testMailFactoryBeanSuccess() throws Exception {
		Mail mail = new Mail();
		mail.setSubject("XMLMailBuilderΥƥȥ");
		mail.setText("Ԥޤ\nԤޤ\nƥȤ");
		mail.setFrom("from@example.com", "п");
		mail.setReturnPath("return@example.com");
		mail.setReplyTo("reply@example.com");
		mail.addTo("to1@example.com", "1");
		mail.addTo("to2@example.com");
		mail.addCc("cc1@example.com", "CC1");
		mail.addCc("cc2@example.com");
		mail.addBcc("bcc@example.com");

		ApplicationContext context = new FileSystemXmlApplicationContext(
				"src/test/com/ozacc/mail/spring/testContext.xml");
		Mail result = (Mail)context.getBean("mail");

		MockSendMail.checkEquality(mail, result, 1);
	}

}