/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.VelocityMailBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class JDomXMLMailBuilder
implements VelocityMailBuilder {
    public Mail buildMail(String classPath) throws MailBuildException {
        Document doc = this.getDocumentFromClassPath(classPath);
        return this.build(doc);
    }

    public Mail buildMail(String classPath, VelocityContext context) throws MailBuildException {
        Document doc = this.getDocumentFromClassPath(classPath);
        try {
            return this.build(doc, context);
        }
        catch (Exception e) {
            throw new MailBuildException("\u30e1\u30fc\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public Mail buildMail(File file) throws MailBuildException {
        Document doc = this.getDocumentFromFile(file);
        return this.build(doc);
    }

    public Mail buildMail(File file, VelocityContext context) throws MailBuildException {
        Document doc = this.getDocumentFromFile(file);
        try {
            return this.build(doc, context);
        }
        catch (Exception e) {
            throw new MailBuildException("\u30e1\u30fc\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    private Document getDocumentFromClassPath(String classPath) throws MailBuildException {
        Document doc;
        InputStream is = this.getClass().getResourceAsStream(classPath);
        SAXBuilder builder = new SAXBuilder(true);
        try {
            doc = builder.build(is);
            is.close();
        }
        catch (JDOMException e) {
            throw new MailBuildException("XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MailBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        return doc;
    }

    private Document getDocumentFromFile(File file) {
        Document doc;
        SAXBuilder builder = new SAXBuilder(true);
        try {
            doc = builder.build(file);
        }
        catch (JDOMException e) {
            throw new MailBuildException("XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MailBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        return doc;
    }

    private Mail build(Document doc) {
        Element root = doc.getRootElement();
        Mail mail = new Mail();
        this.setFrom(root, mail);
        this.setRecipients(root, mail);
        this.setSubject(root, mail);
        this.setBody(root, mail);
        this.setReplyTo(root, mail);
        this.setReturnPath(root, mail);
        return mail;
    }

    private Mail build(Document doc, VelocityContext context) throws Exception, ParseErrorException, MethodInvocationException, ResourceNotFoundException, IOException, JDOMException {
        XMLOutputter output = new XMLOutputter();
        String xmlContent = output.outputString(doc);
        Velocity.init();
        StringWriter w = new StringWriter();
        Velocity.evaluate((Context)context, (Writer)w, (String)"xmlMail", (String)xmlContent);
        StringReader reader = new StringReader(w.toString());
        SAXBuilder builder = new SAXBuilder(true);
        Document doc2 = builder.build((Reader)reader);
        return this.build(doc2);
    }

    private void setReturnPath(Element root, Mail mail) {
        Element returnPathElem = root.getChild("returnPath");
        if (returnPathElem != null && returnPathElem.getAttributeValue("email") != null) {
            mail.setReturnPath(returnPathElem.getAttributeValue("email"));
        }
    }

    private void setReplyTo(Element root, Mail mail) {
        Element replyToElem = root.getChild("replyTo");
        if (replyToElem != null && replyToElem.getAttributeValue("email") != null) {
            mail.setReplyTo(replyToElem.getAttributeValue("email"));
        }
    }

    private void setBody(Element root, Mail mail) {
        Element bodyElem = root.getChild("body");
        if (bodyElem != null) {
            mail.setText(bodyElem.getTextTrim());
        }
    }

    private void setSubject(Element root, Mail mail) {
        Element subjectElem = root.getChild("subject");
        if (subjectElem != null) {
            mail.setSubject(subjectElem.getTextTrim());
        }
    }

    private void setRecipients(Element root, Mail mail) {
        Element recipientsElem = root.getChild("recipients");
        if (recipientsElem == null) {
            return;
        }
        List recipientElemList = recipientsElem.getChildren();
        int i = 0;
        int max = recipientElemList.size();
        while (i < max) {
            Element e = (Element)recipientElemList.get(i);
            if ("to".equals(e.getName())) {
                if (e.getAttributeValue("email") != null) {
                    if (e.getAttributeValue("name") != null) {
                        mail.addTo(e.getAttributeValue("email"), e.getAttributeValue("name"));
                    } else {
                        mail.addTo(e.getAttributeValue("email"));
                    }
                }
            } else if ("cc".equals(e.getName())) {
                if (e.getAttributeValue("email") != null) {
                    if (e.getAttributeValue("name") != null) {
                        mail.addCc(e.getAttributeValue("email"), e.getAttributeValue("name"));
                    } else {
                        mail.addCc(e.getAttributeValue("email"));
                    }
                }
            } else if (e.getAttributeValue("email") != null) {
                mail.addBcc(e.getAttributeValue("email"));
            }
            ++i;
        }
    }

    private void setFrom(Element root, Mail mail) {
        Element fromElem = root.getChild("from");
        if (fromElem != null && fromElem.getAttributeValue("email") != null) {
            if (fromElem.getAttributeValue("name") != null) {
                mail.setFrom(fromElem.getAttributeValue("email"), fromElem.getAttributeValue("name"));
            } else {
                mail.setFrom(fromElem.getAttributeValue("email"));
            }
        }
    }
}

