package com.ozacc.mail;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import com.ozacc.mail.Mail;

/**
 * ޥѡȡ᡼롣եźդꡢʸHTMLѤǤޤ
 * <p>
 * <code>setHtmlText(String)</code><code>setText(String)</code>᥽åɤξѤʸ򥻥åȤϡ
 * ץ졼ƥȤʸHTMLʸξåȤ줿᡼ˤʤޤ
 * <p>
 * <strong>:</strong> <code>addFile(File, String)</code>᥽åɤѤǤդΥե̾򥻥åȤ硢ե̾ŬڤʳĥҤդƤ
 * 
 * @since 1.1
 * 
 * @author Tomohiro Otsuka
 * @version $Id: MultipartMail.java,v 1.3 2004/09/16 04:52:56 otsuka Exp $
 */
public class MultipartMail extends Mail {

	private String htmlText;

	private List attachmentFiles;

	/**
	 * 󥹥ȥ饯
	 */
	public MultipartMail() {
		super();
	}

	/**
	 * 󥹥ȥ饯
	 * 亹пͤ̾򥨥󥳡ɤ˻Ѥʸɤꤷޤ
	 * ǥեȤ<code>ISO-2022-JP</code>Ǥ
	 * <p>
	 * ܸĶѤ̾ѹɬפϤޤ
	 * 
	 * @param charset 󥳡ɤ˻Ѥʸ
	 */
	public MultipartMail(String charset) {
		super(charset);
	}

	/**
	 * ԡ󥹥ȥ饯
	 * ԡ(shallow copy)Ǥ
	 * 
	 * @param original ԡMail󥹥
	 */
	public MultipartMail(Mail original) {
		super(original);
	}

	/**
	 * ԡ󥹥ȥ饯
	 * ԡ(shallow copy)Ǥ
	 * 
	 * @param original ԡMultipartMail󥹥
	 */
	public MultipartMail(MultipartMail original) {
		super(original);
		this.htmlText = original.htmlText;
		this.attachmentFiles = original.attachmentFiles;
	}

	/**
	 * HTMLʸ򥻥åȤޤ
	 * 
	 * @param htmlText HTMLʸ
	 */
	public void setHtmlText(String htmlText) {
		this.htmlText = htmlText;
	}

	/**
	 * HTMLʸ֤ޤ
	 * 
	 * @return HTMLʸ
	 */
	public String getHtmlText() {
		return htmlText;
	}

	/**
	 * ꤵ줿եźդޤ
	 * źեե̾ˤϡꤵ줿ե̾Ѥޤ
	 * 
	 * @param file źեե
	 */
	public void addFile(File file) {
		addFile(file, file.getName());
	}

	/**
	 * ꤵ줿եźդޤ
	 * ե̾ˤŬڤʳĥҤդƤ
	 * 
	 * @param file źեե
	 * @param fileName ե̾
	 */
	public void addFile(File file, String fileName) {
		if (attachmentFiles == null) {
			attachmentFiles = new ArrayList();
		}
		attachmentFiles.add(new AttachmentFile(fileName, file));
	}

	/**
	 * źեե֤ޤ
	 * źեե뤬åȤƤʤϡ֤ޤ
	 * 
	 * @return źեե󡣤ޤ϶
	 */
	public AttachmentFile[] getAttachmentFiles() {
		if (attachmentFiles == null) {
			return new AttachmentFile[0];
		}
		return (AttachmentFile[])attachmentFiles
				.toArray(new AttachmentFile[attachmentFiles.size()]);
	}

	/**
	 * HTMLʸåȤƤ뤫ɤȽꤷޤ
	 * 
	 * @return HTMLʸåȤƤ true
	 */
	public boolean isHtmlMail() {
		return (htmlText != null);
	}

	/**
	 * źեե롣
	 * 
	 * @author Tomohiro Otsuka
	 * @version $Id: MultipartMail.java,v 1.3 2004/09/16 04:52:56 otsuka Exp $
	 */
	public static class AttachmentFile {

		private String name;

		private File file;

		/**
		 * ե̾ȥեꤷơΥ饹Υ󥿥󥹤ޤ
		 * 
		 * @param name ᡼ɽե̾
		 * @param file źեե
		 */
		public AttachmentFile(String name, File file) {
			this.name = name;
			this.file = file;
		}

		/**
		 * @return Returns the file.
		 */
		public File getFile() {
			return file;
		}

		/**
		 * @return Returns the name.
		 */
		public String getName() {
			return name;
		}
	}
}