package com.ozacc.mail.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MailBuilder;

/**
 * ᡼ǡXMLե뤫Mail󥹥󥹤륯饹
 * <p>
 * XMLɤ߹ݤˡDTDХǡ󤬼¹ԤޤΤXMLǡ(Valid XML Document)ǤʤФޤ
 * ᡼ǡXMLDTDϡ<a href="http://www.ozacc.com/library/dtd/ozacc-mail.dtd">http://www.ozacc.com/library/dtd/ozacc-mail.dtd</a>򻲾ȡ
 * 
 * @since 1.0.1
 * @author Tomohiro Otsuka
 * @version $Id: XMLMailBuilderImpl.java,v 1.3 2004/09/15 09:04:07 otsuka Exp $
 */
public class XMLMailBuilderImpl implements MailBuilder {

	private Map documentBuilderCache;

	/**
	 * 󥹥ȥ饯
	 */
	public XMLMailBuilderImpl() {
		documentBuilderCache = new HashMap();
	}

	/**
	 * @see com.ozacc.mail.MailBuilder#buildMail(java.lang.String)
	 */
	public Mail buildMail(String classPath) throws MailBuildException {
		Document doc;
		try {
			doc = getDocumentFromClassPath(classPath);
		} catch (SAXException e) {
			throw new MailBuildException("XMLΥѡ˼Ԥޤ" + e.getMessage(), e);
		} catch (IOException e) {
			throw new MailBuildException("XMLեɤ߹ߤ˼Ԥޤ", e);
		}

		return build(doc);
	}

	/**
	 * ꤵ줿饹ѥXMLեɤ߹ߡDOM Documentޤ
	 * ignoreCommentꤵƤϡXMLΥȤޤ
	 * 
	 * @param ignoreComment
	 * @param classPath
	 * @return DOM Document
	 * @throws IOException
	 * @throws SAXException
	 */
	protected synchronized Document getDocumentFromClassPath(String classPath, boolean ignoreComment)
																										throws SAXException,
																										IOException {
		InputStream is = getClass().getResourceAsStream(classPath);
		DocumentBuilder db = createDocumentBuilder(ignoreComment);
		try {
			return db.parse(is);
		} finally {
			if (is != null) {
				is.close();
			}
		}
	}

	/**
	 * ꤵ줿饹ѥXMLեɤ߹ߡDOM Documentޤ
	 * XMLΥȤԤϺޤ
	 * 
	 * @param classPath
	 * @return DOM Document
	 * @throws IOException
	 * @throws SAXException
	 */
	protected Document getDocumentFromClassPath(String classPath) throws SAXException, IOException {
		return getDocumentFromClassPath(classPath, true);
	}

	/**
	 * @see com.ozacc.mail.MailBuilder#buildMail(java.io.File)
	 */
	public Mail buildMail(File file) throws MailBuildException {
		Document doc;
		try {
			doc = getDocumentFromFile(file);
		} catch (SAXException e) {
			throw new MailBuildException("XMLΥѡ˼Ԥޤ" + e.getMessage(), e);
		} catch (IOException e) {
			throw new MailBuildException("XMLեɤ߹ߤ˼Ԥޤ", e);
		}

		return build(doc);
	}

	/**
	 * DOM DocumentMail󥹥󥹤ޤ
	 * 
	 * @param doc ᡼ǡDOM Document
	 * @return 줿Mail󥹥
	 */
	protected Mail build(Document doc) {
		Element root = doc.getDocumentElement();

		Mail mail = new Mail();
		setReturnPath(root, mail);
		setFrom(root, mail);
		setRecipients(root, mail);
		setReplyTo(root, mail);
		setSubject(root, mail);
		setText(root, mail);

		return mail;
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setReplyTo(Element root, Mail mail) {
		NodeList nodes = root.getElementsByTagName("replyTo");
		Element replyTo = (Element)nodes.item(0);
		if (replyTo != null && replyTo.getAttribute("email").length() > 0) {
			mail.setReplyTo(replyTo.getAttribute("email"));
		}
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setText(Element root, Mail mail) {
		NodeList nodes = root.getElementsByTagName("body");
		Element bodyElem = (Element)nodes.item(0);
		if (bodyElem == null) {
			return;
		}
		String body = bodyElem.getFirstChild().getNodeValue();
		mail.setText(body.trim());
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setSubject(Element root, Mail mail) {
		NodeList nodes = root.getElementsByTagName("subject");
		Element subjectElem = (Element)nodes.item(0);
		if (subjectElem == null) {
			return;
		}
		String subject = subjectElem.getFirstChild().getNodeValue();
		mail.setSubject(subject.trim());
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setRecipients(Element root, Mail mail) {
		NodeList nodes = root.getElementsByTagName("recipients");
		Element recipientsElem = (Element)nodes.item(0);
		if (recipientsElem == null) {
			return;
		}

		NodeList recipientElemList = recipientsElem.getChildNodes();
		for (int i = 0, max = recipientElemList.getLength(); i < max; i++) {
			Node node = recipientElemList.item(i);
			if (node.getNodeType() != Node.ELEMENT_NODE) {
				continue;
			}
			Element e = (Element)node;
			if ("to".equals(e.getNodeName())) { // to
				if (e.getAttribute("email").length() > 0) {
					if (e.getAttribute("name").length() > 0) {
						mail.addTo(e.getAttribute("email"), e.getAttribute("name"));
					} else {
						mail.addTo(e.getAttribute("email"));
					}
				}
			} else if ("cc".equals(e.getNodeName())) { // cc
				if (e.getAttribute("email").length() > 0) {
					if (e.getAttribute("name").length() > 0) {
						mail.addCc(e.getAttribute("email"), e.getAttribute("name"));
					} else {
						mail.addCc(e.getAttribute("email"));
					}
				}
			} else {
				if (e.getAttribute("email").length() > 0) { // bcc
					mail.addBcc(e.getAttribute("email"));
				}
			}
		}
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setReturnPath(Element root, Mail mail) {
		NodeList nodes = root.getElementsByTagName("returnPath");
		Element returnPath = (Element)nodes.item(0);
		if (returnPath != null && returnPath.getAttribute("email").length() > 0) {
			mail.setReturnPath(returnPath.getAttribute("email"));
		}
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setFrom(Element root, Mail mail) {
		NodeList nodes = root.getElementsByTagName("from");
		Element from = (Element)nodes.item(0);
		if (from != null && from.getAttribute("email").length() > 0) {
			if (from.getAttribute("name").length() > 0) {
				mail.setFrom(from.getAttribute("email"), from.getAttribute("name"));
			} else {
				mail.setFrom(from.getAttribute("email"));
			}
		}
	}

	/**
	 * ꤵ줿XMLեɤ߹ߡDOM Documentޤ
	 * ignoreCommentꤵƤϡXMLΥȤޤ
	 * 
	 * @param file XMLե
	 * @return DOM Document
	 * @throws IOException
	 * @throws SAXException
	 */
	protected synchronized Document getDocumentFromFile(File file, boolean ignoreComment)
																							throws SAXException,
																							IOException {
		DocumentBuilder db = createDocumentBuilder(ignoreComment);
		return db.parse(file);
	}

	/**
	 * ꤵ줿XMLեɤ߹ߡDOM Documentޤ
	 * XMLΥȤԤϺޤ
	 * 
	 * @param file XMLե
	 * @return DOM Document
	 * @throws IOException
	 * @throws SAXException
	 */
	protected Document getDocumentFromFile(File file) throws SAXException, IOException {
		return getDocumentFromFile(file, true);
	}

	/**
	 * DocumentBuilder󥹥󥹤ޤ
	 * ignoreCommentꤵƤϡȤʤ褦ꤵ줿DocumentBuilderޤ
	 * 
	 * @param ignoreComment
	 * @return DocumentBuilder
	 * @throws FactoryConfigurationError 
	 */
	protected DocumentBuilder createDocumentBuilder(boolean ignoreComment)
																			throws FactoryConfigurationError {
		Boolean dbKey = Boolean.valueOf(ignoreComment);
		DocumentBuilder db = (DocumentBuilder)documentBuilderCache.get(dbKey);
		if (db == null) {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			dbf.setIgnoringComments(ignoreComment);
			dbf.setCoalescing(true);
			dbf.setIgnoringElementContentWhitespace(true);
			dbf.setValidating(true);
			try {
				db = dbf.newDocumentBuilder();
				documentBuilderCache.put(dbKey, db);
			} catch (ParserConfigurationException e) {
				// never be thrown
				throw new RuntimeException(e);
			}
		}
		return db;
	}

	/**
	 * DocumentBuilder󥹥󥹤ޤ
	 * DocumentBuilderѤDOM DocumentǤϡXMLǡˤ륳ȤϺޤ
	 * 
	 * @return DocumentBuilder
	 * @throws FactoryConfigurationError 
	 */
	protected DocumentBuilder createDocumentBuilder() throws FactoryConfigurationError {
		return createDocumentBuilder(true);
	}

}