/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.util;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class MXCheck {
    public static boolean isValidEmailAddress(String email, String dns) {
        try {
            new InternetAddress(email, true);
        }
        catch (AddressException e) {
            return false;
        }
        int pos = email.lastIndexOf("@");
        String hostName = email.substring(pos + 1);
        return MXCheck.hasMXRecord(hostName, dns);
    }

    public static boolean hasMXRecord(String hostName, String dns) {
        String name = "dns://" + dns + "/" + hostName;
        try {
            InitialDirContext ictx = new InitialDirContext();
            Attributes attrs = ictx.getAttributes(name, new String[]{"MX"});
            NamingEnumeration<? extends Attribute> namingEnumeration = attrs.getAll();
            if (namingEnumeration.hasMore()) {
                return true;
            }
        }
        catch (NamingException e) {
            return false;
        }
        return false;
    }

    public static boolean hasMXRecord(String hostName) {
        return MXCheck.hasMXRecord(hostName, "localhost");
    }

    public static void main(String[] args) {
        boolean result = false;
        result = args.length == 1 ? MXCheck.hasMXRecord(args[0]) : MXCheck.hasMXRecord(args[0], args[1]);
        if (result) {
            System.out.println(String.valueOf(args[0]) + " \u306e MX \u30ec\u30b3\u30fc\u30c9\u306f\u5b58\u5728\u3057\u307e\u3059\u3002");
        } else {
            System.out.println(String.valueOf(args[0]) + " \u306e MX \u30ec\u30b3\u30fc\u30c9\u306f\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
    }
}

