package com.ozacc.mail.mock;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;

import com.dumbster.smtp.SimpleSmtpServer;
import com.ozacc.mail.Mail;

/**
 * SendMailImpl饹Υƥȥ
 * <p>
 * DumbsterѤƥƥȤƤ뤬ݡȤƤʤǽ¿
 * 
 * @author Tomohiro Otsuka
 * @version $Id: MockSendMailTest.java,v 1.6 2004/09/17 23:07:59 otsuka Exp $
 */
public class MockSendMailTest extends TestCase {

	private MockSendMail mockSendMail;

	private SimpleSmtpServer server;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		BasicConfigurator.configure();

		mockSendMail = new MockSendMail();
		mockSendMail.setDebug(true);
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		BasicConfigurator.resetConfiguration();
	}

	public void testSendMailNotMatchMailNum() throws Exception {
		Mail mail = new Mail();
		mail.addTo("to@example.com");

		mockSendMail.addExpectedMail(mail);
		mockSendMail.addExpectedMail(mail);

		mockSendMail.send(mail);

		try {
			mockSendMail.verify();
			fail("This should never be called.");
		} catch (AssertionFailedException expected) {
			// success
		}
	}

	public void testSendMailSuccess() throws Exception {
		String from = "from@example.com";
		String fromName = "п";
		String to = "info@example.com";
		String subject = "̾";
		String text = "ƥ";

		Mail mail = new Mail();
		mail.setFrom(from, fromName);
		mail.addTo(to);
		mail.setSubject(subject);
		mail.setText(text);

		mockSendMail.addExpectedMail(mail);

		mockSendMail.send(mail);

		mockSendMail.verify();
	}

	public void testSendMailToAddressNotMatch() throws Exception {
		String from = "from@example.com";
		String fromName = "п";
		String to = "info@example.com";
		String subject = "̾";
		String text = "ƥ";

		Mail mail1 = new Mail();
		mail1.setFrom(from, fromName);
		mail1.addTo(to);
		mail1.setSubject(subject);
		mail1.setText(text);

		Mail mail2 = new Mail();
		mail2.setFrom(from, fromName);
		mail2.addTo("contact@example.com");
		mail2.setSubject(subject);
		mail2.setText(text);

		mockSendMail.addExpectedMail(mail1);

		mockSendMail.send(mail2);

		try {
			mockSendMail.verify();
			fail("This should never be called.");
		} catch (AssertionFailedException expected) {
			// success
		}
	}

	public void testSendMailWithMockMail() throws Exception {
		Mail sentMail = new Mail();
		sentMail.setFrom("from@example.com");
		sentMail.setSubject("̾");
		sentMail.addTo("to@example.com");
		sentMail.setText("ưŪʸ");

		Mail expectedMail = new Mail();
		expectedMail.setFrom("from@example.com");
		expectedMail.setSubject("̾");

		MockMail mockMail = new MockMail();
		mockMail.setFrom("from@example.com");
		mockMail.setSubject("̾");

		MockSendMail sendMail = new MockSendMail();
		sendMail.setDebug(true);

		sendMail.addExpectedMail(mockMail);
		sendMail.send(sentMail);
		sendMail.verify(); // 

		sendMail = new MockSendMail();
		sendMail.addExpectedMail(expectedMail);
		sendMail.send(sentMail);
		try {
			sendMail.verify(); // 顼
			fail("This should never be called.");
		} catch (AssertionFailedException expected) {
			// success
		}
	}

	public void testSendMailWithMockMulitpartMail() throws Exception {
		Mail sentMail = new Mail();
		sentMail.setFrom("from@example.com");
		sentMail.setSubject("̾");
		sentMail.addTo("to@example.com");
		sentMail.setText("ưŪʸ");

		Mail expectedMail = new Mail();
		expectedMail.setFrom("from@example.com");
		expectedMail.setSubject("̾");
		expectedMail.addTo("to@example.com");
		expectedMail.setText("ưŪʸ");
		expectedMail.setHtmlText("<html><body>HTMLʸ</body></html>");

		MockSendMail sendMail = new MockSendMail();
		sendMail.setDebug(true);

		sendMail.addExpectedMail(expectedMail);
		sendMail.send(sentMail);

		try {
			sendMail.verify();
			fail("This should never be called.");
		} catch (AssertionFailedException expected) {
			// success
		}

		sendMail.initialize();

		sendMail.addExpectedMail(expectedMail);
		sendMail.send(sentMail);
		try {
			sendMail.verify();
			fail("This should never be called.");
		} catch (AssertionFailedException expected) {
			// HTMLʸפʤ
		}

		sendMail.initialize();

		sentMail.setHtmlText("<html><body>HTMLʸ</body></html>");
		sendMail.addExpectedMail(expectedMail);
		sendMail.send(sentMail);
		sendMail.verify();

		sendMail.initialize();

		expectedMail.setHtmlText(null);
		sendMail.addExpectedMail(expectedMail);
		sendMail.send(sentMail);
		// expectedϥޥѡȤǤϤʤsentMailHTMLȤӤʤ
		sendMail.verify();

		sendMail.initialize();

		MockMail expectedMockMail = new MockMail(expectedMail);
		sendMail.addExpectedMail(expectedMockMail);
		sendMail.send(sentMail);
		try {
			sendMail.verify();
		} catch (AssertionFailedException expected) {
			fail("This should never be called.");
		}
	}

}