package com.ozacc.mail.xml.impl;

import java.io.File;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.jdom.output.XMLOutputter;

import com.ozacc.mail.Mail;
import com.ozacc.mail.xml.XMLBuilder;

/**
 * 
 * @author Tomohiro Otsuka
 * @version $Id: XMLBuilderImplTest.java,v 1.4 2004/09/18 00:39:35 otsuka Exp $
 */
public class XMLBuilderImplTest extends TestCase {

	private XMLBuilder builder;

	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		BasicConfigurator.configure();

		builder = new XMLBuilderImpl();
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		BasicConfigurator.resetConfiguration();
	}

	public final void testCreateDocument() throws Exception {
		Mail mail = getMailForTest();

		org.w3c.dom.Document doc = builder.buildDocument(mail);

		DOMBuilder builder = new DOMBuilder();
		Document jdomDoc = builder.build(doc);

		System.out.println(jdomDoc);

		XMLOutputter outputter = new XMLOutputter();
		String document = outputter.outputString(jdomDoc);
		System.out.println(document);
	}

	/*
	 * Class under test for void saveDocument(Mail, File)
	 */
	public final void testSaveDocumentMailFile() throws Exception {
		Mail mail = getMailForTest();

		String filePath = "target/test/data/mail-jdk.xml";
		File file = new File(filePath);
		file.getParentFile().mkdirs();

		builder.saveDocument(mail, file);
	}

	public final void testSaveDocumentHtml() throws Exception {
		Mail mail = getMailForTest();
		mail.setHtmlText("<html><body>ƥ</body></html>");

		String filePath = "target/test/data/mail-jdk-html.xml";
		File file = new File(filePath);
		file.getParentFile().mkdirs();

		builder.saveDocument(mail, file);
	}

	/**
	 * @return 
	 */
	private Mail getMailForTest() {
		String from = "from@example.com";
		String fromName = "п";
		String to = "info@example.com";
		String subject = "̾";
		String text = "ƥ";

		Mail mail = new Mail();
		mail.setFrom(from, fromName);
		mail.addTo(to);
		mail.setSubject(subject);
		mail.setText(text);
		return mail;
	}

}