/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.blog.rss.informa;

import com.ozacc.blog.rss.Channel;
import com.ozacc.blog.rss.ParseException;
import com.ozacc.blog.rss.RSSAutoDiscovery;
import com.ozacc.blog.rss.RSSParser;
import com.ozacc.blog.rss.impl.RSSAutoDiscoveryImpl;
import com.ozacc.blog.rss.informa.ChannelAdapter;
import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.parsers.FeedParser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class RSSParserImpl
implements RSSParser {
    private RSSAutoDiscovery rssAutoDiscovery = new RSSAutoDiscoveryImpl();

    public Channel parseRSS(URL rssUrl) throws ParseException {
        try {
            return new ChannelAdapter(FeedParser.parse((ChannelBuilderIF)new ChannelBuilder(), (URL)rssUrl));
        }
        catch (IOException e) {
            throw new ParseException("\u6307\u5b9a\u3055\u308c\u305fURL\u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 [" + rssUrl + "]", e);
        }
        catch (de.nava.informa.core.ParseException e) {
            throw new ParseException("RSS\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public Channel discoverAndParseRSS(URL targetPageUrl) throws ParseException {
        URL[] rssUrls;
        try {
            rssUrls = this.rssAutoDiscovery.discoverRSSUrls(targetPageUrl);
        }
        catch (ParseException e) {
            throw new ParseException("RSS\u306eAutoDiscovery\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[url='" + targetPageUrl + "']", e);
        }
        if (rssUrls.length > 0) {
            return this.parseRSS(rssUrls[0]);
        }
        throw new ParseException("\u6307\u5b9a\u3055\u308c\u305fURL\u306e\u30da\u30fc\u30b8\u3067\u306fRSS\u306eURL\u3092\u898b\u3064\u3051\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002[url='" + targetPageUrl + "']");
    }

    public void setRssAutoDiscovery(RSSAutoDiscovery rssAutoDiscovery) {
        this.rssAutoDiscovery = rssAutoDiscovery;
    }

    public Channel parseRSS(String rssUrl) throws ParseException {
        try {
            return this.parseRSS(new URL(rssUrl));
        }
        catch (MalformedURLException e) {
            throw new ParseException("\u6307\u5b9a\u3055\u308c\u305fURL\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u4e0d\u6b63\u3067\u3059\u3002[url='" + rssUrl + "']", e);
        }
    }

    public Channel discoverAndParseRSS(String targetPageUrl) throws ParseException {
        try {
            return this.discoverAndParseRSS(new URL(targetPageUrl));
        }
        catch (MalformedURLException e) {
            throw new ParseException("\u6307\u5b9a\u3055\u308c\u305fURL\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u4e0d\u6b63\u3067\u3059\u3002[url='" + targetPageUrl + "']", e);
        }
    }
}

