/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.blog.trackback;

import com.ozacc.blog.trackback.TrackBackPing;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;

public class TrackBackUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";

    private TrackBackUtils() {
    }

    public static TrackBackPing getTrackBackPingFromRequest(HttpServletRequest request) {
        String charset = request.getParameter("charset");
        if (charset == null && charset.length() == 0) {
            charset = DEFAULT_CHARSET;
        }
        String excerpt = request.getParameter("excerpt");
        String blogName = request.getParameter("blog_name");
        String title = request.getParameter("title");
        String url = request.getParameter("url");
        try {
            excerpt = TrackBackUtils.convertCharset(charset, excerpt);
            blogName = TrackBackUtils.convertCharset(charset, blogName);
            title = TrackBackUtils.convertCharset(charset, title);
            url = TrackBackUtils.convertCharset(charset, url);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        TrackBackPing ping = new TrackBackPing(title, excerpt, url, blogName);
        ping.setCharset(charset);
        return ping;
    }

    private static String convertCharset(String charset, String str) throws UnsupportedEncodingException {
        return new String(str.getBytes("8859_1"), charset);
    }

    public static String getSuccessResponse() {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<response>\n");
        buf.append("<error>0</error>\n");
        buf.append("</response>");
        return buf.toString();
    }

    public static String getErrorResponse(String message) {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<response>\n");
        buf.append("<error>1</error>\n");
        buf.append("<message>").append(message).append("</message>\n");
        buf.append("</response>");
        return buf.toString();
    }

    public static boolean isRSSMode(HttpServletRequest request) {
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            String mode = request.getParameter("__mode");
            return "rss".equals(mode);
        }
        return false;
    }
}

