package com.ozacc.blog.rss.impl;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ozacc.blog.rss.Channel;
import com.ozacc.blog.rss.Item;

/**
 * Informa˰¸ʤozacc-blogȼʳƮ档
 * ޤΥ饹˽֤Ϥޤ
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: ChannelAdapter.java,v 1.1.2.1 2004/12/05 05:35:37 otsuka Exp $
 */
public class ChannelAdapter implements Channel, Serializable {

	private String title;

	private String language;

	private String creator;

	private String subject;

	private Date date;

	private String description;

	private URL link;

	private List items;

	/**
	 * 󥹥ȥ饯
	 */
	public ChannelAdapter() {
		super();
		items = new ArrayList();
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#getItems()
	 */
	public Item[] getItems() {
		return (Item[])items.toArray(new Item[items.size()]);
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#addItem(com.ozacc.blog.rss.Item)
	 */
	public void addItem(Item item) {
		items.add(item);
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#getTitle()
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#setTitle(java.lang.String)
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#getLink()
	 */
	public URL getLink() {
		return link;
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#setLink(java.net.URL)
	 */
	public void setLink(URL url) {
		this.link = url;
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#getDescription()
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#setDescription(java.lang.String)
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#newItem()
	 */
	public Item newItem() {
		return new ItemAdapter();
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#getLanguage()
	 */
	public String getLanguage() {
		return language;
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#setLanguage(java.lang.String)
	 */
	public void setLanguage(String language) {
		this.language = language;
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#getDate()
	 */
	public Date getDate() {
		return date;
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#setDate(java.util.Date)
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#getCreator()
	 */
	public String getCreator() {
		return creator;
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#setCreator(java.lang.String)
	 */
	public void setCreator(String creator) {
		this.creator = creator;
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#getSubject()
	 */
	public String getSubject() {
		return subject;
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#setSubject(java.lang.String)
	 */
	public void setSubject(String subject) {
		this.subject = subject;
	}

}